/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.logging.Level;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jorigin.Common;
import org.jorigin.jfx.JImageFeature;
import org.jorigin.jfx.JImageFeatureLayer;
import org.jorigin.jfx.JImageFeatureLayerListener;

public class JImageCanvas
extends Canvas
implements JImageFeatureLayerListener {
    public static final String MODE_SELECTION_PROPERTY = "MODE_SELECTION";
    public static final int MODE_SELECTION_NONE = 0;
    public static final int MODE_SELECTION_POINT = 1;
    public static final int MODE_SELECTION_RECTANGLE = 2;
    public static final int MODE_SELECTION_POLYGON = 4;
    public static final int MODE_SELECTION_ACTIVE_MASK = 7;
    public static final int FIT_NONE = 0;
    public static final int FIT_COMPLETE = 1;
    public static final int FIT_WIDTH = 2;
    public static final int FIT_HEIGHT = 3;
    public static final int FIT_AUTO = 4;
    private Image image = null;
    private IntegerProperty imageFitMethod = null;
    private IntegerProperty selectionMode = null;
    private Affine viewTransform;
    private Rotate viewRotation;
    private Scale viewScale;
    private Translate viewTranslation;
    private BooleanProperty viewTranslationClipping;
    private Insets viewInsets;
    private List<JImageFeatureLayer> layers;
    private Shape selectionShape = null;
    private Point2D selectionOrigin = null;
    private Paint selectionShapeStroke = null;
    private Paint selectionShapeFill = null;
    private ObjectProperty<Point2D> cursorPosition;
    private BooleanProperty autoRepaint;
    private BooleanProperty autoFit;
    private BooleanProperty needRefresh;
    private BooleanProperty listeningControls;
    private DoubleProperty zoomFactor;
    private ObjectProperty<Paint> backgroundPaint;
    private BooleanProperty controlPrimaryActive;
    private BooleanProperty controlSecondaryActive;
    private BooleanProperty resizableProperty = new SimpleBooleanProperty(true);
    private SynchronousQueue<Runnable> refreshQueue;
    private Semaphore refreshLock = new Semaphore(1);

    public double minHeight(double width) {
        return 0.0;
    }

    public double maxHeight(double width) {
        return Double.MAX_VALUE;
    }

    public double prefHeight(double width) {
        return this.minHeight(width);
    }

    public double minWidth(double height) {
        return 0.0;
    }

    public double maxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public void resize(double width, double height) {
        super.setWidth(width);
        super.setHeight(height);
    }

    public boolean isResizable() {
        return this.resizableProperty.get();
    }

    public void setResizable(boolean resizable) {
        this.resizableProperty.set(resizable);
    }

    @Override
    public void onImageFeatureAdded(JImageFeatureLayer layer, JImageFeature feature) {
        if (layer != null && feature != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    @Override
    public void onImageFeatureRemoved(JImageFeatureLayer layer, JImageFeature feature) {
        if (layer != null && feature != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    @Override
    public void onImageFeatureModified(JImageFeatureLayer layer, JImageFeature feature) {
        if (layer != null && feature != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    @Override
    public void onImageFeaturesAdded(JImageFeatureLayer layer, Collection<JImageFeature> features) {
        if (layer != null && features != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    @Override
    public void onImageFeaturesRemoved(JImageFeatureLayer layer, Collection<JImageFeature> features) {
        if (layer != null && features != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    @Override
    public void onImageFeatureModified(JImageFeatureLayer layer, Collection<JImageFeature> features) {
        if (layer != null && features != null) {
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    public JImageCanvas() {
        this(null, 0.0, 0.0, 4, 0, true, true, true);
    }

    public JImageCanvas(Image image) {
        this(image, 0.0, 0.0, 4, 0, true, true, true);
    }

    public JImageCanvas(Image image, double width, double height, int fit, int selection, boolean autoRepaint, boolean autoFit, boolean listeningControls) {
        super(width, height);
        this.imageFitMethod = new SimpleIntegerProperty(fit);
        this.selectionMode = new SimpleIntegerProperty(selection);
        this.selectionMode.addListener((observable, oldValue, newValue) -> {
            if (!oldValue.equals(newValue)) {
                this.selectionShape = null;
                if (newValue.intValue() == 1) {
                    this.selectionShape = null;
                } else if (newValue.intValue() == 2) {
                    this.selectionShape = new Rectangle();
                } else if (newValue.intValue() == 4) {
                    this.selectionShape = new Polygon();
                }
            }
        });
        this.selectionShapeFill = new Color(0.8, 0.0, 0.0, 0.5);
        this.selectionShapeStroke = new Color(0.8, 0.8, 0.0, 1.0);
        this.viewRotation = new Rotate();
        this.viewScale = new Scale();
        this.viewTranslation = new Translate();
        this.viewTransform = new Affine();
        this.viewTranslationClipping = new SimpleBooleanProperty(true);
        this.viewInsets = new Insets(20.0, 20.0, 20.0, 20.0);
        this.cursorPosition = new SimpleObjectProperty();
        this.autoRepaint = new SimpleBooleanProperty(autoRepaint);
        this.autoFit = new SimpleBooleanProperty(autoFit);
        this.listeningControls = new SimpleBooleanProperty(autoFit);
        this.zoomFactor = new SimpleDoubleProperty(0.01);
        this.backgroundPaint = new SimpleObjectProperty(null);
        this.needRefresh = new SimpleBooleanProperty(true);
        this.controlPrimaryActive = new SimpleBooleanProperty(false);
        this.controlSecondaryActive = new SimpleBooleanProperty(false);
        this.layers = new LinkedList<JImageFeatureLayer>();
        this.refreshQueue = new SynchronousQueue();
        if (image != null) {
            this.setImage(image);
        }
        this.initEventHandling();
        this.refresh();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            this.image = image;
            if (this.autoFit.get()) {
                this.viewFit();
            }
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
    }

    public IntegerProperty getImageFitMethodProperty() {
        return this.imageFitMethod;
    }

    public int getImageFitMethod() {
        return this.imageFitMethod.get();
    }

    public Bounds getImageBoundsInView() {
        if (this.image == null) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        Point2D imageUpperLeftInView = this.viewTransform.transform(new Point2D(0.0, 0.0));
        Point2D imageLowerLeftInView = this.viewTransform.transform(new Point2D(0.0, this.image.getHeight()));
        Point2D imageUpperRightInView = this.viewTransform.transform(new Point2D(this.image.getWidth(), 0.0));
        Point2D imageLowerRightInView = this.viewTransform.transform(new Point2D(this.image.getWidth(), this.image.getHeight()));
        Point2D boundsMin = new Point2D(Math.min(Math.min(imageUpperLeftInView.getX(), imageLowerLeftInView.getX()), Math.min(imageUpperRightInView.getX(), imageLowerRightInView.getX())), Math.min(Math.min(imageUpperLeftInView.getY(), imageLowerLeftInView.getY()), Math.min(imageUpperRightInView.getY(), imageLowerRightInView.getY())));
        Point2D boundsMax = new Point2D(Math.max(Math.max(imageUpperLeftInView.getX(), imageLowerLeftInView.getX()), Math.max(imageUpperRightInView.getX(), imageLowerRightInView.getX())), Math.max(Math.max(imageUpperLeftInView.getY(), imageLowerLeftInView.getY()), Math.max(imageUpperRightInView.getY(), imageLowerRightInView.getY())));
        return new BoundingBox(boundsMin.getX(), boundsMin.getY(), boundsMax.getX() - boundsMin.getX(), boundsMax.getY() - boundsMin.getY());
    }

    public void setImageFitMethod(int method) {
        if (method < 0 || method > 4) {
            throw new IllegalArgumentException("Invalid fit method " + method + ", expected values are FIT_NONE, FIT_COMPLETE, FIT_WIDTH, FIT_HEIGHT or FIT_AUTO.");
        }
        this.imageFitMethod.set(method);
    }

    public ObjectProperty<Point2D> getCursorPositionProperty() {
        return this.cursorPosition;
    }

    public Point2D getCursorPosition() {
        return (Point2D)this.cursorPosition.get();
    }

    public Insets getViewInsets() {
        return this.viewInsets;
    }

    public void setViewInsets(Insets insets) {
        this.viewInsets = insets;
    }

    public IntegerProperty getSelectionModeProperty() {
        return this.selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode.get();
    }

    public void setSelectionMode(int mode) {
        this.selectionMode.set(mode);
    }

    public Shape getSelectionShape() {
        return this.selectionShape;
    }

    public BooleanProperty getViewTranslationClippingProperty() {
        return this.viewTranslationClipping;
    }

    public boolean isViewTranslationClipping() {
        return this.viewTranslationClipping.get();
    }

    public void setViewTranslationClipping(boolean clip) {
        this.viewTranslationClipping.set(clip);
    }

    public double getRotation() {
        if (this.viewRotation != null) {
            return this.viewRotation.getAngle();
        }
        return 0.0;
    }

    public void setRotation(double angle) {
        if (this.viewRotation != null && this.viewRotation.getAngle() != angle && Double.isFinite(angle) && this.image != null) {
            Affine tmpTransform = new Affine();
            tmpTransform.setToIdentity();
            tmpTransform.append((Transform)this.viewScale);
            tmpTransform.append((Transform)this.viewRotation);
            double normalizedAngle = angle - (Math.ceil((angle + 180.0) / 360.0) - 1.0) * 360.0;
            Point2D rotTranslation = this.viewRotation.inverseTransform(this.viewTranslation.getX(), this.viewTranslation.getY());
            Point2D pivot = new Point2D(rotTranslation.getX() + this.getImage().getWidth() / 2.0, rotTranslation.getY() + this.getImage().getHeight() / 2.0);
            this.viewRotation.setAngle(normalizedAngle);
            this.viewRotation.setPivotX(pivot.getX());
            this.viewRotation.setPivotY(pivot.getY());
            this.viewTransformUpdate();
        }
    }

    public double getScale() {
        return this.viewScale.getX();
    }

    public void setScale(double scale) {
        if (this.viewScale.getX() != scale || this.viewScale.getY() != scale) {
            this.viewScale.setX(scale);
            this.viewScale.setY(scale);
            this.viewTransformUpdate();
        }
    }

    public Point2D getTranslation() {
        return new Point2D(this.viewTranslation.getTx(), this.viewTranslation.getTy());
    }

    public void setTranslation(Point2D translation) {
        if (translation != null && (this.viewTranslation.getX() != translation.getX() || this.viewTranslation.getY() != translation.getY())) {
            try {
                Affine transform = new Affine();
                transform.append((Transform)this.viewScale);
                transform.append((Transform)this.viewRotation);
                Point2D translationVectorImage = transform.inverseTransform(translation.getX(), translation.getY());
                this.viewTranslation.setX(translationVectorImage.getX());
                this.viewTranslation.setY(translationVectorImage.getY());
                this.viewTransformUpdate();
            }
            catch (Exception e) {
                Common.logger.log(Level.SEVERE, "Cannot invert view rotation / scale: " + e.getMessage(), e);
            }
        }
    }

    public void viewRotate(double angle) {
        if (angle != 0.0) {
            this.setRotation(this.viewRotation.getAngle() + angle);
        }
    }

    public void viewTranslate(Point2D vector) {
        if (this.image != null && this.viewTransform != null) {
            Bounds bounds = this.getImageBoundsInView();
            double boundedTranslationX = 0.0;
            double boundedTranslationY = 0.0;
            boolean clipping = true;
            if (clipping) {
                if (vector.getX() < 0.0) {
                    boundedTranslationX = Math.min(Math.max(this.getWidth() - bounds.getMaxX() - this.viewInsets.getRight(), vector.getX()), Math.max(-bounds.getMinX() + this.viewInsets.getLeft(), vector.getX()));
                } else if (vector.getX() > 0.0) {
                    boundedTranslationX = Math.max(Math.min(this.getWidth() - bounds.getMaxX() - this.viewInsets.getRight(), vector.getX()), Math.min(-bounds.getMinX() + this.viewInsets.getLeft(), vector.getX()));
                }
                if (vector.getY() < 0.0) {
                    boundedTranslationY = Math.min(Math.max(this.getHeight() - bounds.getMaxY() - this.viewInsets.getBottom(), vector.getY()), Math.max(-bounds.getMinY() + this.viewInsets.getTop(), vector.getY()));
                } else if (vector.getY() > 0.0) {
                    boundedTranslationY = Math.max(Math.min(this.getHeight() - bounds.getMaxY() - this.viewInsets.getBottom(), vector.getY()), Math.min(-bounds.getMinY() + this.viewInsets.getTop(), vector.getY()));
                }
            } else {
                boundedTranslationX = vector.getX();
                boundedTranslationY = vector.getY();
            }
            if (boundedTranslationX != 0.0 || boundedTranslationY != 0.0) {
                Affine transform = new Affine();
                transform.append((Transform)this.viewScale);
                transform.append((Transform)this.viewRotation);
                Point2D currentTranslationInView = transform.transform(new Point2D(this.viewTranslation.getX(), this.viewTranslation.getY()));
                this.setTranslation(new Point2D(currentTranslationInView.getX() + boundedTranslationX, currentTranslationInView.getY() + boundedTranslationY));
            }
        }
    }

    public boolean isAutoFit() {
        return this.autoFit.get();
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit.set(autoFit);
    }

    public final BooleanProperty getAutoFitProperty() {
        return this.autoFit;
    }

    public boolean isAutoRefresh() {
        return this.autoRepaint.get();
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRepaint.set(autoRefresh);
    }

    public BooleanProperty getAutoRefreshProperty() {
        return this.autoRepaint;
    }

    public boolean isListeningControls() {
        return this.listeningControls.get();
    }

    public void setListeningControls(boolean listening) {
        this.listeningControls.set(listening);
    }

    public BooleanProperty getListeningControlsProperty() {
        return this.listeningControls;
    }

    public boolean isRefreshNeeded() {
        return this.needRefresh.get();
    }

    public final BooleanProperty getRefreshNeededProperty() {
        return this.needRefresh;
    }

    public Paint getBackgroundPaint() {
        return (Paint)this.backgroundPaint.get();
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint.set((Object)paint);
    }

    public final ObjectProperty<Paint> getBackgroundPaintProperty() {
        return this.backgroundPaint;
    }

    public Point2D getImageCoordinate(double x, double y) {
        return this.getImageCoordinate(new Point2D(x, y));
    }

    public Point2D getImageCoordinate(Point2D point) {
        if (this.image != null && point != null) {
            if (point.getX() >= 0.0 && point.getX() < this.getWidth() && point.getY() >= 0.0 && point.getY() < this.getHeight()) {
                Point2D dest = new Point2D(0.0, 0.0);
                try {
                    dest = this.viewTransform.inverseTransform(point);
                    if (dest.getX() < 0.0 || dest.getX() >= this.image.getWidth() - 1.0 || dest.getY() < 0.0 || dest.getY() >= this.image.getHeight() - 1.0) {
                        dest = null;
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return dest;
            }
            return null;
        }
        return null;
    }

    public Point2D getViewCoordinate(Point2D point) {
        if (this.image != null && point != null) {
            if (this.viewTransform != null) {
                Point2D dest = new Point2D(0.0, 0.0);
                dest = this.viewTransform.transform(point);
                return dest;
            }
            return null;
        }
        return null;
    }

    public Point2D getViewCoordinate(double x, double y) {
        return this.getViewCoordinate(new Point2D(x, y));
    }

    public boolean isLayerDisplayed(String layer) {
        for (JImageFeatureLayer l : this.layers) {
            if (!l.getName().equals(layer)) continue;
            return l.isStateDisplaying();
        }
        return false;
    }

    public void setLayerDisplayed(String layer, boolean displayed) {
        for (JImageFeatureLayer l : this.layers) {
            if (!l.getName().equals(layer)) continue;
            l.setStateDisplaying(displayed);
        }
    }

    public boolean addImageFeatureLayer(JImageFeatureLayer layer) {
        if (layer == null) {
            return false;
        }
        if (this.layers.contains(layer)) {
            return false;
        }
        boolean b = this.layers.add(layer);
        if (b) {
            layer.addImageFeatureLayerListener(this);
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
        return b;
    }

    public boolean removeImageFeatureLayer(JImageFeatureLayer layer) {
        if (layer == null) {
            return false;
        }
        boolean b = this.layers.remove(layer);
        if (b) {
            layer.removeImageFeatureLayerListener(this);
            this.setNeedRefresh(true);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        }
        return b;
    }

    private void initEventHandling() {
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                JImageCanvas.this.setNeedRefresh(true);
                if (JImageCanvas.this.autoFit.get()) {
                    JImageCanvas.this.viewFit();
                }
                if (JImageCanvas.this.autoRepaint.get()) {
                    JImageCanvas.this.refresh();
                }
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                JImageCanvas.this.setNeedRefresh(true);
                if (JImageCanvas.this.autoFit.get()) {
                    JImageCanvas.this.viewFit();
                }
                if (JImageCanvas.this.autoRepaint.get()) {
                    JImageCanvas.this.refresh();
                }
            }
        });
        this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (JImageCanvas.this.listeningControls.get()) {
                    JImageCanvas.this.cursorPosition.set((Object)new Point2D(event.getX(), event.getY()));
                }
            }
        });
        this.setOnMousePressed(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.controlPrimaryActive.set(true);
                if ((this.selectionMode.get() | 7) != 0) {
                    this.selectionOrigin = (Point2D)this.cursorPosition.get();
                    if (this.selectionMode.get() == 1) {
                        this.selectionShape = null;
                    } else if (this.selectionMode.get() == 2) {
                        this.selectionShape = new Rectangle();
                    } else if (this.selectionMode.get() == 4) {
                        this.selectionShape = new Polygon();
                    }
                }
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                this.controlSecondaryActive.set(true);
            }
        });
        this.setOnMouseReleased(event -> {
            boolean refreshNeeded = false;
            if (event.getButton() == MouseButton.PRIMARY) {
                if ((this.selectionMode.get() | 7) != 0 && this.selectionShape != null) {
                    this.select(this.selectionShape);
                }
                if (this.selectionShape != null) {
                    this.selectionShape = null;
                    refreshNeeded = true;
                }
                this.selectionOrigin = null;
                this.controlPrimaryActive.set(false);
            }
            if (event.getButton() == MouseButton.SECONDARY) {
                this.controlSecondaryActive.set(false);
            }
            this.setNeedRefresh(refreshNeeded);
            if (this.autoRepaint.get()) {
                this.refresh();
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (JImageCanvas.this.listeningControls.get()) {
                    Point2D tmpCursorPosition = new Point2D(event.getX(), event.getY());
                    Point2D cursorMove = tmpCursorPosition.subtract((Point2D)JImageCanvas.this.cursorPosition.get());
                    if (JImageCanvas.this.selectionMode.get() == 0 || JImageCanvas.this.selectionMode.get() == 1) {
                        if (JImageCanvas.this.controlPrimaryActive.get()) {
                            JImageCanvas.this.viewTranslate(cursorMove);
                            if (JImageCanvas.this.autoRepaint.get()) {
                                JImageCanvas.this.refresh();
                            }
                        }
                    } else if ((JImageCanvas.this.selectionMode.get() & 2) == 2) {
                        if (JImageCanvas.this.controlSecondaryActive.get()) {
                            JImageCanvas.this.viewTranslate(cursorMove);
                        }
                        if (JImageCanvas.this.controlPrimaryActive.get() && JImageCanvas.this.selectionShape != null) {
                            Point2D upperLeft = new Point2D(Math.max(0.0, Math.min(JImageCanvas.this.selectionOrigin.getX(), tmpCursorPosition.getX())), Math.max(0.0, Math.min(JImageCanvas.this.selectionOrigin.getY(), tmpCursorPosition.getY())));
                            Point2D lowerRight = new Point2D(Math.min(JImageCanvas.this.getWidth(), Math.max(JImageCanvas.this.selectionOrigin.getX(), tmpCursorPosition.getX())), Math.min(JImageCanvas.this.getHeight(), Math.max(JImageCanvas.this.selectionOrigin.getY(), tmpCursorPosition.getY())));
                            Rectangle rectangle = (Rectangle)JImageCanvas.this.selectionShape;
                            rectangle.setX(upperLeft.getX());
                            rectangle.setY(upperLeft.getY());
                            rectangle.setWidth(lowerRight.getX() - upperLeft.getX());
                            rectangle.setHeight(lowerRight.getY() - upperLeft.getY());
                            JImageCanvas.this.setNeedRefresh(true);
                        }
                        if (JImageCanvas.this.autoRepaint.get()) {
                            JImageCanvas.this.refresh();
                        }
                    } else if ((JImageCanvas.this.selectionMode.get() & 4) == 4) {
                        // empty if block
                    }
                    JImageCanvas.this.cursorPosition.set((Object)tmpCursorPosition);
                }
            }
        });
        this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (JImageCanvas.this.listeningControls.get()) {
                    // empty if block
                }
            }
        });
        this.setOnZoomFinished((EventHandler)new EventHandler<ZoomEvent>(){

            public void handle(ZoomEvent event) {
                if (JImageCanvas.this.listeningControls.get()) {
                    JImageCanvas.this.setScale(event.getTotalZoomFactor());
                }
            }
        });
        this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                if (JImageCanvas.this.listeningControls.get()) {
                    double delta = event.getDeltaY();
                    if (delta > 0.0) {
                        JImageCanvas.this.setScale(JImageCanvas.this.getScale() + JImageCanvas.this.zoomFactor.get());
                    } else if (JImageCanvas.this.getScale() - JImageCanvas.this.zoomFactor.get() > 0.0) {
                        JImageCanvas.this.setScale(JImageCanvas.this.getScale() - JImageCanvas.this.zoomFactor.get());
                    }
                }
            }
        });
    }

    public void viewFit() {
        if (this.image != null && this.getWidth() != 0.0 && this.getHeight() != 0.0 && this.image.getWidth() != 0.0 && this.image.getHeight() != 0.0) {
            Point2D imageUpperLeftInView = this.viewRotation.transform(new Point2D(0.0, 0.0));
            Point2D imageLowerLeftInView = this.viewRotation.transform(new Point2D(0.0, this.image.getHeight()));
            Point2D imageUpperRightInView = this.viewRotation.transform(new Point2D(this.image.getWidth(), 0.0));
            Point2D imageLowerRightInView = this.viewRotation.transform(new Point2D(this.image.getWidth(), this.image.getHeight()));
            Point2D boundsMin = new Point2D(Math.min(Math.min(imageUpperLeftInView.getX(), imageLowerLeftInView.getX()), Math.min(imageUpperRightInView.getX(), imageLowerRightInView.getX())), Math.min(Math.min(imageUpperLeftInView.getY(), imageLowerLeftInView.getY()), Math.min(imageUpperRightInView.getY(), imageLowerRightInView.getY())));
            Point2D boundsMax = new Point2D(Math.max(Math.max(imageUpperLeftInView.getX(), imageLowerLeftInView.getX()), Math.max(imageUpperRightInView.getX(), imageLowerRightInView.getX())), Math.max(Math.max(imageUpperLeftInView.getY(), imageLowerLeftInView.getY()), Math.max(imageUpperRightInView.getY(), imageLowerRightInView.getY())));
            BoundingBox bounds = new BoundingBox(boundsMin.getX(), boundsMin.getY(), boundsMax.getX() - boundsMin.getX(), boundsMax.getY() - boundsMin.getY());
            if (this.imageFitMethod.get() == 1) {
                sx = (this.getWidth() - this.viewInsets.getLeft() - this.viewInsets.getRight()) / bounds.getWidth();
                double sy = (this.getHeight() - this.viewInsets.getTop() - this.viewInsets.getBottom()) / bounds.getHeight();
                this.viewScale.setX(sx);
                this.viewScale.setY(sy);
            } else if (this.imageFitMethod.get() == 2) {
                scale = (this.getWidth() - this.viewInsets.getLeft() - this.viewInsets.getRight()) / bounds.getWidth();
                this.viewScale.setX(scale);
                this.viewScale.setY(scale);
            } else if (this.imageFitMethod.get() == 3) {
                scale = (this.getHeight() - this.viewInsets.getTop() - this.viewInsets.getBottom()) / bounds.getHeight();
                this.viewScale.setX(scale);
                this.viewScale.setY(scale);
            } else if (this.imageFitMethod.get() == 4) {
                sx = (this.getWidth() - this.viewInsets.getLeft() - this.viewInsets.getRight()) / bounds.getWidth();
                double sy = (this.getHeight() - this.viewInsets.getTop() - this.viewInsets.getBottom()) / bounds.getHeight();
                double scale = Math.min(sx, sy);
                this.viewScale.setX(scale);
                this.viewScale.setY(scale);
            }
            this.viewTranslation.setX(0.0);
            this.viewTranslation.setY(0.0);
            this.viewTranslation.setZ(0.0);
            this.viewTransform.setToIdentity();
            this.viewTransform.append((Transform)this.viewScale);
            this.viewTransform.append((Transform)this.viewRotation);
            this.viewTransform.append((Transform)this.viewTranslation);
            Point2D fittedBoundsMinV = new Point2D(-bounds.getMinX() * this.viewScale.getX() + this.viewInsets.getLeft(), -bounds.getMinY() * this.viewScale.getY() + this.viewInsets.getTop());
            this.viewTranslate(fittedBoundsMinV);
        }
    }

    public void refreshEnqueue(Runnable task) throws InterruptedException {
        if (task != null) {
            this.refreshQueue.put(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshLock.tryAcquire();
            if (this.needRefresh.get()) {
                Paint originalFillPaint = this.getGraphicsContext2D().getFill();
                Paint originalStrokePaint = this.getGraphicsContext2D().getStroke();
                Affine originalTransform = this.getGraphicsContext2D().getTransform();
                if (this.backgroundPaint.get() != null) {
                    this.getGraphicsContext2D().setFill((Paint)this.backgroundPaint.get());
                    this.getGraphicsContext2D().fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
                    this.getGraphicsContext2D().setFill(originalFillPaint);
                } else {
                    this.getGraphicsContext2D().clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
                }
                this.getGraphicsContext2D().setTransform(this.viewTransform);
                if (this.image != null) {
                    this.getGraphicsContext2D().drawImage(this.image, 0.0, 0.0);
                }
                for (JImageFeatureLayer layer : this.layers) {
                    List<JImageFeature> displayingFeatures;
                    if (!layer.isStateDisplaying() || (displayingFeatures = layer.getImageFeatures()) == null) continue;
                    for (JImageFeature feature : displayingFeatures) {
                        if (!feature.isStateDisplaying()) continue;
                        feature.draw(this.getGraphicsContext2D(), this.viewTransform);
                    }
                }
                this.getGraphicsContext2D().setTransform(originalTransform);
                if (this.selectionShape != null) {
                    if (this.selectionShape instanceof Rectangle) {
                        Rectangle rectangle = (Rectangle)this.selectionShape;
                        if (this.selectionShapeFill != null) {
                            this.getGraphicsContext2D().setFill(this.selectionShapeFill);
                            this.getGraphicsContext2D().fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
                        }
                        if (this.selectionShapeStroke != null) {
                            this.getGraphicsContext2D().setStroke(this.selectionShapeStroke);
                            this.getGraphicsContext2D().strokeRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
                        }
                    }
                    this.getGraphicsContext2D().setFill(originalFillPaint);
                    this.getGraphicsContext2D().setStroke(originalStrokePaint);
                }
                while (!this.refreshQueue.isEmpty()) {
                    try {
                        this.refreshQueue.take().run();
                    }
                    catch (InterruptedException e) {
                        Common.logger.log(Level.WARNING, "Cannot run task: " + e.getMessage(), e);
                    }
                }
                this.needRefresh.set(false);
            }
        }
        finally {
            this.refreshLock.release();
        }
    }

    private void setNeedRefresh(boolean value) {
        try {
            this.refreshLock.acquire();
            this.needRefresh.set(value);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.refreshLock.release();
        }
    }

    public void select(Shape shape) {
        try {
            shape.getTransforms().add((Object)this.viewTransform.createInverse());
            for (JImageFeatureLayer layer : this.layers) {
                List<JImageFeature> features;
                if (!layer.isStateDisplaying() || (features = layer.getImageFeatures()) == null) continue;
                for (JImageFeature feature : features) {
                    if (!feature.isStateSelectable()) continue;
                    if (feature.inside(shape)) {
                        feature.setStateSelected(true);
                        continue;
                    }
                    feature.setStateSelected(false);
                }
            }
        }
        catch (NonInvertibleTransformException e) {
            Common.logger.log(Level.SEVERE, "Cannot select: " + e.getMessage(), e);
        }
    }

    private void viewTransformUpdate() {
        this.viewTransform.setToIdentity();
        this.viewTransform.append((Transform)this.viewScale);
        this.viewTransform.append((Transform)this.viewRotation);
        this.viewTransform.append((Transform)this.viewTranslation);
        Common.logger.log(Level.FINE, "Scale");
        Common.logger.log(Level.FINE, "  - x     : " + this.viewScale.getX());
        Common.logger.log(Level.FINE, "  - y     : " + this.viewScale.getY());
        Common.logger.log(Level.FINE, "  - Pivot : (" + this.viewScale.getPivotX() + ", " + this.viewScale.getPivotY() + ", " + this.viewScale.getPivotZ() + ")");
        Common.logger.log(Level.FINE, "Rotation");
        Common.logger.log(Level.FINE, "  - Angle : " + this.viewRotation.getAngle());
        Common.logger.log(Level.FINE, "  - Axis  : " + String.valueOf(this.viewRotation.getAxis()));
        Common.logger.log(Level.FINE, "  - Pivot : (" + this.viewRotation.getPivotX() + ", " + this.viewRotation.getPivotY() + ", " + this.viewRotation.getPivotZ() + ")");
        Common.logger.log(Level.FINE, "Translation");
        Common.logger.log(Level.FINE, "  - Vector : (" + this.viewTranslation.getX() + ", " + this.viewTranslation.getY() + ", " + this.viewTranslation.getZ() + ")");
        Common.logger.log(Level.FINE, "");
        Common.logger.log(Level.FINE, "[ " + this.viewTransform.getMxx() + " " + this.viewTransform.getMxy() + " " + this.viewTransform.getMxz() + " " + this.viewTransform.getTx() + " ]");
        Common.logger.log(Level.FINE, "[ " + this.viewTransform.getMyx() + " " + this.viewTransform.getMyy() + " " + this.viewTransform.getMyz() + " " + this.viewTransform.getTy() + " ]");
        Common.logger.log(Level.FINE, "[ " + this.viewTransform.getMzx() + " " + this.viewTransform.getMzy() + " " + this.viewTransform.getMzz() + " " + this.viewTransform.getTz() + " ]");
        Common.logger.log(Level.FINE, "[ 0.0 0.0 0.0 1.0 ]");
        this.setNeedRefresh(true);
        if (this.autoRepaint.get()) {
            this.refresh();
        }
    }
}

