/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jorigin.identification.Named;
import org.jorigin.jfx.JImageFeature;
import org.jorigin.jfx.JImageFeatureLayerListener;
import org.jorigin.state.HandleDisplay;
import org.jorigin.state.HandleSelection;

public class JImageFeatureLayer
implements HandleSelection,
HandleDisplay,
Named {
    private boolean selectable = true;
    private boolean selected = false;
    private boolean displayable = true;
    private boolean displaying = false;
    private String name;
    private List<JImageFeature> features = null;
    private List<JImageFeatureLayerListener> layerListeners;

    public boolean isStateDisplaying() {
        return this.displaying;
    }

    public void setStateDisplaying(boolean displaying) {
        this.displaying = displaying;
    }

    public boolean isStateDisplayable() {
        return this.displayable;
    }

    public void setStateDisplayable(boolean displayable) {
        this.displayable = displayable;
    }

    public boolean isStateSelected() {
        return this.selected;
    }

    public void setStateSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isStateSelectable() {
        return this.selectable;
    }

    public void setStateSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JImageFeatureLayer(String name) {
        this(name, null, true, false, true, true);
    }

    public JImageFeatureLayer(String name, Collection<JImageFeature> features, boolean selectable, boolean selected, boolean displayable, boolean displaying) {
        this.setName(name);
        this.setStateSelectable(selectable);
        this.setStateSelected(selectable);
        this.setStateDisplayable(displayable);
        this.setStateDisplaying(displaying);
        this.features = features != null && features.size() > 0 ? new ArrayList<JImageFeature>(features) : new LinkedList<JImageFeature>();
        this.layerListeners = new LinkedList<JImageFeatureLayerListener>();
    }

    public List<JImageFeature> getImageFeatures() {
        return this.features;
    }

    public void setImageFeatures(Collection<JImageFeature> features) {
        boolean b;
        if (this.features.size() > 0) {
            for (JImageFeature feature : this.features) {
                feature.setImageFeatureLayer(null);
            }
            this.features.clear();
            this.fireOnImageFeaturesRemoved(this.features);
        }
        if (features != null && (b = this.features.addAll(features))) {
            for (JImageFeature feature : features) {
                feature.setImageFeatureLayer(this);
            }
            this.fireOnImageFeaturesAdded(features);
        }
    }

    public boolean addImageFeature(JImageFeature feature) {
        if (feature == null) {
            return false;
        }
        boolean b = this.features.add(feature);
        if (b) {
            feature.setImageFeatureLayer(this);
            this.fireOnImageFeatureAdded(feature);
        }
        return b;
    }

    public boolean addImageFeatures(Collection<JImageFeature> features) {
        if (features == null) {
            return false;
        }
        boolean b = features.addAll(features);
        if (b) {
            for (JImageFeature feature : features) {
                feature.setImageFeatureLayer(this);
            }
            this.fireOnImageFeaturesAdded(features);
        }
        return b;
    }

    public boolean removeImageFeature(JImageFeature feature) {
        if (feature == null) {
            return false;
        }
        boolean b = this.features.remove(feature);
        if (b) {
            feature.setImageFeatureLayer(null);
            this.fireOnImageFeatureRemoved(feature);
        }
        return b;
    }

    public boolean removeImageFeatures(Collection<JImageFeature> features) {
        if (features == null) {
            return false;
        }
        boolean b = features.removeAll(features);
        if (b) {
            for (JImageFeature feature : features) {
                feature.setImageFeatureLayer(null);
            }
            this.fireOnImageFeaturesRemoved(features);
        }
        return b;
    }

    public boolean addImageFeatureLayerListener(JImageFeatureLayerListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.layerListeners.contains(listener)) {
            return false;
        }
        return this.layerListeners.add(listener);
    }

    public boolean removeImageFeatureLayerListener(JImageFeatureLayerListener listener) {
        if (listener == null) {
            return false;
        }
        return this.layerListeners.remove(listener);
    }

    protected void fireOnImageFeatureAdded(JImageFeature feature) {
        for (JImageFeatureLayerListener listener : this.layerListeners) {
            listener.onImageFeatureAdded(this, feature);
        }
    }

    protected void fireOnImageFeatureRemoved(JImageFeature feature) {
        for (JImageFeatureLayerListener listener : this.layerListeners) {
            listener.onImageFeatureRemoved(this, feature);
        }
    }

    protected void fireOnImageFeaturesAdded(Collection<JImageFeature> features) {
        for (JImageFeatureLayerListener listener : this.layerListeners) {
            listener.onImageFeaturesAdded(this, features);
        }
    }

    protected void fireOnImageFeaturesRemoved(Collection<JImageFeature> features) {
        for (JImageFeatureLayerListener listener : this.layerListeners) {
            listener.onImageFeaturesRemoved(this, features);
        }
    }

    public void onImageFeatureModified(JImageFeature feature) {
        for (JImageFeatureLayerListener listener : this.layerListeners) {
            listener.onImageFeatureModified(this, this.features);
        }
    }
}

