/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx.control;

import java.util.concurrent.CompletableFuture;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public class MouseClickFilter
implements EventHandler<MouseEvent> {
    private long clickDelay = 200L;
    private EventHandler<? super MouseEvent> handler = null;
    private long lastClickTime = 0L;
    private int consecutiveClickCount = 0;
    private MouseEvent currentEvent;
    private boolean timerRunning = true;
    private Runnable timer;

    public MouseClickFilter(EventHandler<? super MouseEvent> handler) {
        this.setMouseClickEventHandler(handler);
    }

    public MouseClickFilter(long delay, EventHandler<? super MouseEvent> handler) {
        this.setMouseClickEventHandler(handler);
    }

    public EventHandler<? super MouseEvent> getMouseClickEventHandler() {
        return this.handler;
    }

    public void setMouseClickEventHandler(EventHandler<? super MouseEvent> handler) {
        this.handler = handler;
    }

    public long getClickDelay() {
        return this.clickDelay;
    }

    public void setClickDelay(long delay) {
        this.clickDelay = delay;
    }

    public void handle(MouseEvent e) {
        long currentClickTime = System.currentTimeMillis();
        if (this.consecutiveClickCount == 0) {
            this.timer = new Runnable(){

                @Override
                public void run() {
                    while (MouseClickFilter.this.timerRunning) {
                        MouseClickFilter.this.timerRunning = false;
                        try {
                            Thread.sleep(MouseClickFilter.this.clickDelay);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    MouseClickFilter.this.handler.handle((Event)MouseClickFilter.this.currentEvent);
                    MouseClickFilter.this.consecutiveClickCount = 0;
                }
            };
            this.consecutiveClickCount = 1;
            this.timerRunning = true;
            CompletableFuture.runAsync(this.timer);
        } else if (currentClickTime - this.lastClickTime <= this.clickDelay) {
            ++this.consecutiveClickCount;
            this.timerRunning = true;
        }
        this.currentEvent = e;
        this.lastClickTime = currentClickTime;
    }
}

