/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx.icon;

import java.lang.invoke.MethodHandles;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Screen;
import org.jorigin.io.IOStreamUtil;
import org.jorigin.lang.PathUtil;

public final class IconLoader {
    private static Logger logger = Logger.getLogger(IconLoader.class.getName());
    public static int PATH_TYPE_UNKNOWN = 0;
    public static int PATH_TYPE_FILESYSTEM = 1;
    public static int PATH_TYPE_URL = 2;
    public static int PATH_TYPE_EMBEDDED_JAR = 4;
    public static int PATH_TYPE_EMBEDDED_ZIP = 4;
    private static String iconDirectory = "/";
    private static int pathType = 0;

    public static Image getIcon(String path) {
        Image image = null;
        if (PathUtil.isAbsolutePath((String)path)) {
            String processedPath = PathUtil.URIToPath((String)path);
            try {
                image = new Image(processedPath);
                if (image.getWidth() < 1.0) {
                    image = null;
                    logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Icon " + processedPath + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
            if (image != null) {
                return image;
            }
            Class<?> c = MethodHandles.lookup().lookupClass();
            URL url = c.getResource(path);
            if (url == null) {
                logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                return null;
            }
            try {
                image = new Image(url.toExternalForm());
                if (image.getWidth() < 1.0) {
                    image = null;
                    logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
        } else if (iconDirectory != null && !iconDirectory.isEmpty()) {
            if (pathType == PATH_TYPE_EMBEDDED_JAR) {
                String inputFile = iconDirectory + path;
                try {
                    URL inputURL = new URI(inputFile).toURL();
                    JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                    image = new Image(conn.getInputStream());
                    if (image.getWidth() < 1.0) {
                        image = null;
                        logger.log(Level.WARNING, "Icon " + inputURL.toExternalForm() + " is not a valid image file.");
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Icon " + inputFile + " cannot be loaded: " + ex.getMessage(), ex);
                    image = null;
                }
            } else {
                if (pathType == PATH_TYPE_EMBEDDED_ZIP) {
                    logger.log(Level.WARNING, "Icon " + path + " load from ZIP file is not handled.");
                    return null;
                }
                String processedPath = iconDirectory + path;
                try {
                    image = new Image(IOStreamUtil.getInputStream((String)processedPath));
                    if (image.getWidth() < 1.0) {
                        image = null;
                        logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                    }
                }
                catch (Exception ex) {
                    image = null;
                }
                if (image == null) {
                    Class<?> c = MethodHandles.lookup().lookupClass();
                    URL url = c.getResource(iconDirectory + path);
                    if (url == null) {
                        logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                        return null;
                    }
                    try {
                        image = new Image(url.toExternalForm());
                        if (image.getWidth() < 1.0) {
                            image = null;
                            logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                        image = null;
                    }
                }
            }
        } else {
            String processedPath = PathUtil.URIToPath((String)path);
            try {
                image = new Image(IOStreamUtil.getInputStream((String)processedPath));
                if (image.getWidth() < 1.0) {
                    image = null;
                    logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Icon " + processedPath + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
            if (image != null) {
                return image;
            }
            Class<?> c = MethodHandles.lookup().lookupClass();
            URL url = c.getResource(path);
            if (url == null) {
                logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                return null;
            }
            try {
                image = new Image(url.toExternalForm());
                if (image.getWidth() < 1.0) {
                    image = null;
                    logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
        }
        return image;
    }

    public static ImageView getScaledIconView(String name, Dimension2D dimension) {
        Image icon = IconLoader.getIcon(name);
        if (icon != null) {
            double dpi = Screen.getPrimary().getDpi() / 25.4;
            ImageView imageView = new ImageView(icon);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(true);
            imageView.setFitWidth(dimension.getWidth() * dpi);
            imageView.setFitHeight(dimension.getHeight() * dpi);
            return imageView;
        }
        return null;
    }

    public static Image getScaledIcon(String name, Dimension2D dimension) {
        Image icon = IconLoader.getIcon(name);
        if (icon != null) {
            double dpi = Screen.getPrimary().getDpi() / 25.4;
            ImageView imageView = new ImageView(icon);
            imageView.setPreserveRatio(false);
            imageView.setFitWidth(dimension.getWidth() * dpi);
            imageView.setFitHeight(dimension.getHeight() * dpi);
            imageView.setSmooth(true);
            return imageView.snapshot(null, null);
        }
        return null;
    }

    public static Image getScaledIcon(String name, double width, double height) {
        return IconLoader.getScaledIcon(name, new Dimension2D(width, height));
    }

    public static String getIconDirectory() {
        return iconDirectory;
    }

    public static void setIconDirectory(String path) {
        if (path != null) {
            String lowerPath = path.toLowerCase();
            if (lowerPath.startsWith("file:") || lowerPath.startsWith("http:") || lowerPath.startsWith("https:") || lowerPath.startsWith("ftp:") || lowerPath.startsWith("sftp:")) {
                pathType = PATH_TYPE_URL;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (lowerPath.startsWith("jar:")) {
                pathType = PATH_TYPE_EMBEDDED_JAR;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (PathUtil.isAbsolutePath((String)lowerPath)) {
                pathType = PATH_TYPE_FILESYSTEM;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (lowerPath.startsWith("zip:")) {
                pathType = PATH_TYPE_EMBEDDED_ZIP;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else {
                pathType = PATH_TYPE_UNKNOWN;
                iconDirectory = path;
            }
            logger.log(Level.INFO, "Using icon path " + path + " (" + pathType + ")");
        } else {
            iconDirectory = null;
            logger.log(Level.INFO, "No icon path set " + path);
        }
    }
}

