/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx.thumbnail;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import org.jorigin.identification.Named;
import org.jorigin.jfx.thumbnail.JThumbnailStyle;
import org.jorigin.state.HandleSelection;

public class JThumbnail<T>
extends BorderPane
implements Named,
HandleSelection {
    private String name = null;
    private T content = null;
    private ImageView view;
    private StackPane imagePane = null;
    private Label nameLB = null;
    private BorderPane namePN = null;
    private JThumbnailStyle style = null;
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private BooleanProperty selectable = new SimpleBooleanProperty(true);
    private double margin = 5.0;

    public JThumbnail(String name, T content, Image image, JThumbnailStyle style) {
        this.getStyleClass().setAll((Object[])new String[]{"list-cell"});
        this.content = content;
        this.name = name;
        this.imagePane = new StackPane();
        this.nameLB = new Label(this.name);
        this.setCenter((Node)this.imagePane);
        if (style != null) {
            this.setThumbnailStyle(style);
            if (style.isThumbnailNameVisible()) {
                this.nameLB.setBackground(style.getThumbnailNameBackground());
                this.namePN = new BorderPane();
                this.namePN.setCenter((Node)this.nameLB);
                this.setBottom((Node)this.namePN);
            }
        }
        this.imagePane.widthProperty().addListener(e -> this.fitImage(this.imagePane.getWidth(), this.imagePane.getHeight()));
        this.imagePane.heightProperty().addListener(e -> this.fitImage(this.imagePane.getWidth(), this.imagePane.getHeight()));
        this.setThumbnailImage(image);
        this.selected.addListener(e -> this.applyStyle());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStateSelected() {
        return this.selected.get();
    }

    public void setStateSelected(boolean selected) {
        this.selected.set(selected);
    }

    public boolean isStateSelectable() {
        return this.selectable.get();
    }

    public void setStateSelectable(boolean selectable) {
        this.selectable.set(selectable);
    }

    public T getThumbnailContent() {
        return this.content;
    }

    public void setThumbnailImage(Image image) {
        if (image == null) {
            return;
        }
        if (this.view != null && this.view.getImage() == image) {
            return;
        }
        ImageView newView = new ImageView(image);
        newView.setPreserveRatio(false);
        if (this.margin > 0.0) {
            newView.setFitWidth(this.getPrefWidth() - 2.0 * this.margin);
            newView.setFitHeight(this.getPrefHeight() - 2.0 * this.margin);
        }
        this.view = newView;
        this.view.setCache(true);
        this.view.setCacheHint(CacheHint.SPEED);
        Platform.runLater(() -> {
            this.imagePane.getChildren().clear();
            this.imagePane.getChildren().add((Object)this.view);
        });
    }

    public void setThumbnailStyle(JThumbnailStyle style) {
        if (this.style == style) {
            return;
        }
        if (this.style != null) {
            this.minWidthProperty().unbind();
            this.maxWidthProperty().unbind();
            this.prefWidthProperty().unbind();
            this.minHeightProperty().unbind();
            this.maxHeightProperty().unbind();
            this.prefHeightProperty().unbind();
        }
        this.style = style;
        if (this.style != null) {
            if (style.thumbnailWidthProperty() != null) {
                this.minWidthProperty().bind((ObservableValue)style.thumbnailWidthProperty());
                this.maxWidthProperty().bind((ObservableValue)style.thumbnailWidthProperty());
                this.prefWidthProperty().bind((ObservableValue)style.thumbnailWidthProperty());
            }
            if (style.thumbnailHeightProperty() != null) {
                this.minHeightProperty().bind((ObservableValue)style.thumbnailHeightProperty());
                this.maxHeightProperty().bind((ObservableValue)style.thumbnailHeightProperty());
                this.prefHeightProperty().bind((ObservableValue)style.thumbnailHeightProperty());
            }
            this.applyStyle();
        }
    }

    private void applyStyle() {
        if (this.style != null) {
            if (this.selected.get()) {
                this.imagePane.setBackground(this.style.getThumbnailSelectedImageBackground());
                this.nameLB.setBackground(this.style.getThumbnailSelectedNameBackground());
                this.backgroundProperty().set((Object)((Background)this.style.thumbnailSelectedBackgroundProperty().get()));
            } else {
                this.imagePane.setBackground(this.style.getThumbnailImageBackground());
                this.nameLB.setBackground(this.style.getThumbnailNameBackground());
                this.backgroundProperty().set((Object)((Background)this.style.thumbnailBackgroundProperty().get()));
            }
        }
    }

    private void fitImage(double width, double height) {
        if (this.view == null) {
            return;
        }
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        this.view.setFitWidth(width - 2.0 * this.margin);
        this.view.setFitHeight(height - 2.0 * this.margin);
    }
}

