/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx.thumbnail;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.TilePane;
import org.jorigin.jfx.control.MouseClickFilter;
import org.jorigin.jfx.thumbnail.JThumbnail;
import org.jorigin.jfx.thumbnail.JThumbnailActivationHandler;
import org.jorigin.jfx.thumbnail.JThumbnailSelectionHandler;
import org.jorigin.jfx.thumbnail.JThumbnailStyle;

public class JThumbnailPane<T>
extends BorderPane {
    private ObservableList<JThumbnail<T>> thumbnails = null;
    private FilteredList<JThumbnail<T>> filteredThumbnails = null;
    private ObservableList<JThumbnail<T>> selectedThumbnails = null;
    private TilePane tilePane = null;
    private ScrollPane scrollPane = null;
    private ObjectProperty<JThumbnailStyle> thumbnailStyle = null;
    private ObjectProperty<Predicate<? super T>> thumbnailFilter = null;
    private MouseClickFilter mouseClickFilter = null;
    private JThumbnail<T> selectionLastThumbnail = null;
    private ObservableList<JThumbnailActivationHandler<T>> activationHandlers;
    private ObservableList<JThumbnailSelectionHandler<T>> selectionHandlers;

    public JThumbnailPane() {
        this(true, null);
    }

    public JThumbnailPane(JThumbnailStyle style) {
        this(true, style);
    }

    public JThumbnailPane(boolean scrollable, JThumbnailStyle style) {
        this.getStyleClass().setAll((Object[])new String[]{"list-view"});
        this.mouseClickFilter = new MouseClickFilter((EventHandler<? super MouseEvent>)((EventHandler)e -> this.processMouseClickedEvent((MouseEvent)e)));
        this.thumbnails = FXCollections.observableArrayList();
        this.filteredThumbnails = new FilteredList(this.thumbnails);
        this.selectedThumbnails = FXCollections.observableArrayList();
        this.tilePane = new TilePane();
        this.tilePane.setCache(true);
        this.tilePane.setCacheHint(CacheHint.SPEED);
        this.setOnMouseClicked(e -> this.processMouseClickedEvent((MouseEvent)e));
        if (scrollable) {
            this.scrollPane = new ScrollPane();
            this.scrollPane.setFitToWidth(true);
            this.scrollPane.setContent((Node)this.tilePane);
            this.setCenter((Node)this.scrollPane);
        } else {
            this.setCenter((Node)this.tilePane);
        }
        this.setStyle(style);
    }

    public boolean addThumbnailActivationHandler(JThumbnailActivationHandler<T> handler) {
        boolean ok = false;
        if (handler != null) {
            if (this.activationHandlers == null) {
                this.activationHandlers = FXCollections.observableArrayList();
            }
            if (!this.activationHandlers.contains(handler)) {
                ok = this.activationHandlers.add(handler);
            }
        }
        return ok;
    }

    public boolean removeThumbnailActivationHandler(JThumbnailActivationHandler<T> handler) {
        boolean ok = false;
        if (handler != null && this.activationHandlers != null) {
            ok = this.activationHandlers.remove(handler);
        }
        return ok;
    }

    public boolean addThumbnailSelectionHandler(JThumbnailSelectionHandler<T> handler) {
        boolean ok = false;
        if (handler != null) {
            if (this.selectionHandlers == null) {
                this.selectionHandlers = FXCollections.observableArrayList();
            }
            if (!this.selectionHandlers.contains(handler)) {
                ok = this.selectionHandlers.add(handler);
            }
        }
        return ok;
    }

    public boolean removeThumbnailSelectionHandler(JThumbnailSelectionHandler<T> handler) {
        boolean ok = false;
        if (handler != null && this.selectionHandlers != null) {
            ok = this.selectionHandlers.remove(handler);
        }
        return ok;
    }

    public final ObjectProperty<Predicate<? super T>> thumbnailFilterProperty() {
        if (this.thumbnailFilter == null) {
            this.thumbnailFilter = new ObjectPropertyBase<Predicate<? super T>>(){

                protected void invalidated() {
                    JThumbnailPane.this.filter();
                }

                public Object getBean() {
                    return JThumbnailPane.this;
                }

                public String getName() {
                    return "filter";
                }
            };
        }
        return this.thumbnailFilter;
    }

    public final ObjectProperty<JThumbnailStyle> thumbnailStyleProperty() {
        if (this.thumbnailStyle == null) {
            this.thumbnailStyle = new ObjectPropertyBase<JThumbnailStyle>(){

                protected void invalidated() {
                    JThumbnailPane.this.filter();
                }

                public Object getBean() {
                    return JThumbnailPane.this;
                }

                public String getName() {
                    return "filter";
                }
            };
        }
        return this.thumbnailStyle;
    }

    public boolean addThumbnail(JThumbnail<T> thumbnail) {
        boolean ok = this.thumbnails.add(thumbnail);
        if (ok) {
            thumbnail.addEventFilter(MouseEvent.MOUSE_CLICKED, this.mouseClickFilter);
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.tilePane.getChildren().add((Object)thumbnail));
            } else {
                this.tilePane.getChildren().add(thumbnail);
            }
        }
        return ok;
    }

    public boolean removeThumbnail(JThumbnail<T> thumbnail) {
        boolean ok;
        int index = this.thumbnails.indexOf(thumbnail);
        boolean bl = ok = this.thumbnails.remove(index) != null;
        if (ok) {
            Platform.runLater(() -> this.tilePane.getChildren().remove((Object)thumbnail));
            thumbnail.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseClickFilter);
        }
        return ok;
    }

    public void setStyle(JThumbnailStyle style) {
        this.tilePane.hgapProperty().unbind();
        this.tilePane.vgapProperty().unbind();
        this.tilePane.backgroundProperty().unbind();
        this.thumbnailStyleProperty().set((Object)style);
        if (this.thumbnailStyleProperty().get() != null) {
            this.tilePane.hgapProperty().bind((ObservableValue)((JThumbnailStyle)this.thumbnailStyleProperty().get()).thumbnailHGapProperty());
            this.tilePane.vgapProperty().bind((ObservableValue)((JThumbnailStyle)this.thumbnailStyleProperty().get()).thumbnailVGapProperty());
            this.tilePane.backgroundProperty().bind(((JThumbnailStyle)this.thumbnailStyleProperty().get()).thumbnailPaneBackgroundProperty());
        }
        for (JThumbnail thumbnail : this.thumbnails) {
            thumbnail.setThumbnailStyle((JThumbnailStyle)this.thumbnailStyleProperty().get());
        }
    }

    public List<T> getItems() {
        return this.filteredThumbnails.stream().map(JThumbnail::getThumbnailContent).collect(Collectors.toList());
    }

    public void setFilter(Predicate<? super T> predicate) {
        this.thumbnailFilterProperty().set(predicate);
    }

    protected void update() {
        for (JThumbnail t : this.filteredThumbnails.getSource()) {
            t.setVisible(false);
            t.setManaged(false);
        }
        for (JThumbnail t : this.filteredThumbnails) {
            t.setVisible(true);
            t.setManaged(true);
        }
    }

    private void filter() {
        if (this.thumbnailFilter != null) {
            this.filteredThumbnails.setPredicate(t -> ((Predicate)this.thumbnailFilter.get()).test(t.getThumbnailContent()));
        } else {
            this.filteredThumbnails.setPredicate(null);
        }
        this.update();
    }

    private void fireActivation(JThumbnail<T> thumbnail) {
        if (this.activationHandlers != null) {
            for (JThumbnailActivationHandler h : this.activationHandlers) {
                h.handle(this, thumbnail);
            }
        }
    }

    private void fireSelection(List<JThumbnail<T>> thumbnails) {
        if (this.activationHandlers != null) {
            for (JThumbnailSelectionHandler h : this.selectionHandlers) {
                h.handle(this, thumbnails);
            }
        }
    }

    private void processMouseClickedEvent(MouseEvent e) {
        if (e.getSource() != null && e.getSource() instanceof JThumbnail) {
            JThumbnail thumbnail = (JThumbnail)((Object)e.getSource());
            if (e.getButton() == MouseButton.PRIMARY) {
                if (e.getClickCount() > 1) {
                    this.fireActivation(thumbnail);
                } else if (!e.isControlDown() || !e.isShiftDown()) {
                    if (e.isShiftDown()) {
                        if (this.selectionLastThumbnail == null) {
                            if (!thumbnail.isStateSelected() && (this.thumbnailFilter == null || ((Predicate)this.thumbnailFilter.get()).test(thumbnail.getThumbnailContent()))) {
                                thumbnail.setStateSelected(true);
                                this.selectedThumbnails.add((Object)thumbnail);
                                this.selectionLastThumbnail = thumbnail;
                                this.fireSelection((List<JThumbnail<T>>)this.selectedThumbnails);
                            }
                        } else {
                            int index1 = this.thumbnails.indexOf(this.selectionLastThumbnail);
                            int index2 = this.thumbnails.indexOf((Object)thumbnail);
                            JThumbnail tmp = null;
                            for (int i = Math.min(index1, index2); i <= Math.max(index1, index2); ++i) {
                                tmp = (JThumbnail)((Object)this.thumbnails.get(i));
                                if (tmp.isStateSelected() || this.thumbnailFilter != null && !((Predicate)this.thumbnailFilter.get()).test(tmp.getThumbnailContent())) continue;
                                tmp.setStateSelected(true);
                                this.selectedThumbnails.add((Object)tmp);
                                this.selectionLastThumbnail = thumbnail;
                            }
                            this.fireSelection((List<JThumbnail<T>>)this.selectedThumbnails);
                        }
                    } else if (e.isControlDown()) {
                        if (thumbnail.isStateSelected()) {
                            thumbnail.setStateSelected(false);
                            this.selectedThumbnails.remove((Object)thumbnail);
                            this.selectionLastThumbnail = null;
                            this.fireSelection((List<JThumbnail<T>>)this.selectedThumbnails);
                        } else if (this.thumbnailFilter == null || ((Predicate)this.thumbnailFilter.get()).test(thumbnail.getThumbnailContent())) {
                            thumbnail.setStateSelected(true);
                            this.selectedThumbnails.add((Object)thumbnail);
                            this.selectionLastThumbnail = thumbnail;
                            this.fireSelection((List<JThumbnail<T>>)this.selectedThumbnails);
                        }
                    } else {
                        for (JThumbnail t : this.selectedThumbnails) {
                            t.setStateSelected(false);
                        }
                        this.selectedThumbnails.clear();
                        if (!thumbnail.isStateSelected() && (this.thumbnailFilter == null || ((Predicate)this.thumbnailFilter.get()).test(thumbnail.getThumbnailContent()))) {
                            thumbnail.setStateSelected(true);
                            this.selectedThumbnails.add((Object)thumbnail);
                        }
                        this.selectionLastThumbnail = thumbnail;
                        this.fireSelection((List<JThumbnail<T>>)this.selectedThumbnails);
                    }
                }
            }
            e.consume();
        }
    }
}

