/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.jfx.thumbnail;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;

public class JThumbnailSelectionModel<T>
extends MultipleSelectionModel<T> {
    private List<T> items = null;
    private ObservableList<Integer> selectedIndices;
    private ObservableList<T> selectedItems;

    public JThumbnailSelectionModel() {
        this(null);
    }

    public JThumbnailSelectionModel(List<T> items) {
        if (items != null) {
            this.items = items;
            if (items.size() > 0) {
                this.selectedIndices = FXCollections.observableList(new ArrayList(items.size()));
                this.selectedItems = FXCollections.observableList(new ArrayList(items.size()));
            } else {
                this.selectedIndices = FXCollections.observableArrayList();
                this.selectedItems = FXCollections.observableArrayList();
            }
        } else {
            this.items = new ArrayList<T>();
            this.selectedIndices = FXCollections.observableArrayList();
            this.selectedItems = FXCollections.observableArrayList();
        }
    }

    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectIndices(int index, int ... indices) {
        this.selectedIndices.clear();
        this.selectedIndices.add((Object)index);
        for (int i = 0; i < indices.length; ++i) {
            this.selectedIndices.add((Object)indices[i]);
        }
    }

    public void selectAll() {
        this.selectedIndices.clear();
        this.selectedItems.clear();
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.selectedIndices.add((Object)i);
                this.selectedItems.add(this.items.get(i));
            }
        }
    }

    public void selectFirst() {
        this.selectedIndices.clear();
        this.selectedItems.clear();
        if (this.items != null && this.items.size() > 0) {
            this.selectedIndices.add((Object)0);
            this.selectedItems.add(this.items.get(0));
        }
    }

    public void selectLast() {
        this.selectedIndices.clear();
        this.selectedItems.clear();
        if (this.items != null && this.items.size() > 0) {
            this.selectedIndices.add((Object)(this.items.size() - 1));
            this.selectedItems.add(this.items.get(this.items.size() - 1));
        }
    }

    public void clearAndSelect(int index) {
    }

    public void select(int index) {
    }

    public void select(T obj) {
    }

    public void clearSelection(int index) {
    }

    public void clearSelection() {
        this.selectedIndices.clear();
        this.selectedItems.clear();
    }

    public boolean isSelected(int index) {
        return this.selectedIndices.contains((Object)index);
    }

    public boolean isEmpty() {
        return this.selectedIndices.size() <= 0;
    }

    public void selectPrevious() {
    }

    public void selectNext() {
    }
}

