/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jorigin.gui.JImageFeature;
import org.jorigin.gui.JImagePanel;
import org.jorigin.gui.JImagePanelToolBar;

public class JImageFrame
extends JFrame {
    private static final long serialVersionUID = 201903071000L;
    private JImagePanel imagePanel = null;
    private JImagePanelToolBar imageToolbar = null;
    private JLabel panelCoordLB = null;
    private JLabel panelCoordTF = null;
    private JLabel imageCoordLB = null;
    private JLabel imageCoordTF = null;
    private JPanel northPanel = null;
    private JPanel southPanel = null;
    private NumberFormat imagePixelFormat = null;
    private NumberFormat panelPixelFormat = null;

    public static void showImageFrame(String title, Dimension size, Point location, BufferedImage image, boolean autoFit) {
        JImageFrame frame = new JImageFrame(title, size, image);
        frame.setAutoFit(autoFit);
        frame.setLocation(location);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    public JImageFrame() {
        this((BufferedImage)null);
    }

    public JImageFrame(BufferedImage image) {
        this.imagePanel = new JImagePanel(image);
        this.imageToolbar = new JImagePanelToolBar(this.imagePanel);
        this.imagePixelFormat = NumberFormat.getNumberInstance(Locale.US);
        this.imagePixelFormat.setMaximumFractionDigits(3);
        this.panelPixelFormat = NumberFormat.getNumberInstance(Locale.US);
        this.panelPixelFormat.setMaximumFractionDigits(0);
        this.initGUI();
        this.refreshGUI();
    }

    public JImageFrame(String title, Dimension size, BufferedImage image) {
        this.setTitle(title);
        this.setSize(size);
        this.imagePanel = new JImagePanel(image);
        this.imageToolbar = new JImagePanelToolBar(this.imagePanel);
        this.imagePixelFormat = NumberFormat.getNumberInstance(Locale.US);
        this.imagePixelFormat.setMaximumFractionDigits(3);
        this.panelPixelFormat = NumberFormat.getNumberInstance(Locale.US);
        this.panelPixelFormat.setMaximumFractionDigits(0);
        this.initGUI();
        this.refreshGUI();
    }

    protected void initGUI() {
        this.imagePanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JImageFrame.this.panelCoordTF.setText("(" + JImageFrame.this.panelPixelFormat.format(e.getX()) + ", " + JImageFrame.this.panelPixelFormat.format(e.getY()) + ")");
                Point2D imageCoord = JImageFrame.this.imagePanel.getImageCoordinate(e.getX(), e.getY());
                if (imageCoord != null) {
                    JImageFrame.this.imageCoordTF.setText("(" + JImageFrame.this.imagePixelFormat.format(imageCoord.getX()) + ", " + JImageFrame.this.imagePixelFormat.format(imageCoord.getY()) + ")");
                } else {
                    JImageFrame.this.imageCoordTF.setText("(Out of bounds)");
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JImageFrame.this.panelCoordTF.setText("(" + JImageFrame.this.panelPixelFormat.format(e.getX()) + ", " + JImageFrame.this.panelPixelFormat.format(e.getY()) + ")");
                Point2D imageCoord = JImageFrame.this.imagePanel.getImageCoordinate(e.getX(), e.getY());
                if (imageCoord != null) {
                    JImageFrame.this.imageCoordTF.setText("(" + JImageFrame.this.imagePixelFormat.format(imageCoord.getX()) + ", " + JImageFrame.this.imagePixelFormat.format(imageCoord.getY()) + ")");
                } else {
                    JImageFrame.this.imageCoordTF.setText("(Out of bounds)");
                }
            }
        });
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new FlowLayout(3));
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new FlowLayout(3));
        this.panelCoordLB = new JLabel("Panel coords: ");
        this.panelCoordTF = new JLabel("");
        this.imageCoordLB = new JLabel("Image coords: ");
        this.imageCoordTF = new JLabel("");
        this.getContentPane().setLayout(new BorderLayout());
        this.northPanel.add(this.imageToolbar);
        this.southPanel.add(this.panelCoordLB);
        this.southPanel.add(this.panelCoordTF);
        this.southPanel.add(this.imageCoordLB);
        this.southPanel.add(this.imageCoordTF);
        this.getContentPane().add((Component)this.imagePanel, "Center");
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    protected void refreshGUI() {
        this.imageToolbar.refreshGUI();
    }

    public BufferedImage getImage() {
        return this.imagePanel.getImage();
    }

    public void setImage(BufferedImage image) {
        this.imagePanel.setImage(image);
    }

    public List<JImageFeature> getImageFeatures(String layer) {
        return this.imagePanel.getImageFeatures(layer);
    }

    public void setImageFeatures(String layer, List<JImageFeature> features) {
        this.imagePanel.setImageFeatures(layer, features);
    }

    public boolean isLayerDisplayed(String layer) {
        return this.imagePanel.isLayerDisplayed(layer);
    }

    public void setLayerDisplayed(String layer, boolean displayed) {
        this.imagePanel.setLayerDisplayed(layer, displayed);
    }

    public boolean isAutoFit() {
        return this.imagePanel.isAutoFit();
    }

    public void setAutoFit(boolean autoFit) {
        this.imagePanel.setAutoFit(autoFit);
    }

    public void fit() {
        this.imagePanel.fit();
    }
}

