/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jorigin.gui.JImagePanel;

public class JImagePanelToolBar
extends JToolBar
implements PropertyChangeListener {
    private static final long serialVersionUID = 201708311445L;
    private JToggleButton modeSelectionPointButton = null;
    private JToggleButton modeSelectionRectButton = null;
    private JToggleButton modeSelectionShapeButton = null;
    private ButtonGroup modeSelectionGroup = null;
    private JLabel scaleLB = null;
    private JSpinner scaleSpinner = null;
    private JButton fitBT = null;
    private JImagePanel imagePanel = null;
    private boolean listening = true;

    public JImagePanelToolBar(JImagePanel panel) {
        this.initGUI();
        this.setImagePanel(panel);
    }

    protected void initGUI() {
        this.modeSelectionPointButton = new JToggleButton("Point");
        this.modeSelectionPointButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JImagePanelToolBar.this.listening && JImagePanelToolBar.this.imagePanel != null) {
                    JImagePanelToolBar.this.imagePanel.setSelectionMode(1);
                }
            }
        });
        this.modeSelectionRectButton = new JToggleButton("Rect");
        this.modeSelectionRectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JImagePanelToolBar.this.listening && JImagePanelToolBar.this.imagePanel != null) {
                    JImagePanelToolBar.this.imagePanel.setSelectionMode(2);
                }
            }
        });
        this.modeSelectionShapeButton = new JToggleButton("Shape");
        this.modeSelectionShapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JImagePanelToolBar.this.listening && JImagePanelToolBar.this.imagePanel != null) {
                    JImagePanelToolBar.this.imagePanel.setSelectionMode(4);
                }
            }
        });
        this.modeSelectionGroup = new ButtonGroup();
        this.modeSelectionGroup.add(this.modeSelectionPointButton);
        this.modeSelectionGroup.add(this.modeSelectionRectButton);
        this.modeSelectionGroup.add(this.modeSelectionShapeButton);
        this.scaleLB = new JLabel("Scale: ");
        this.scaleSpinner = null;
        this.scaleSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.01));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.scaleSpinner, "0%");
        this.scaleSpinner.setEditor(editor);
        this.scaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JImagePanelToolBar.this.listening && JImagePanelToolBar.this.imagePanel != null) {
                    JImagePanelToolBar.this.imagePanel.setScale(((Number)JImagePanelToolBar.this.scaleSpinner.getValue()).floatValue());
                }
            }
        });
        this.fitBT = new JButton("Fit");
        this.fitBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JImagePanelToolBar.this.listening && JImagePanelToolBar.this.imagePanel != null) {
                    JImagePanelToolBar.this.imagePanel.fit();
                }
            }
        });
        FlowLayout layout = new FlowLayout(3);
        this.setLayout(layout);
        this.add(this.modeSelectionPointButton);
        this.add(this.modeSelectionRectButton);
        this.add(this.modeSelectionShapeButton);
        this.addSeparator();
        this.add(this.scaleLB);
        this.add(this.scaleSpinner);
        this.addSeparator();
        this.add(this.fitBT);
    }

    protected void refreshGUI() {
        this.listening = false;
        if (this.imagePanel != null) {
            this.modeSelectionPointButton.setEnabled(true);
            this.modeSelectionRectButton.setEnabled(true);
            this.modeSelectionShapeButton.setEnabled(true);
            if ((this.imagePanel.getSelectionMode() & 1) == 1) {
                this.modeSelectionPointButton.setSelected(true);
            } else if ((this.imagePanel.getSelectionMode() & 1) == 2) {
                this.modeSelectionRectButton.setSelected(true);
            } else if ((this.imagePanel.getSelectionMode() & 1) == 4) {
                this.modeSelectionShapeButton.setSelected(true);
            }
            this.scaleLB.setEnabled(true);
            this.scaleSpinner.setValue(this.imagePanel.getScale());
            this.fitBT.setEnabled(true);
        } else {
            this.modeSelectionPointButton.setSelected(false);
            this.modeSelectionPointButton.setEnabled(false);
            this.modeSelectionRectButton.setSelected(false);
            this.modeSelectionRectButton.setEnabled(false);
            this.modeSelectionShapeButton.setSelected(false);
            this.modeSelectionShapeButton.setEnabled(false);
            this.scaleLB.setEnabled(false);
            this.scaleSpinner.setValue(Float.valueOf(1.0f));
            this.fitBT.setEnabled(false);
        }
        this.listening = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.listening) {
            System.out.println("Property " + evt.getPropertyName() + " changed from " + evt.getOldValue() + " to " + evt.getNewValue());
            this.refreshGUI();
        }
    }

    public JImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public void setImagePanel(JImagePanel panel) {
        if (this.imagePanel != null) {
            this.imagePanel.removePropertyChangeListener(this);
        }
        this.imagePanel = panel;
        if (this.imagePanel != null) {
            this.imagePanel.addPropertyChangeListener(this);
        }
        this.refreshGUI();
    }
}

