/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jorigin.Common;
import org.jorigin.plugin.IPlugger;
import org.jorigin.plugin.IPlugin;
import org.jorigin.plugin.IPluginManager;
import org.jorigin.plugin.PluginManagerListener;

public class DefaultPluginManager
implements IPluginManager {
    private ArrayList<IPlugin> plugins = null;
    private ArrayList<String> excludes = new ArrayList();
    private ArrayList<String> includes = new ArrayList();
    private IPlugger plugger = null;
    private ArrayList<PluginManagerListener> listeners = null;
    private int pluginCount = 0;
    private int pluginProcessed = 0;
    float percentDone = 0.0f;

    @Override
    public boolean addPluginExclude(String pluginName) {
        if (!this.excludes.contains(pluginName)) {
            return this.excludes.add(pluginName);
        }
        return false;
    }

    @Override
    public boolean addPluginInclude(String pluginName) {
        if (!this.includes.contains(pluginName)) {
            return this.includes.add(pluginName);
        }
        return false;
    }

    @Override
    public ArrayList<String> getPluginExcludes() {
        return this.excludes;
    }

    @Override
    public ArrayList<String> getPluginIncludes() {
        return this.includes;
    }

    @Override
    public void pluginAllInit() {
        Iterator<IPlugin> iter = null;
        IPlugin plugin2 = null;
        boolean isExcluded = false;
        boolean isIncluded = false;
        if (this.plugins == null) {
            return;
        }
        this.pluginCount = this.plugins.size();
        this.pluginProcessed = 0;
        this.initStarted(this.pluginCount);
        Collections.sort(this.plugins, new Comparator<IPlugin>(){

            @Override
            public int compare(IPlugin o1, IPlugin o2) {
                String[] p1dep = o1.getDependencies();
                String[] p2dep = o2.getDependencies();
                boolean p1dependOfP2 = false;
                boolean p2dependOfP1 = false;
                int i = 0;
                int ret = 0;
                if (p1dep == null && p2dep == null) {
                    return 0;
                }
                if (p1dep == null) {
                    return -1;
                }
                if (p2dep == null) {
                    return 1;
                }
                for (i = 0; i < p1dep.length && !p1dependOfP2; ++i) {
                    if (!p1dep[i].equals(o2.getName())) continue;
                    p1dependOfP2 = true;
                }
                for (i = 0; i < p2dep.length && !p2dependOfP1; ++i) {
                    if (!p2dep[i].equals(o1.getName())) continue;
                    p2dependOfP1 = true;
                }
                ret = p1dependOfP2 && p2dependOfP1 ? 0 : (p1dependOfP2 ? 1 : (p2dependOfP1 ? -1 : 0));
                p1dep = null;
                p2dep = null;
                return ret;
            }
        });
        Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()] Init plugins");
        for (IPlugin plugin2 : this.plugins) {
            Matcher matcher;
            Pattern pattern;
            int j;
            for (j = 0; j < this.excludes.size() && !isExcluded; ++j) {
                pattern = Pattern.compile(this.excludes.get(j));
                matcher = pattern.matcher(plugin2.getName());
                if (!matcher.matches()) continue;
                Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - NOT Init " + plugin2.getName() + " (explicitely excluded by " + this.excludes.get(j) + ")");
                isExcluded = true;
            }
            if (!isExcluded) {
                j = 0;
                while (j < this.includes.size() && !isIncluded) {
                    pattern = Pattern.compile(this.includes.get(j));
                    matcher = pattern.matcher(plugin2.getName());
                    if (!matcher.matches()) continue;
                    isIncluded = true;
                    try {
                        if (plugin2.pluginInit(this.plugger)) {
                            Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " (included) [OK]");
                            continue;
                        }
                        Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " (included) [FAIL]");
                    }
                    catch (Exception ex) {
                        Common.logger.log(Level.SEVERE, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " (included) [FAIL]", ex);
                    }
                }
            }
            if (isExcluded || isIncluded) continue;
            Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " Plugin is not included / excluded, loading by default");
            try {
                if (plugin2.pluginInit(this.plugger)) {
                    Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " Plugin is not included / excluded, loading by default [OK]");
                    continue;
                }
                Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " Plugin is not included / excluded, loading by default [FAIL]");
            }
            catch (Exception ex) {
                Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()]  - Init " + plugin2.getName() + " Plugin is not included / excluded, loading by default [FAIL]", ex);
            }
        }
        this.initComplete(this.pluginProcessed);
        this.pluginProcessed = 0;
        this.pluginCount = 0;
    }

    @Override
    public void pluginAllRestart() {
        this.pluginAllStop();
        this.pluginAllStart();
    }

    @Override
    public void pluginAllStart() {
        Iterator<IPlugin> iter = null;
        IPlugin plugin2 = null;
        int i = 0;
        if (this.plugins == null) {
            return;
        }
        Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllInit()] Start plugins");
        this.pluginCount = this.plugins.size();
        this.pluginProcessed = 0;
        this.startStarted(this.pluginCount);
        for (IPlugin plugin2 : this.plugins) {
            if (plugin2.isPluginInitialized()) {
                if (plugin2.pluginStart()) {
                    this.pluginStarted(plugin2);
                    ++this.pluginProcessed;
                    Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllStart()]  - Start " + plugin2.getName() + " [OK]");
                } else {
                    this.pluginStartError(plugin2);
                    Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllStart()]  - Start " + plugin2.getName() + " [FAIL]");
                }
            } else {
                this.pluginStartError(plugin2);
                Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllStart()]  - Cannot start " + plugin2.getName() + " because it is not initialized [FAIL]");
            }
            this.startProgress(plugin2, (float)i / (float)this.pluginCount);
            ++i;
        }
        this.startComplete(this.pluginProcessed);
        this.pluginProcessed = 0;
        this.pluginCount = 0;
    }

    @Override
    public void pluginAllStop() {
        Iterator<IPlugin> iter = null;
        IPlugin plugin2 = null;
        for (IPlugin plugin2 : this.plugins) {
            if (plugin2.pluginStop()) {
                Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllStop()] Stop " + plugin2.getName() + " [OK] ");
                continue;
            }
            Common.logger.log(Level.INFO, "[DefaultPluginManager][pluginAllStop()] Stop " + plugin2.getName() + " [FAIL] ");
        }
    }

    @Override
    public void pluginInit(IPlugin plugin) {
        try {
            plugin.pluginInit(this.plugger);
        }
        catch (Exception ex) {
            Common.logger.log(Level.INFO, plugin.getName() + " initialization error", ex);
        }
    }

    @Override
    public void pluginRegister(IPlugin plugin) {
        if (!this.plugins.contains(plugin)) {
            this.plugins.add(plugin);
        }
    }

    @Override
    public void pluginRestart(IPlugin plugin) {
        plugin.pluginStop();
        plugin.pluginStart();
    }

    @Override
    public void pluginStart(IPlugin plugin) {
        plugin.pluginStart();
    }

    @Override
    public void pluginStop(IPlugin plugin) {
        if (plugin != null && this.plugins.contains(plugin)) {
            plugin.pluginStop();
        }
    }

    @Override
    public void pluginUnregister(IPlugin plugin) {
        this.pluginStop(plugin);
        this.plugins.remove(plugin);
    }

    @Override
    public boolean removePluginExclude(String pluginName) {
        return this.excludes.remove(pluginName);
    }

    @Override
    public boolean removePluginInclude(String pluginName) {
        return this.includes.remove(pluginName);
    }

    @Override
    public boolean addPluginManagerListener(PluginManagerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (listener != null) {
            return this.listeners.add(listener);
        }
        return false;
    }

    @Override
    public boolean removePluginManagerListener(PluginManagerListener listener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(listener);
    }

    private void initStarted(int pluginCount) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().initStarted(pluginCount);
            }
        }
    }

    private void initComplete(int pluginCount) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().initComplete(pluginCount);
            }
        }
    }

    private void startStarted(int pluginCount) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().startStarted(pluginCount);
            }
        }
    }

    private void startProgress(IPlugin plugin, float percentDone) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().startProgress(plugin, percentDone);
            }
        }
    }

    private void startComplete(int pluginCount) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().startComplete(pluginCount);
            }
        }
    }

    private void pluginStarted(IPlugin plugin) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().pluginStarted(plugin);
            }
        }
    }

    private void pluginStartError(IPlugin plugin) {
        if (this.listeners != null) {
            Iterator<PluginManagerListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                iter.next().pluginStartError(plugin);
            }
        }
    }

    public DefaultPluginManager(IPlugger plugger) {
        this.plugger = plugger;
        this.plugins = new ArrayList();
        this.excludes = new ArrayList();
        this.includes = new ArrayList();
    }
}

