/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.system.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jorigin.Common;
import org.jorigin.lang.LangResourceBundle;

public class GraphicsEnvironmentPanel
extends JPanel {
    private static final long serialVersionUID = 201903071030L;
    private LangResourceBundle lr = (LangResourceBundle)LangResourceBundle.getBundle(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
    private float displayedFontSize = 14.0f;
    private GraphicsEnvironment ge = null;
    private Point centerPoint = null;
    private Rectangle maximumWindowBounds = null;
    private Font[] fonts = null;
    private GraphicsDevice[] devices = null;
    private JLabel centerPointLB = null;
    private JTextField centerPointTF = null;
    private JLabel maximumWindowBoundsLB = null;
    private JTextField maximumWindowBoundsTF = null;
    private JPanel geometryPN = null;
    private JList<Font> fontsList = null;
    private JScrollPane fontsListSP = null;
    private JPanel fontsPN = null;
    private JLabel displayLB = null;
    private JComboBox<GraphicsDevice> displayCB = null;
    private JPanel displayPN = null;

    public GraphicsEnvironmentPanel() {
        this((GraphicsEnvironment)null);
    }

    public GraphicsEnvironmentPanel(GraphicsEnvironment ge) {
        if (ge != null) {
            this.setGraphicsEnvironment(ge);
        } else {
            this.setGraphicsEnvironment(GraphicsEnvironment.getLocalGraphicsEnvironment());
        }
        this.centerPoint = this.ge.getCenterPoint();
        this.maximumWindowBounds = this.ge.getMaximumWindowBounds();
        this.fonts = this.ge.getAllFonts();
        this.devices = this.ge.getScreenDevices();
        for (int i = 0; i < this.devices.length; ++i) {
            Common.logger.log(Level.INFO, this.devices[i].getIDstring());
            Common.logger.log(Level.INFO, "" + this.devices[i].getType());
            Common.logger.log(Level.INFO, "" + this.devices[i].getDisplayMode());
            Common.logger.log(Level.INFO, "" + this.devices[i].getAvailableAcceleratedMemory());
            this.devices[i].isDisplayChangeSupported();
            this.devices[i].isFullScreenSupported();
            Common.logger.log(Level.INFO, "" + this.devices[i].getDisplayMode().getBitDepth());
            Common.logger.log(Level.INFO, "" + this.devices[i].getDisplayMode().getHeight());
            Common.logger.log(Level.INFO, "" + this.devices[i].getDisplayMode().getWidth());
            Common.logger.log(Level.INFO, "" + this.devices[i].getDisplayMode().getRefreshRate());
            this.devices[i].isDisplayChangeSupported();
            this.devices[i].isFullScreenSupported();
        }
        this.initGUI();
        this.refreshGUI();
    }

    protected void initGUI() {
        GridBagConstraints c = null;
        Insets labelInsets = new Insets(3, 6, 3, 0);
        Insets fieldInsets = new Insets(3, 0, 3, 6);
        this.centerPointLB = new JLabel(this.lr.getString("GRAPHICSENV_CENTER_POINT") + ": ");
        this.centerPointTF = new JTextField();
        this.centerPointTF.setText((int)this.centerPoint.getX() + ", " + (int)this.centerPoint.getY());
        this.centerPointTF.setEditable(false);
        this.maximumWindowBoundsLB = new JLabel(this.lr.getString("GRAPHICSENV_MAX_W_BOUNDS") + ": ");
        this.maximumWindowBoundsTF = new JTextField();
        this.maximumWindowBoundsTF.setText((int)this.maximumWindowBounds.getWidth() + "x" + (int)this.maximumWindowBounds.getHeight() + " px");
        this.maximumWindowBoundsTF.setEditable(false);
        this.geometryPN = new JPanel();
        this.geometryPN.setBorder(BorderFactory.createTitledBorder(this.lr.getString("GRAPHICSENV_GEOM")));
        this.geometryPN.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 12;
        this.geometryPN.add((Component)this.centerPointLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        this.geometryPN.add((Component)this.centerPointTF, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 12;
        this.geometryPN.add((Component)this.maximumWindowBoundsLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        this.geometryPN.add((Component)this.maximumWindowBoundsTF, c);
        this.fontsList = new JList<Font>(this.fonts);
        this.fontsList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 201903071030L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent(list, ((Font)value).getName(), index, isSelected, cellHasFocus);
                Font font = ((Font)value).deriveFont(GraphicsEnvironmentPanel.this.displayedFontSize);
                comp.setFont(font);
                return comp;
            }
        });
        this.fontsListSP = new JScrollPane(this.fontsList);
        this.fontsPN = new JPanel();
        this.fontsPN.setBorder(BorderFactory.createTitledBorder(this.lr.getString("GRAPHICSENV_FONTS")));
        this.fontsPN.setLayout(new BorderLayout());
        this.fontsPN.add((Component)this.fontsListSP, "Center");
        this.displayLB = new JLabel(this.lr.getString("GRAPHICSENV_DISPLAY_ID") + ": ");
        this.displayCB = new JComboBox<GraphicsDevice>(this.devices);
        this.displayCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 201903071030L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object str = ((GraphicsDevice)value).getIDstring();
                switch (((GraphicsDevice)value).getType()) {
                    case 2: {
                        str = (String)str + " (" + GraphicsEnvironmentPanel.this.lr.getString("GRAPHICSENV_DISPLAY_TYPE_IMAGE") + ")";
                        break;
                    }
                    case 1: {
                        str = (String)str + " (" + GraphicsEnvironmentPanel.this.lr.getString("GRAPHICSENV_DISPLAY_TYPE_PRINTER") + ")";
                        break;
                    }
                    case 0: {
                        str = (String)str + " (" + GraphicsEnvironmentPanel.this.lr.getString("GRAPHICSENV_DISPLAY_TYPE_SCREEN") + ")";
                    }
                }
                Component comp = super.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
                return comp;
            }
        });
        this.displayPN = new JPanel();
        this.displayPN.setBorder(BorderFactory.createTitledBorder(this.lr.getString("GRAPHICSENV_DISPLAY")));
        this.displayPN.setLayout(new BorderLayout());
        this.displayPN.add((Component)this.displayLB, "West");
        this.displayPN.add(this.displayCB, "Center");
        this.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 12;
        this.add((Component)this.geometryPN, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 12;
        this.add((Component)this.displayPN, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 2;
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 12;
        this.add((Component)this.fontsPN, c);
    }

    protected void refreshGUI() {
    }

    public void setGraphicsEnvironment(GraphicsEnvironment ge) {
        this.ge = ge;
    }

    public GraphicsEnvironment getGraphicsEnvironment() {
        return this.ge;
    }
}

