/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;

public class JDesktopPane
extends javax.swing.JDesktopPane {
    private static final long serialVersionUID = 202004280800L;
    public static final int NONE = 0;
    public static final int MOSAIC = 1;
    public static final int CASCADE = 2;
    public static final int FIT_NONE = 0;
    public static final int FIT_CENTER = 1;
    public static final int FIT_CENTER_RESIZE = 2;
    public static final int FIT_CENTER_DELTA = 3;
    public static final int FIT_CENTER_RESIZE_DELTA = 4;
    private double frameDimensionRatio = 0.5;
    private int fitMethod = 3;
    private double fitDeltaMax = 50.0;
    private int organizeMethod = 0;

    public void setOrganizeMethod(int method) {
        this.organizeMethod = method;
    }

    public int getOrganizeMethod() {
        return this.organizeMethod;
    }

    public void setFrameDimensionRatio(double ratio) {
        this.frameDimensionRatio = ratio;
    }

    public double getFrameDimensionRatio() {
        return this.frameDimensionRatio;
    }

    public void setFitMethod(int fitMethod) {
        this.fitMethod = fitMethod;
    }

    public int getFitMethod() {
        return this.fitMethod;
    }

    public void setFitDeltaMax(double delta) {
        this.fitDeltaMax = delta;
    }

    public double getFitDeltaMax() {
        return this.fitDeltaMax;
    }

    public void organize() {
        this.organize(this.organizeMethod);
    }

    public void organize(int method) {
        switch (method) {
            case 1: {
                this.mosaic();
                break;
            }
            case 2: {
                this.cascade();
                break;
            }
        }
    }

    public void cascade() {
        int i;
        int nbInternalFrame;
        JInternalFrame[] frames = this.getAllFrames();
        int n = nbInternalFrame = frames.length;
        for (i = 0; i < nbInternalFrame; ++i) {
            if (!frames[i].isIcon()) continue;
            --n;
        }
        i = 0;
        int j = n - 1;
        while (i < nbInternalFrame) {
            if (!frames[i].isIcon()) {
                frames[i].setBounds(j * 20, j * 20, this.getWidth() / 3, this.getHeight() / 3);
            }
            ++i;
            --j;
        }
    }

    public void mosaic() {
        int nbInternalFrame;
        JInternalFrame[] frames = this.getAllFrames();
        int n = nbInternalFrame = frames.length;
        int bas = 0;
        int column = 0;
        int line = 0;
        for (int i = 0; i < nbInternalFrame; ++i) {
            if (!frames[i].isIcon()) continue;
            --n;
        }
        if (n != nbInternalFrame) {
            bas = 30;
        }
        if (n == 0) {
            return;
        }
        column = (int)Math.sqrt(n);
        if (n != column * column) {
            ++column;
        }
        line = (n - 1) / column + 1 < column ? column - 1 : column;
        int dx = this.getWidth() / column;
        int dy = this.getHeight() / line - bas;
        int k = 0;
        for (int i = 0; i < column; ++i) {
            for (int j = 0; j < column && k < n; ++j, ++k) {
                frames[i * column + j].setBounds(j * dx, i * dy, dx, dy);
            }
        }
    }

    public void fit(JInternalFrame frame) {
        Dimension desktopDimension = null;
        Dimension frameDimension = null;
        double xDelta = 0.0;
        double yDelta = 0.0;
        int locationx = 0;
        int locationy = 0;
        frame.pack();
        desktopDimension = new Dimension((int)this.getSize().getWidth(), (int)this.getSize().getHeight());
        frameDimension = frame.getSize();
        switch (this.fitMethod) {
            case 0: {
                break;
            }
            case 1: {
                frame.setPreferredSize(frameDimension);
                locationx = desktopDimension.width / 2 - frameDimension.width / 2;
                locationy = desktopDimension.height / 2 - frameDimension.height / 2;
                break;
            }
            case 2: {
                frameDimension = new Dimension((int)(desktopDimension.getWidth() * 0.5), (int)(desktopDimension.getHeight() * 0.5));
                frame.setSize(frameDimension);
                frame.setPreferredSize(frameDimension);
                locationx = desktopDimension.width / 2 - frameDimension.width / 2;
                locationy = desktopDimension.height / 2 - frameDimension.height / 2;
                break;
            }
            case 3: {
                frame.setPreferredSize(frameDimension);
                xDelta = Math.random() * this.fitDeltaMax;
                yDelta = Math.random() * this.fitDeltaMax;
                if (Math.random() > 0.5) {
                    xDelta *= -1.0;
                }
                if (Math.random() > 0.5) {
                    yDelta *= -1.0;
                }
                locationx = (int)xDelta + desktopDimension.width / 2 - frameDimension.width / 2;
                locationy = (int)yDelta + desktopDimension.height / 2 - frameDimension.height / 2;
                break;
            }
            case 4: {
                frameDimension = new Dimension((int)(desktopDimension.getWidth() * 0.5), (int)(desktopDimension.getHeight() * 0.5));
                frame.setSize(frameDimension);
                frame.setPreferredSize(frameDimension);
                xDelta = Math.random() * this.fitDeltaMax;
                yDelta = Math.random() * this.fitDeltaMax;
                if (Math.random() > 0.5) {
                    xDelta *= -1.0;
                }
                if (Math.random() > 0.5) {
                    yDelta *= -1.0;
                }
                locationx = (int)xDelta + desktopDimension.width / 2 - frameDimension.width / 2;
                locationy = (int)yDelta + desktopDimension.height / 2 - frameDimension.height / 2;
            }
        }
        if (frame.getWidth() > this.getWidth()) {
            frameDimension.setSize((double)this.getWidth(), frameDimension.getHeight());
        }
        if (frame.getHeight() > this.getHeight()) {
            frameDimension.setSize(frameDimension.getWidth(), (double)this.getHeight());
        }
        frame.setSize(frameDimension);
        if (locationx >= 0 && (double)locationx < this.getSize().getWidth() && locationy >= 0 && (double)locationy < this.getSize().getHeight()) {
            frame.setLocation(locationx, locationy);
        } else {
            frame.setLocation(0, 0);
        }
    }

    void iconifyAll() {
        JInternalFrame[] frames = this.getAllFrames();
        try {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setIcon(true);
            }
        }
        catch (PropertyVetoException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    void closeAll() {
        JInternalFrame[] frames = this.getAllFrames();
        try {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setClosed(true);
            }
        }
        catch (PropertyVetoException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public void addInternalFrame(String title, Container container, boolean fit) {
        JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
        frame.getContentPane().add(container);
        this.addInternalFrame(frame, fit);
    }

    public void addInternalFrame(String title, Container container) {
        this.addInternalFrame(title, container, true);
    }

    public void addInternalFrame(JInternalFrame frame, boolean fit) {
        if (fit) {
            this.fit(frame);
        }
        frame.pack();
        this.add(frame);
        this.organize();
        this.validate();
        this.repaint();
        frame.setFocusable(true);
        frame.setVisible(true);
        frame.requestFocus();
        frame.repaint();
    }
}

