/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jorigin.gui.JImageFeature;

public class JImagePanel
extends JPanel {
    private static final long serialVersionUID = 201903071000L;
    public static final String MODE_SELECTION_PROPERTY = "MODE_SELECTION";
    public static final String SCALE_PROPERTY = "SCALE";
    public static final int MODE_SELECTION_POINT = 1;
    public static final int MODE_SELECTION_RECT = 2;
    public static final int MODE_SELECTION_SHAPE = 4;
    private BufferedImage image = null;
    private Map<String, List<JImageFeature>> layers;
    private Map<String, Boolean> layersVisibility;
    private double scale = 1.0;
    private RenderingHints renderingHints = null;
    private AffineTransform transform = null;
    private final Shape selectionShape = null;
    private Stroke selectionShapeStroke = null;
    private int mode = 1;
    private int mouseButtonActive = 0;
    int lastCursorPositionX = 0;
    int lastCursorPositionY = 0;
    private boolean autoRepaint = true;
    private boolean autoFit = false;
    private boolean painting = false;

    public JImagePanel() {
        this((BufferedImage)null);
    }

    public JImagePanel(BufferedImage image) {
        this.image = image;
        this.renderingHints = null;
        this.transform = new AffineTransform();
        this.selectionShapeStroke = new BasicStroke(1.0f, 2, 1, 10.0f, new float[]{1.0f, 0.0f, 1.0f, 0.0f}, 0.0f);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JImagePanel.this.mouseButtonActive |= InputEvent.getMaskForButton(e.getButton());
                JImagePanel.this.lastCursorPositionX = e.getX();
                JImagePanel.this.lastCursorPositionY = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JImagePanel.this.mouseButtonActive &= ~InputEvent.getMaskForButton(e.getButton());
                JImagePanel.this.lastCursorPositionX = e.getX();
                JImagePanel.this.lastCursorPositionY = e.getY();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JImagePanel.this.lastCursorPositionX = e.getX();
                JImagePanel.this.lastCursorPositionY = e.getY();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JImagePanel.this.lastCursorPositionX = e.getX();
                JImagePanel.this.lastCursorPositionY = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double deltaX = JImagePanel.this.lastCursorPositionX - e.getX();
                double deltaY = JImagePanel.this.lastCursorPositionY - e.getY();
                if ((JImagePanel.this.mode & 1) == 1) {
                    double tx = JImagePanel.this.transform.getTranslateX();
                    double ty = JImagePanel.this.transform.getTranslateY();
                    if ((JImagePanel.this.mouseButtonActive & 0x400) == 1024) {
                        if (tx - deltaX <= 0.0 && tx - deltaX >= (double)(-JImagePanel.this.getImage().getWidth()) * JImagePanel.this.scale + (double)JImagePanel.this.getWidth()) {
                            tx -= deltaX;
                        } else if (tx > 0.0 && deltaX > 0.0) {
                            tx -= deltaX;
                        } else if (tx < (double)(-JImagePanel.this.getImage().getWidth()) * JImagePanel.this.scale + (double)JImagePanel.this.getWidth() && deltaX < 0.0) {
                            tx -= deltaX;
                        }
                        if (ty - deltaY <= 0.0 && ty - deltaY >= (double)(-JImagePanel.this.getImage().getHeight()) * JImagePanel.this.scale + (double)JImagePanel.this.getHeight()) {
                            ty -= deltaY;
                        } else if (ty > 0.0 && deltaY > 0.0) {
                            ty -= deltaY;
                        } else if (ty < (double)(-JImagePanel.this.getImage().getHeight()) * JImagePanel.this.scale + (double)JImagePanel.this.getHeight() && deltaY < 0.0) {
                            ty -= deltaY;
                        }
                        JImagePanel.this.setTranslation(new Point2D.Double(tx, ty));
                        JImagePanel.this.lastCursorPositionX = e.getX();
                        JImagePanel.this.lastCursorPositionY = e.getY();
                        if (JImagePanel.this.autoRepaint) {
                            JImagePanel.this.repaint();
                        }
                    }
                } else if ((JImagePanel.this.mode & 2) == 2 || (JImagePanel.this.mode & 4) == 4) {
                    // empty if block
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JImagePanel.this.lastCursorPositionX = e.getX();
                JImagePanel.this.lastCursorPositionY = e.getY();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (JImagePanel.this.isAutoFit()) {
                    JImagePanel.this.fit();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        this.painting = true;
        Graphics2D g2d = (Graphics2D)g;
        Color savedColor = g2d.getColor();
        RenderingHints savedHints = g2d.getRenderingHints();
        AffineTransform savedTransform = g2d.getTransform();
        if (this.renderingHints != null) {
            g2d.setRenderingHints(this.renderingHints);
        }
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setTransform(this.transform);
        if (this.image != null) {
            g2d.drawRenderedImage(this.image, null);
        }
        if (this.layers != null) {
            for (String layer : this.layers.keySet()) {
                List<JImageFeature> displayingFeatures;
                if (!this.isLayerDisplayed(layer) || (displayingFeatures = this.layers.get(layer)) == null) continue;
                for (JImageFeature feature : displayingFeatures) {
                    if (!feature.isStateDisplaying()) continue;
                    feature.draw(g2d, this.transform);
                }
            }
        }
        g2d.setTransform(savedTransform);
        if (this.selectionShape != null) {
            this.drawSelectionShape(g2d, this.selectionShape);
        }
        g2d.setColor(savedColor);
        g2d.setRenderingHints(savedHints);
        this.painting = false;
    }

    protected void drawSelectionShape(Graphics2D g2d, Shape shape) {
        Color savedColor = g2d.getColor();
        RenderingHints savedHints = g2d.getRenderingHints();
        AffineTransform savedTransform = g2d.getTransform();
        if (this.selectionShapeStroke != null) {
            g2d.setStroke(this.selectionShapeStroke);
        }
        g2d.draw(shape);
        g2d.setColor(savedColor);
        g2d.setRenderingHints(savedHints);
        g2d.setTransform(savedTransform);
    }

    public boolean isRendering() {
        return this.painting;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints hints) {
        this.renderingHints = hints;
    }

    public Stroke getSelectionShapeStroke() {
        return this.selectionShapeStroke;
    }

    public void setSelectionShapeStroke(Stroke stroke) {
        this.selectionShapeStroke = stroke;
    }

    public int getSelectionMode() {
        return this.mode;
    }

    public void setSelectionMode(int mode) {
        int oldValue = this.mode;
        this.mode = mode;
        this.firePropertyChange(MODE_SELECTION_PROPERTY, oldValue, mode);
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void setAutoRepaint(boolean auto) {
        this.autoRepaint = auto;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.transform = new AffineTransform();
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public double getScale() {
        return this.transform.getScaleX();
    }

    public void setScale(double zoom) {
        if (this.scale != zoom) {
            double oldValue = this.scale;
            this.scale = zoom;
            this.transform.setTransform(this.scale, this.transform.getShearY(), this.transform.getShearX(), this.scale, this.transform.getTranslateX(), this.transform.getTranslateY());
            this.firePropertyChange(SCALE_PROPERTY, oldValue, this.scale);
            if (this.autoRepaint) {
                this.repaint();
            }
        }
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double();
        ((Point2D)p).setLocation(this.transform.getTranslateX(), this.transform.getTranslateY());
        return p;
    }

    public void setTranslation(Point2D translation) {
        if (translation != null) {
            this.transform.setTransform(this.transform.getScaleX(), this.transform.getShearY(), this.transform.getShearX(), this.transform.getScaleY(), translation.getX(), translation.getY());
            if (this.autoRepaint) {
                this.repaint();
            }
        }
    }

    public void fit() {
        if (this.image != null) {
            boolean b = this.autoRepaint;
            this.autoRepaint = false;
            this.setTranslation(new Point2D.Double(0.0, 0.0));
            this.setScale(Math.min((float)this.getWidth() / (float)this.image.getWidth(), (float)this.getHeight() / (float)this.image.getHeight()));
            this.repaint();
            this.autoRepaint = b;
        }
    }

    public boolean isLayerDisplayed(String layer) {
        if (this.layersVisibility != null) {
            if (this.layersVisibility.get(layer) != null) {
                return this.layersVisibility.get(layer);
            }
            return false;
        }
        return false;
    }

    public void setLayerDisplayed(String layer, boolean displayed) {
        if (this.layers != null && this.layers.get(layer) != null) {
            if (this.layersVisibility == null) {
                this.layersVisibility = new HashMap<String, Boolean>();
            }
            this.layersVisibility.put(layer, displayed);
        }
    }

    public List<JImageFeature> getImageFeatures(String layer) {
        if (this.layers != null) {
            return this.layers.get(layer);
        }
        return null;
    }

    public void setImageFeatures(String layer, List<JImageFeature> features) {
        if (this.layers == null) {
            this.layers = new HashMap<String, List<JImageFeature>>();
        }
        this.layers.put(layer, features);
    }

    public boolean addImageFeature(String layer, JImageFeature feature) {
        if (feature != null) {
            if (this.layers == null) {
                this.layers = new HashMap<String, List<JImageFeature>>();
            }
            if (this.layers.get(layer) == null) {
                this.layers.put(layer, new ArrayList());
            }
            this.layers.get(layer).add(feature);
            return true;
        }
        return false;
    }

    public boolean removeImageFeature(String layer, JImageFeature feature) {
        if (feature == null) {
            return false;
        }
        if (this.layers != null) {
            if (this.layers.get(layer) != null) {
                return this.layers.get(layer).remove(feature);
            }
            return false;
        }
        return false;
    }

    public Point2D getImageCoordinate(int x, int y) {
        if (this.image != null) {
            if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
                Point2D.Float dest = new Point2D.Float();
                Point2D.Float src = new Point2D.Float(x, y);
                try {
                    this.transform.inverseTransform(src, dest);
                    if (dest.getX() < 0.0 || dest.getX() >= (double)(this.image.getWidth() - 1) || dest.getY() < 0.0 || dest.getY() >= (double)(this.image.getHeight() - 1)) {
                        dest = null;
                    }
                }
                catch (NoninvertibleTransformException e) {
                    return null;
                }
                return dest;
            }
            return null;
        }
        return null;
    }

    public Point2D getViewCoordinate(float x, float y) {
        if (this.image != null) {
            if (this.transform != null) {
                Point2D.Float dest = new Point2D.Float();
                Point2D.Float src = new Point2D.Float(x, y);
                this.transform.transform(src, dest);
                return dest;
            }
            return null;
        }
        return null;
    }
}

