/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jorigin.gui.IconLoader;
import org.jorigin.task.ActivityCaret;
import org.jorigin.task.TaskEvent;
import org.jorigin.task.gui.JTaskProgress;

public class ActivityMonitor
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int SHOW_PROGRESS_PERCENT = 1;
    public static final int SHOW_PROGRESS_COUNT = 2;
    public static final int SHOW_PROGRESS_ALL = 3;
    private Lock lock = null;
    private GridBagLayout layout;
    private DefaultStyledDocument activityTracerDocument;
    private JPanel progressBarsPN = null;
    private StyleContext sc = null;
    private Style taskStartedStyle = null;
    private Style taskFinishedStyle = null;
    private Style taskProgressStyle = null;
    private Style taskInfoStyle = null;
    private Style taskWarningStyle = null;
    private Style taskErrorStyle = null;
    private JTextPane activityTracer;
    private JScrollPane activityTracerScrollPane;
    private JPanel activityTracerPN = null;
    private JCheckBox persistenceCheckBox;
    private boolean showProgressionText = false;
    private boolean textAreaVisible = false;
    private boolean persistenceCheckBoxVisible = false;
    private boolean progressLabelVisible = false;
    private boolean progressBarVisible = false;
    private HashMap<String, JTaskProgress> taskProgressMap = null;
    int showProgressType = 3;
    private boolean isPersistent = true;
    private int boundedTask;
    private boolean useNewLine = true;
    private int activityTracerHeight = 440;
    private int progressBarHeight = 24;
    private int progressLabelHeight = 16;

    public boolean isUseNewLine() {
        return this.useNewLine;
    }

    public void setUseNewLine(boolean useNewLine) {
        this.useNewLine = useNewLine;
    }

    public ActivityMonitor(JFrame owner, boolean activityTracerVisible, boolean progressLabelVisible, boolean progressBarVisible) {
        super(owner);
        super.setDefaultCloseOperation(1);
        this.textAreaVisible = activityTracerVisible;
        this.progressBarVisible = progressBarVisible;
        this.progressLabelVisible = progressLabelVisible;
        this.taskProgressMap = new LinkedHashMap<String, JTaskProgress>();
        this.sc = new StyleContext();
        this.taskStartedStyle = this.sc.addStyle("taskStarted", null);
        this.taskFinishedStyle = this.sc.addStyle("taskFinished", null);
        this.taskProgressStyle = this.sc.addStyle("taskProgress", null);
        this.taskInfoStyle = this.sc.addStyle("taskInfo", null);
        this.taskWarningStyle = this.sc.addStyle("taskWarning", null);
        this.taskErrorStyle = this.sc.addStyle("taskError", null);
        StyleConstants.setBold(this.taskStartedStyle, true);
        StyleConstants.setFontFamily(this.taskStartedStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskStartedStyle, 11);
        StyleConstants.setForeground(this.taskStartedStyle, Color.black);
        StyleConstants.setBold(this.taskFinishedStyle, true);
        StyleConstants.setFontFamily(this.taskFinishedStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskFinishedStyle, 11);
        StyleConstants.setForeground(this.taskFinishedStyle, Color.black);
        StyleConstants.setBold(this.taskProgressStyle, false);
        StyleConstants.setFontFamily(this.taskProgressStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskProgressStyle, 11);
        StyleConstants.setForeground(this.taskProgressStyle, Color.black);
        StyleConstants.setBold(this.taskInfoStyle, false);
        StyleConstants.setFontFamily(this.taskInfoStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskInfoStyle, 11);
        StyleConstants.setForeground(this.taskInfoStyle, Color.black);
        StyleConstants.setBold(this.taskWarningStyle, false);
        StyleConstants.setFontFamily(this.taskWarningStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskWarningStyle, 11);
        StyleConstants.setForeground(this.taskWarningStyle, Color.ORANGE);
        StyleConstants.setBold(this.taskErrorStyle, false);
        StyleConstants.setFontFamily(this.taskErrorStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskErrorStyle, 11);
        StyleConstants.setForeground(this.taskErrorStyle, Color.RED);
        this.lock = new ReentrantLock();
        this.initGUI();
    }

    public ActivityMonitor(JFrame owner) {
        this(owner, false, true, true);
    }

    public int getActivityTracerHeight() {
        return this.activityTracerHeight;
    }

    public void setActivityTracerHeight(int height) {
        this.activityTracerHeight = height;
    }

    public int getProgressBarHeight() {
        return this.progressBarHeight;
    }

    public void setProgressBarHeight(int height) {
        this.progressBarHeight = height;
    }

    public int getProgressLabelHeight() {
        return this.progressLabelHeight;
    }

    public void setProgressLabelHeight(int height) {
        this.progressLabelHeight = height;
    }

    public boolean isActivityTracerVisible() {
        return this.textAreaVisible;
    }

    public void setActivityTracerVisible(boolean visible) {
        if (this.isActivityTracerVisible() != visible) {
            this.textAreaVisible = visible;
            if (visible) {
                this.activityTracerPN.add((Component)this.activityTracerScrollPane, "Center");
                Dimension dim = this.getSize();
                Dimension newDim = new Dimension((int)dim.getWidth(), (int)(dim.getHeight() + this.activityTracerPN.getSize().getHeight()));
                this.setSize(newDim);
                this.setPreferredSize(newDim);
            } else {
                this.activityTracerPN.remove(this.activityTracerScrollPane);
                Dimension dim = this.getSize();
                Dimension newDim = new Dimension((int)dim.getWidth(), (int)(dim.getHeight() - this.activityTracerPN.getSize().getHeight()));
                this.setSize(newDim);
                this.setPreferredSize(newDim);
            }
            this.validate();
            this.refreshGUI();
        }
    }

    public boolean isPersistenceCheckBoxVisible() {
        return this.persistenceCheckBoxVisible;
    }

    public void setPersistenceCheckBoxVisible(boolean visible) {
        this.persistenceCheckBoxVisible = visible;
        this.refreshGUI();
    }

    public boolean isProgessLabelVisible() {
        return this.progressLabelVisible;
    }

    public void setProgressLabelVisible(boolean visible) {
        this.progressLabelVisible = visible;
        this.refreshGUI();
    }

    public boolean isProgessBarVisible() {
        return this.progressBarVisible;
    }

    public void setProgressBarVisible(boolean visible) {
        this.progressBarVisible = visible;
        this.refreshGUI();
    }

    public boolean isShowProgressionText() {
        return this.showProgressionText;
    }

    public void setShowProgressionText(boolean showProgressionText) {
        this.showProgressionText = showProgressionText;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
        if (isPersistent) {
            this.persistenceCheckBox.setSelected(false);
        } else {
            this.persistenceCheckBox.setSelected(true);
        }
    }

    public boolean isPersistent() {
        return this.isPersistent();
    }

    protected void initGUI() {
        this.activityTracer = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint() {
                try {
                    super.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void repaint(long tm) {
                try {
                    super.repaint(tm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void repaint(int x, int y, int width, int height) {
                try {
                    super.repaint(x, y, width, height);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
                try {
                    super.repaint(tm, x, y, width, height);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void setCaretPosition(int position) {
                try {
                    super.setCaretPosition(position);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.activityTracer.setCaret(new ActivityCaret());
        this.activityTracer.setMaximumSize(new Dimension(65535, 65535));
        this.activityTracerDocument = (DefaultStyledDocument)this.activityTracer.getDocument();
        this.activityTracerScrollPane = new JScrollPane();
        this.activityTracerScrollPane.setSize(320, 400);
        this.activityTracerScrollPane.setPreferredSize(new Dimension(320, 400));
        this.activityTracerScrollPane.setMinimumSize(new Dimension(180, 250));
        this.activityTracerScrollPane.setHorizontalScrollBarPolicy(30);
        this.activityTracerScrollPane.setVerticalScrollBarPolicy(20);
        this.activityTracerScrollPane.setWheelScrollingEnabled(true);
        this.activityTracerScrollPane.getViewport().add(this.activityTracer);
        this.activityTracerPN = new JPanel();
        this.activityTracerPN.setLayout(new BorderLayout());
        if (this.isActivityTracerVisible()) {
            this.activityTracerPN.add((Component)this.activityTracerScrollPane, "Center");
        }
        this.progressBarsPN = new JPanel();
        this.progressBarsPN.setLayout(new GridBagLayout());
        this.persistenceCheckBox = new JCheckBox("Close");
        this.persistenceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ActivityMonitor.this.isPersistent = e.getStateChange() != 1;
            }
        });
        this.layout = new GridBagLayout();
        this.setTitle("Monitor");
        this.setIconImage(IconLoader.getImage("arpenteur/monitor/monitor-frame.png"));
        this.setName("Monitor");
        this.getContentPane().setLayout(this.layout);
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = 11;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.add((Component)this.activityTracerPN, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.add((Component)this.progressBarsPN, c);
        if (this.isPersistenceCheckBoxVisible()) {
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridheight = 1;
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 11;
            this.add((Component)this.persistenceCheckBox, c);
        }
        if (this.getOwner() != null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }
        int frameWidth = 600;
        int frameHeight = 0;
        if (this.isActivityTracerVisible()) {
            frameHeight += this.getActivityTracerHeight();
        }
        if (this.isProgessBarVisible()) {
            frameHeight += this.getProgressBarHeight();
        }
        if (this.isProgessLabelVisible()) {
            frameHeight += this.getProgressLabelHeight();
        }
        this.setSize(new Dimension(frameWidth, frameHeight));
        this.setPreferredSize(new Dimension(frameWidth, frameHeight));
        this.pack();
    }

    protected void refreshGUI() {
    }

    public void init(boolean activityVisible, boolean progressBarVisible) {
        Point location = null;
        Dimension ownerSize = null;
        Dimension size = null;
        if (this.getOwner() != null) {
            location = this.getOwner().getLocation();
            ownerSize = this.getOwner().getSize();
            size = this.getSize();
            location = new Point((int)(location.getX() + ownerSize.getWidth() / 2.0), (int)(location.getY() + ownerSize.getHeight() / 2.0));
            System.out.println(location);
            this.setLocation((int)(location.getX() - (double)(size.width / 2)), (int)(location.getY() + (double)(size.height / 2)));
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation(0, 0);
        }
        this.activityTracerScrollPane.setVisible(activityVisible);
        this.boundedTask = 0;
        this.isPersistent = true;
        this.pack();
    }

    private String indent(String str, int indent) {
        Object tmp = new String();
        for (int i = 0; i < indent; ++i) {
            tmp = (String)tmp + " ";
        }
        tmp = (String)tmp + str;
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String str, Style style) {
        try {
            this.lock.lock();
            if (this.isUseNewLine()) {
                this.activityTracerDocument.insertString(this.activityTracerDocument.getLength(), "\n" + str, style);
            } else {
                this.activityTracerDocument.insertString(this.activityTracerDocument.getLength(), str, style);
            }
            this.activityTracer.setCaretPosition(this.activityTracerDocument.getLength());
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeWithIndent(String str, int indent, Style style) {
        this.write(this.indent(str, indent * 2), style);
    }

    public void processTaskEvent(TaskEvent event) {
        this.processTaskEvent(event, true);
    }

    public void processTaskEvent(TaskEvent event, boolean progressBarVisible) {
        JTaskProgress taskProgress = null;
        try {
            switch (event.getID()) {
                case 3998: {
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask, this.taskStartedStyle);
                    }
                    if (progressBarVisible) {
                        taskProgress = new JTaskProgress(this.isProgessLabelVisible(), this.isProgessBarVisible());
                        taskProgress.getLabel().setText(event.getDescription());
                        ++this.boundedTask;
                        if (event.getSize() > 0) {
                            taskProgress.getProgressBar().setMinimum(0);
                            taskProgress.getProgressBar().setMaximum(event.getSize());
                            taskProgress.getProgressBar().setValue(0);
                            taskProgress.getProgressBar().setIndeterminate(false);
                        } else {
                            taskProgress.getProgressBar().setMinimum(0);
                            taskProgress.getProgressBar().setMaximum(0);
                            taskProgress.getProgressBar().setValue(0);
                            taskProgress.getProgressBar().setIndeterminate(true);
                        }
                        taskProgress.getProgressBar().setStringPainted(true);
                        this.taskProgressMap.put(event.getTaskName(), taskProgress);
                        this.addJTaskProgress(taskProgress);
                    }
                    this.setVisible(true);
                    break;
                }
                case 7996: {
                    String progress = null;
                    String percent = null;
                    Object text = "";
                    int ratio = 0;
                    int size = event.getSize();
                    taskProgress = this.taskProgressMap.get(event.getTaskName());
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        if (this.isUseNewLine()) {
                            this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskProgressStyle);
                        } else {
                            this.write(event.getDescription(), this.taskProgressStyle);
                        }
                    }
                    if (taskProgress != null) {
                        if (event.getDescription() != null) {
                            taskProgress.getLabel().setText(event.getDescription());
                        }
                        if (size >= 0) {
                            taskProgress.getProgressBar().setValue(size);
                        }
                        if (this.showProgressionText && !taskProgress.getProgressBar().isIndeterminate() && size >= 0) {
                            if ((this.showProgressType & 2) != 0) {
                                progress = size + " / " + taskProgress.getProgressBar().getMaximum();
                            }
                            if ((this.showProgressType & 1) != 0) {
                                ratio = (int)((float)size / (float)taskProgress.getProgressBar().getMaximum() * 100.0f);
                                percent = ratio + "%%";
                            }
                            if (progress != null) {
                                text = (String)text + progress;
                            }
                            if (percent != null) {
                                text = !((String)text).equals("") ? (String)text + " - " + percent : (String)text + percent;
                            }
                            taskProgress.getProgressBar().setString((String)text);
                        }
                        taskProgress.getProgressBar().repaint();
                    }
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 15992: {
                    break;
                }
                case 31984: {
                    --this.boundedTask;
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription() + "\n", this.boundedTask, this.taskFinishedStyle);
                    }
                    if (this.boundedTask < 1 && !this.isPersistent) {
                        this.setVisible(false);
                    }
                    this.removeJTaskProgress(this.taskProgressMap.get(event.getTaskName()));
                    this.taskProgressMap.remove(event.getTaskName());
                    break;
                }
                case 63968: {
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        if (this.isUseNewLine()) {
                            this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskWarningStyle);
                        } else {
                            this.write(event.getDescription(), this.taskWarningStyle);
                        }
                    }
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 127936: {
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        if (this.isUseNewLine()) {
                            this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskErrorStyle);
                        } else {
                            this.write(event.getDescription(), this.taskErrorStyle);
                        }
                    }
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 255872: {
                    if (this.isActivityTracerVisible() && event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        if (this.isUseNewLine()) {
                            this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskInfoStyle);
                        } else {
                            this.write(event.getDescription(), this.taskInfoStyle);
                        }
                    }
                    this.activityTracer.repaint();
                    this.repaint();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disposeTasks() {
        this.boundedTask = 0;
        Iterator<JTaskProgress> iter = this.taskProgressMap.values().iterator();
        while (iter.hasNext()) {
            this.removeJTaskProgress(iter.next());
        }
        if (!this.isPersistent) {
            this.setVisible(false);
        }
    }

    private boolean addJTaskProgress(JTaskProgress taskProgress) {
        if (taskProgress != null) {
            GridBagConstraints c = null;
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridheight = 1;
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 11;
            this.progressBarsPN.add((Component)taskProgress, c);
            Dimension size = this.getSize();
            Dimension preferredSize = this.getPreferredSize();
            int height = (int)size.getHeight();
            int preferredHeight = (int)preferredSize.getHeight();
            if (this.isProgessLabelVisible()) {
                height += this.getProgressLabelHeight();
                preferredHeight += this.getProgressLabelHeight();
            }
            if (this.isProgessBarVisible()) {
                height += this.getProgressBarHeight();
                preferredHeight += this.getProgressLabelHeight();
            }
            Dimension newSize = new Dimension((int)size.getWidth(), height);
            Dimension newPreferredSize = new Dimension((int)preferredSize.getWidth(), preferredHeight);
            this.setSize(newSize);
            this.setPreferredSize(newPreferredSize);
            this.pack();
            this.validate();
            this.repaint();
            size = null;
            preferredSize = null;
            newSize = null;
            newPreferredSize = null;
            return true;
        }
        return false;
    }

    private boolean removeJTaskProgress(JTaskProgress taskProgress) {
        if (taskProgress != null) {
            this.progressBarsPN.remove(taskProgress);
            Dimension size = this.getSize();
            Dimension preferredSize = this.getPreferredSize();
            int height = (int)size.getHeight();
            int preferredHeight = (int)preferredSize.getHeight();
            if (this.isProgessLabelVisible()) {
                height -= this.getProgressLabelHeight();
                preferredHeight -= this.getProgressLabelHeight();
            }
            if (this.isProgessBarVisible()) {
                height -= this.getProgressBarHeight();
                preferredHeight -= this.getProgressLabelHeight();
            }
            Dimension newSize = new Dimension((int)size.getWidth(), height);
            Dimension newPreferredSize = new Dimension((int)preferredSize.getWidth(), preferredHeight);
            this.setSize(newSize);
            this.setPreferredSize(newPreferredSize);
            this.pack();
            this.validate();
            this.repaint();
            size = null;
            preferredSize = null;
            newSize = null;
            newPreferredSize = null;
            return true;
        }
        return false;
    }
}

