/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;

public class JMemoryStateBar
extends JPanel {
    private static final long serialVersionUID = 202005081200L;
    public static final String COMMAND_GARBAGE = "commandGarbage";
    public static final String COMMAND_ACTIVE = "commandActive";
    private JProgressBar memoryStateBar = null;
    private JButton memoryGarbageCollectorButton = null;
    private JToggleButton memoryMonitorActivateButton = null;
    private SwingWorker<Object, Object> memoryMonitor = null;
    private long refreshDelay = 500L;
    private boolean isActive = true;

    public JMemoryStateBar() {
        this.initGUI();
    }

    protected void initGUI() {
        this.memoryStateBar = new JProgressBar();
        this.memoryStateBar.setSize(new Dimension(100, 20));
        this.memoryStateBar.setPreferredSize(new Dimension(100, 20));
        this.memoryStateBar.setMinimum(0);
        this.memoryStateBar.setMaximum((int)(Runtime.getRuntime().totalMemory() / 1024L));
        this.memoryStateBar.setIndeterminate(false);
        this.memoryStateBar.setStringPainted(true);
        final JProgressBar stateBar = this.memoryStateBar;
        this.memoryMonitor = new SwingWorker<Object, Object>(){
            int occupedMemory = 0;
            int totalMemory = 0;

            @Override
            public Object doInBackground() {
                JMemoryStateBar.this.isActive = true;
                while (JMemoryStateBar.this.isActive) {
                    this.totalMemory = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                    this.occupedMemory = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
                    stateBar.setMaximum(this.totalMemory * 1024);
                    stateBar.setValue(this.occupedMemory * 1024);
                    stateBar.setString(this.occupedMemory + " Mo / " + this.totalMemory + " Mo");
                    try {
                        Thread.sleep(JMemoryStateBar.this.refreshDelay);
                    }
                    catch (InterruptedException ex) {
                        JMemoryStateBar.this.isActive = true;
                    }
                }
                return null;
            }
        };
        this.memoryGarbageCollectorButton = new JButton();
        this.memoryGarbageCollectorButton.setIcon(new ImageIcon(this.getClass().getResource("memory_monitor_garbage.png")));
        this.memoryGarbageCollectorButton.setPreferredSize(new Dimension(20, 20));
        this.memoryGarbageCollectorButton.setEnabled(true);
        this.memoryGarbageCollectorButton.setToolTipText("Force unused memory free");
        this.memoryGarbageCollectorButton.setActionCommand(COMMAND_GARBAGE);
        this.memoryGarbageCollectorButton.setContentAreaFilled(true);
        this.memoryGarbageCollectorButton.setFocusPainted(true);
        this.memoryGarbageCollectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.memoryMonitorActivateButton = new JToggleButton();
        this.memoryMonitorActivateButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("memory_monitor_inactive.png")));
        this.memoryMonitorActivateButton.setIcon(new ImageIcon(this.getClass().getResource("memory_monitor_active.png")));
        this.memoryMonitorActivateButton.setPreferredSize(new Dimension(20, 20));
        this.memoryMonitorActivateButton.setEnabled(true);
        this.memoryMonitorActivateButton.setToolTipText("Desactivate the memory monitor");
        this.memoryMonitorActivateButton.setActionCommand(COMMAND_ACTIVE);
        this.memoryMonitorActivateButton.setContentAreaFilled(true);
        this.memoryMonitorActivateButton.setFocusPainted(true);
        this.memoryMonitorActivateButton.setSelected(true);
        this.memoryMonitorActivateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JMemoryStateBar.this.memoryMonitorActivateButton.isSelected()) {
                    JMemoryStateBar.this.startMonitor();
                } else {
                    JMemoryStateBar.this.stopMonitor();
                }
            }
        });
        this.setLayout(new FlowLayout());
        ((FlowLayout)this.getLayout()).setAlignment(0);
        ((FlowLayout)this.getLayout()).setHgap(1);
        ((FlowLayout)this.getLayout()).setVgap(1);
        this.add(this.memoryStateBar);
        this.add(this.memoryGarbageCollectorButton);
        this.add(this.memoryMonitorActivateButton);
        this.memoryMonitor.execute();
    }

    public void startMonitor() {
        this.memoryStateBar.setIndeterminate(false);
        this.memoryStateBar.setEnabled(true);
        this.isActive = true;
        this.memoryMonitorActivateButton.setToolTipText("Desactivate the memory monitor");
        this.memoryMonitor.execute();
    }

    public void stopMonitor() {
        this.isActive = false;
        this.memoryStateBar.setIndeterminate(true);
        this.memoryStateBar.setEnabled(false);
        this.memoryStateBar.setString("Inactive");
        this.memoryMonitorActivateButton.setToolTipText("Activate the memory monitor");
    }

    public void setRefreshDelay(long delay) {
        this.refreshDelay = delay;
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public Icon getGarbageIcon() {
        return this.memoryGarbageCollectorButton.getIcon();
    }

    public void setGarbageIcon(Icon icon) {
        this.memoryGarbageCollectorButton.setIcon(icon);
    }

    public Icon getActiveIcon() {
        return this.memoryMonitorActivateButton.getIcon();
    }

    public void setActiveIcon(Icon icon) {
        this.memoryMonitorActivateButton.setIcon(icon);
    }

    public Icon getInactiveIcon() {
        return this.memoryMonitorActivateButton.getSelectedIcon();
    }

    public void setInactiveIcon(Icon icon) {
        this.memoryMonitorActivateButton.setSelectedIcon(icon);
    }
}

