/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.lang;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtil {
    public static final int SYSTEM = 1;
    public static final int URL_FILE = 2;
    public static final int URL_HTTP = 3;
    public static final int URL_FTP = 4;
    public static final int URL_SFTP = 5;
    public static final int SMB = 6;
    public static final int MYSQL = 7;
    public static final int UNKNOWN = 1000;

    public static URI pathToURI(String path) {
        URI uri = null;
        Object str = new String(path);
        if (path == null) {
            return null;
        }
        if (((String)(str = ((String)str).replace("\\", "/"))).endsWith("/")) {
            str = ((String)str).substring(0, ((String)str).length() - 1);
        }
        str = ((String)str).replaceAll("/{1,}+", "/");
        Pattern p = Pattern.compile("[a-zA-Z]:.*");
        Matcher m = p.matcher((CharSequence)str);
        if (m.matches()) {
            str = "file://" + (String)str;
        }
        if ((m = (p = Pattern.compile("file:[a-zA-Z]:.*")).matcher((CharSequence)str)).matches()) {
            p = Pattern.compile("file:");
            m = p.matcher((CharSequence)str);
            str = m.replaceFirst("file://");
        }
        if ((m = (p = Pattern.compile("file:/{1,}[a-zA-Z]:.*")).matcher((CharSequence)str)).matches()) {
            p = Pattern.compile("file:/{1,}");
            m = p.matcher((CharSequence)str);
            str = m.replaceFirst("file://");
        } else {
            p = Pattern.compile("file:/{1,}[^\\.].*");
            m = p.matcher((CharSequence)str);
            if (m.matches()) {
                p = Pattern.compile("file:/{1,}");
                m = p.matcher((CharSequence)str);
                str = m.replaceFirst("file:///");
            } else {
                p = Pattern.compile("file:/{1,}\\.{1,2}.*");
                m = p.matcher((CharSequence)str);
                if (m.matches()) {
                    p = Pattern.compile("file:/{1,}");
                    m = p.matcher((CharSequence)str);
                    str = m.replaceFirst("file://");
                } else {
                    p = Pattern.compile("http:/{1,}.*");
                    m = p.matcher((CharSequence)str);
                    if (m.matches()) {
                        p = Pattern.compile("http:/{1,}");
                        m = p.matcher((CharSequence)str);
                        str = m.replaceFirst("http://");
                    } else {
                        p = Pattern.compile("ftp:/{1,}.*");
                        m = p.matcher((CharSequence)str);
                        if (m.matches()) {
                            p = Pattern.compile("ftp:/{1,}");
                            m = p.matcher((CharSequence)str);
                            str = m.replaceFirst("ftp://");
                        } else {
                            p = Pattern.compile("/{1,}.*");
                            m = p.matcher(path);
                            str = m.matches() ? "file://" + (String)str : "file://" + (String)str;
                        }
                    }
                }
            }
        }
        try {
            str = ((String)str).replaceAll(" ", "%20");
            uri = new URI((String)str);
        }
        catch (URISyntaxException ex) {
            uri = null;
        }
        return uri;
    }

    public static String URIToPath(URI uri) {
        String path = null;
        if (uri == null) {
            return null;
        }
        try {
            if (uri.getScheme().compareTo("http") == 0 || uri.getScheme().compareTo("ftp") == 0) {
                return uri.toString();
            }
            path = uri.isAbsolute() ? (uri.getAuthority() != null ? new File(uri.getAuthority() + uri.getPath()).getPath() : uri.getPath()) : new File(uri.toString()).getPath();
            if (path != null) {
                path = path.replace("%20", " ");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            path = null;
        }
        if (PathUtil.getProtocol(path) == 1) {
            path = path.replace("/", File.separator);
        }
        return path;
    }

    public static String URIToPath(String uri) {
        URI tmpuri = null;
        if (uri == null) {
            return null;
        }
        tmpuri = PathUtil.pathToURI(uri);
        if (tmpuri == null) {
            return null;
        }
        tmpuri = tmpuri.normalize();
        return PathUtil.URIToPath(tmpuri);
    }

    public static int getProtocol(String path) {
        if (path == null) {
            return 0;
        }
        Pattern p = Pattern.compile("file:.*");
        Matcher m = p.matcher(path);
        if (m.matches()) {
            return 2;
        }
        p = Pattern.compile("http:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 3;
        }
        p = Pattern.compile("ftp:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 4;
        }
        p = Pattern.compile("sftp:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 5;
        }
        p = Pattern.compile("smb:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 6;
        }
        p = Pattern.compile("mysql:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 7;
        }
        p = Pattern.compile("/{1,}.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 1;
        }
        p = Pattern.compile("[a-zA-Z]:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 1;
        }
        p = Pattern.compile("[a-zA-Z]{2,}:.*");
        m = p.matcher(path);
        if (m.matches()) {
            return 1000;
        }
        return 1;
    }

    public static boolean isAbsoluteURL(String url) {
        return url.startsWith("file:/") || url.startsWith("http:/");
    }

    public static boolean isAbsolutePath(String path) {
        String tmp = null;
        boolean isAbsolute = false;
        switch (PathUtil.getProtocol(path)) {
            case 1: {
                Pattern p = Pattern.compile("[a-zA-Z]:.*");
                Matcher m = p.matcher(path);
                if (m.matches()) {
                    isAbsolute = true;
                    break;
                }
                if (path.startsWith("/")) {
                    isAbsolute = true;
                    break;
                }
                isAbsolute = false;
                break;
            }
            case 2: {
                tmp = PathUtil.pathToURI(path).toString();
                tmp = tmp.replaceFirst("[a-zA-Z]{1,}://", "");
                Pattern p = Pattern.compile("[a-zA-Z]:.*");
                Matcher m = p.matcher(tmp);
                if (m.matches()) {
                    isAbsolute = true;
                    break;
                }
                if (tmp.startsWith("/")) {
                    isAbsolute = true;
                    break;
                }
                isAbsolute = false;
                break;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return isAbsolute;
    }

    public static String relativize(URI uri, URI root) {
        return root.relativize(uri).toString();
    }

    public static URI resolve(String path, String root) {
        URI uri = null;
        URI uriRoot = null;
        String str = null;
        String strPath = new String(path);
        String strRoot = new String(root);
        try {
            uriRoot = PathUtil.pathToURI(strRoot);
            uri = PathUtil.pathToURI(strPath);
            if (uri.getScheme().compareTo("http") != 0 && uri.getScheme().compareTo("ftp") != 0) {
                if (uri.getScheme().compareTo("file") == 0) {
                    str = uri.toString();
                    str = str.replaceFirst("file://", "");
                    uri = new URI(str);
                    strRoot = strRoot.replaceFirst("file://", "");
                    uriRoot = new URI(strRoot);
                    uriRoot.normalize();
                }
                uri = uri.normalize();
                uri = PathUtil.pathToURI(uriRoot.resolve(uri).toString());
            }
        }
        catch (URISyntaxException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        uri = uri.normalize();
        if (uri.isAbsolute()) {
            if (uri.getScheme().compareTo("http") == 0) {
                return uri;
            }
            if (uri.getScheme().compareTo("file") == 0) {
                return uri;
            }
            if (uri.getScheme().compareTo("ftp") == 0) {
                return uri;
            }
            return uri;
        }
        System.err.println(uri);
        return uri;
    }

    public static String relativize(String path, String root) {
        URI uri = null;
        URI uriRoot = null;
        String str = null;
        try {
            uriRoot = PathUtil.pathToURI(root);
            uri = PathUtil.pathToURI(path);
            if (uri.getScheme().compareTo("http") != 0 && uri.getScheme().compareTo("ftp") != 0) {
                if (uri.getScheme().compareTo("file") == 0) {
                    str = uri.toString();
                    str = str.replaceFirst("file://", "");
                    uri = new URI(str);
                    root = root.replaceFirst("file://", "");
                    uriRoot = new URI(root);
                    uriRoot.normalize();
                }
                uri = uri.normalize();
                uri = PathUtil.pathToURI(uriRoot.relativize(uri).toString());
            }
        }
        catch (URISyntaxException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        uri = uri.normalize();
        if (uri.isAbsolute()) {
            if (uri.getScheme().compareTo("http") == 0) {
                return uri.toString();
            }
            if (uri.getScheme().compareTo("file") == 0) {
                return uri.toString();
            }
            if (uri.getScheme().compareTo("ftp") == 0) {
                return uri.toString();
            }
            return uri.toString();
        }
        System.err.println(uri);
        return uri.toString();
    }

    public static String getFileName(String path) {
        String fileName = null;
        String uri = null;
        if (path == null) {
            return null;
        }
        uri = PathUtil.pathToURI(path).toString();
        fileName = uri != null ? (uri.indexOf("/") != -1 ? uri.substring(uri.lastIndexOf("/") + 1) : new String(uri)) : null;
        return fileName;
    }

    public static String getExtension(String path) {
        String extension = null;
        if (path != null && path.contains(".") && path.lastIndexOf(".") < path.length() - 1) {
            extension = path.substring(path.lastIndexOf(".") + 1);
        }
        return extension;
    }

    public static String getDirectory(String path) {
        if (path == null) {
            return null;
        }
        String tmp = path.replace("\\", "/");
        int lastSeparatorIndex = tmp.lastIndexOf("/");
        if (lastSeparatorIndex >= 0) {
            return path.substring(0, lastSeparatorIndex);
        }
        return null;
    }

    public static String getStrictFileName(String path) {
        String strictFileName = null;
        String tmp = null;
        tmp = PathUtil.getFileName(path);
        strictFileName = tmp != null ? (tmp.indexOf(".") != -1 ? tmp.substring(0, tmp.lastIndexOf(".")) : new String(tmp)) : null;
        return strictFileName;
    }

    public static URL pathToURL(String path) {
        String str = new String(path);
        str = PathUtil.pathToURI(path).toString();
        if (!str.startsWith("http")) {
            str = str.replaceAll("/{1,}+", "/");
        }
        URL url = null;
        try {
            url = new URL(str);
        }
        catch (MalformedURLException ex) {
            url = null;
        }
        return url;
    }

    public static String removeRoot(String path) {
        Pattern p;
        Matcher m;
        String str = "";
        str = PathUtil.pathToURI(path).toString();
        if ((str = str.replaceFirst("[a-zA-Z]{1,}://", "")).startsWith("/")) {
            str = str.substring(1);
        }
        if ((m = (p = Pattern.compile("[a-zA-Z]:.*")).matcher(str)).matches()) {
            str = str.substring(2);
        }
        return str;
    }
}

