/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.lang.xml;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jorigin.lang.LangResource;
import org.jorigin.lang.xml.LangResourceContentHandler;
import org.jorigin.lang.xml.LangResourceErrorHandler;
import org.jorigin.lang.xml.LangResourceXMLFilter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LangResourceXMLReader {
    protected EventListenerList idListenerList = new EventListenerList();
    protected LangResource resource = null;
    String uri = null;
    boolean working = false;

    public LangResourceXMLReader() {
        this.uri = null;
    }

    public LangResourceXMLReader(String uri) {
        this.uri = uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public LangResource getResource() {
        return this.resource;
    }

    public boolean isWorking() {
        return this.working;
    }

    public HashMap<String, String> getParsedLangResource(String uri) throws IOException {
        LangResourceContentHandler contentHandler = new LangResourceContentHandler();
        LangResourceErrorHandler errorHandler = new LangResourceErrorHandler();
        XMLReader parser = null;
        LangResourceXMLFilter xmlFilterImpl = null;
        this.working = true;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            parser = factory.newSAXParser().getXMLReader();
            xmlFilterImpl = new LangResourceXMLFilter(parser);
            xmlFilterImpl.setContentHandler(contentHandler);
            xmlFilterImpl.setErrorHandler(errorHandler);
            xmlFilterImpl.parse(uri);
        }
        catch (IOException ex) {
            throw new IOException("No such file " + uri, ex);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage() + "\nParsing " + uri, ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage() + "\nUnable to configure parser for " + uri, ex);
        }
        this.working = false;
        return contentHandler.getResources();
    }
}

