/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.swing;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import org.jorigin.Common;
import org.jorigin.lang.PathUtil;

public class IconLoader {
    public static final String ICON_LOADER_DIR = "org.jorigin.icon.dir";
    public static int PATH_TYPE_UNKNOWN = 0;
    public static int PATH_TYPE_FILESYSTEM = 1;
    public static int PATH_TYPE_URL = 2;
    public static int PATH_TYPE_EMBEDDED_JAR = 4;
    public static int PATH_TYPE_EMBEDDED_ZIP = 4;
    private static String iconDirectory = "/";
    private static int pathType = 0;

    private static void init() {
        if (System.getProperty(ICON_LOADER_DIR) != null) {
            IconLoader.setIconDirectory(System.getProperty(ICON_LOADER_DIR));
            Common.logger.log(Level.INFO, "Icon directory: " + IconLoader.getIconDirectory() + " (from property org.jorigin.icon.dir)");
        } else {
            Common.logger.log(Level.INFO, "Icon directory: " + IconLoader.getIconDirectory() + " (default)");
        }
    }

    public static ImageIcon getIcon(String path) {
        ImageIcon image = null;
        if (PathUtil.isAbsolutePath(path)) {
            String processedPath = PathUtil.URIToPath(path);
            try {
                image = new ImageIcon(processedPath);
                if (image.getIconWidth() < 1) {
                    image = null;
                    Common.logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + processedPath + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
            if (image != null) {
                return image;
            }
            Class<?> c = MethodHandles.lookup().lookupClass();
            URL url = c.getResource(path);
            if (url == null) {
                Common.logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                return null;
            }
            try {
                image = new ImageIcon(url);
                if (image.getIconWidth() < 1) {
                    image = null;
                    Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
        } else if (iconDirectory != null && !iconDirectory.isEmpty()) {
            if (pathType == PATH_TYPE_EMBEDDED_JAR) {
                String inputFile = iconDirectory + path;
                try {
                    URL inputURL = new URL(inputFile);
                    image = new ImageIcon(inputURL);
                    if (image.getIconWidth() < 1) {
                        image = null;
                        Common.logger.log(Level.WARNING, "Icon " + inputURL.toExternalForm() + " is not a valid image file.");
                    }
                }
                catch (Exception ex) {
                    Common.logger.log(Level.WARNING, "Icon " + inputFile + " cannot be loaded: " + ex.getMessage(), ex);
                    image = null;
                }
            } else {
                if (pathType == PATH_TYPE_EMBEDDED_ZIP) {
                    Common.logger.log(Level.WARNING, "Icon " + path + " load from ZIP file is not handled.");
                    return null;
                }
                String processedPath = iconDirectory + path;
                try {
                    image = new ImageIcon(processedPath);
                    if (image.getIconWidth() < 1) {
                        image = null;
                        Common.logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                    }
                }
                catch (Exception ex) {
                    Common.logger.log(Level.WARNING, "Icon " + iconDirectory + "/" + processedPath + " cannot be loaded: " + ex.getMessage(), ex);
                    image = null;
                }
                if (image == null) {
                    Class<?> c = MethodHandles.lookup().lookupClass();
                    URL url = c.getResource(iconDirectory + path);
                    if (url == null) {
                        Common.logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                        return null;
                    }
                    try {
                        image = new ImageIcon(url);
                        if (image.getIconWidth() < 1) {
                            image = null;
                            Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                        }
                    }
                    catch (Exception ex) {
                        Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                        image = null;
                    }
                }
            }
        } else {
            String processedPath = PathUtil.URIToPath(path);
            try {
                image = new ImageIcon(processedPath);
                if (image.getIconWidth() < 1) {
                    image = null;
                    Common.logger.log(Level.WARNING, "Icon " + processedPath + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + processedPath + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
            if (image != null) {
                return image;
            }
            Class<?> c = MethodHandles.lookup().lookupClass();
            URL url = c.getResource(path);
            if (url == null) {
                Common.logger.log(Level.WARNING, "Icon " + path + " does not match a resource.");
                return null;
            }
            try {
                image = new ImageIcon(url);
                if (image.getIconWidth() < 1) {
                    image = null;
                    Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " is not a valid image file.");
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + url.toExternalForm() + " cannot be loaded: " + ex.getMessage(), ex);
                image = null;
            }
        }
        return image;
    }

    public static Image getImage(String path) {
        ImageIcon icon = IconLoader.getIcon(path);
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    public static ImageIcon getScaledIcon(String name, Dimension dimension) {
        return IconLoader.getScaledIcon(name, dimension.getWidth(), dimension.getHeight());
    }

    public static ImageIcon getScaledIcon(String name, double width, double height) {
        ImageIcon icon = IconLoader.getIcon(name);
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        if (icon != null) {
            icon.setImage(icon.getImage().getScaledInstance((int)(width * (double)dpi / 25.4), (int)(height * (double)dpi / 25.4), 4));
        }
        return icon;
    }

    public static String getIconDirectory() {
        return iconDirectory;
    }

    public static void setIconDirectory(String path) {
        if (path != null) {
            String lowerPath = path.toLowerCase();
            if (lowerPath.startsWith("file:") || lowerPath.startsWith("http:") || lowerPath.startsWith("https:") || lowerPath.startsWith("ftp:") || lowerPath.startsWith("sftp:")) {
                pathType = PATH_TYPE_URL;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (lowerPath.startsWith("jar:")) {
                pathType = PATH_TYPE_EMBEDDED_JAR;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (PathUtil.isAbsolutePath(lowerPath)) {
                pathType = PATH_TYPE_FILESYSTEM;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else if (lowerPath.startsWith("zip:")) {
                pathType = PATH_TYPE_EMBEDDED_ZIP;
                iconDirectory = !path.endsWith("/") ? path + "/" : path;
            } else {
                pathType = PATH_TYPE_UNKNOWN;
                iconDirectory = path;
            }
            Common.logger.log(Level.INFO, "Using icon path " + path + " (" + pathType + ")");
        } else {
            iconDirectory = null;
            Common.logger.log(Level.INFO, "No icon path set " + path);
        }
    }

    static {
        IconLoader.init();
    }
}

