/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.swing.task;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import org.jorigin.Common;

public class ActivityCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    public static final int NEVER_UPDATE = 1;
    public static final int ALWAYS_UPDATE = 2;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    int updatePolicy = 0;
    boolean visible;
    boolean active;
    int dot;
    int mark;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient Handler handler = new Handler();
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient NavigationFilter.FilterBypass filterBypass;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    private transient MouseEvent selectedWordEvent = null;
    private int caretWidth = -1;
    private float aspectRatio = -1.0f;

    private boolean isLeftToRight(AbstractDocument doc, int p0, int p1) {
        int index;
        if (!doc.getProperty("i18n").equals(Boolean.TRUE)) {
            return true;
        }
        Element bidiRoot = doc.getBidiRootElement();
        Element bidiElem = bidiRoot.getElement(index = bidiRoot.getElementIndex(p0));
        if (bidiElem.getEndOffset() >= p1) {
            AttributeSet bidiAttrs = bidiElem.getAttributes();
            return StyleConstants.getBidiLevel(bidiAttrs) % 2 == 0;
        }
        return true;
    }

    public void setUpdatePolicy(int policy) {
        this.updatePolicy = policy;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    protected synchronized void damage(Rectangle2D r) {
        if (r != null) {
            int damageWidth = this.getCaretWidth((int)r.getHeight());
            this.x = (int)r.getX() - 4 - (damageWidth >> 1);
            this.y = (int)r.getY();
            this.width = 9 + damageWidth;
            this.height = (int)r.getHeight();
            this.repaint();
        }
    }

    protected void adjustVisibility(Rectangle2D nloc) {
        if (this.component == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.component.scrollRectToVisible(new Rectangle((int)nloc.getX(), (int)nloc.getY(), (int)nloc.getWidth(), (int)nloc.getHeight()));
        } else {
            SwingUtilities.invokeLater(new SafeScroller(new Rectangle((int)nloc.getX(), (int)nloc.getY(), (int)nloc.getWidth(), (int)nloc.getHeight())));
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void positionCaret(MouseEvent e) {
        Point pt = new Point(e.getX(), e.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = this.component.getUI().viewToModel2D(this.component, pt, biasRet);
        if (biasRet[0] == null) {
            biasRet[0] = Position.Bias.Forward;
        }
        if (pos >= 0) {
            this.setDot(pos, biasRet[0]);
        }
    }

    protected void moveCaret(MouseEvent e) {
        Point pt = new Point(e.getX(), e.getY());
        Position.Bias[] biasRet = new Position.Bias[1];
        int pos = this.component.getUI().viewToModel2D(this.component, pt, biasRet);
        if (biasRet[0] == null) {
            biasRet[0] = Position.Bias.Forward;
        }
        if (pos >= 0) {
            this.moveDot(pos, biasRet[0]);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || e.isTemporary());
    }

    private void selectWord(MouseEvent e) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == e.getX() && this.selectedWordEvent.getY() == e.getY()) {
            return;
        }
        Action a = null;
        ActionMap map = this.getComponent().getActionMap();
        if (map != null) {
            a = map.get("select-word");
        }
        if (a != null) {
            a.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, e.getWhen(), e.getModifiersEx()));
            this.selectedWordEvent = e;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        block17: {
            int nclicks = e.getClickCount();
            if (!e.isConsumed()) {
                JTextComponent c;
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (nclicks == 1) {
                        this.selectedWordEvent = null;
                    } else if (nclicks == 2) {
                        this.selectWord(e);
                        this.selectedWordEvent = null;
                    } else if (nclicks == 3) {
                        Action a = null;
                        ActionMap map = this.getComponent().getActionMap();
                        if (map != null) {
                            a = map.get("select-line");
                        }
                        if (a != null) {
                            a.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, e.getWhen(), e.getModifiersEx()));
                        }
                    }
                } else if (SwingUtilities.isMiddleMouseButton(e) && nclicks == 1 && this.component.isEditable() && this.component.isEnabled() && (c = (JTextComponent)e.getSource()) != null) {
                    try {
                        Toolkit tk = c.getToolkit();
                        Clipboard buffer = tk.getSystemSelection();
                        if (buffer == null) break block17;
                        this.adjustCaret(e);
                        TransferHandler th = c.getTransferHandler();
                        if (th != null) {
                            Transferable trans = null;
                            try {
                                trans = buffer.getContents(null);
                            }
                            catch (IllegalStateException ise) {
                                UIManager.getLookAndFeel().provideErrorFeedback(c);
                            }
                            if (trans != null) {
                                th.importData(c, trans);
                            }
                        }
                        this.adjustFocus(true);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int nclicks = e.getClickCount();
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(e);
                if (nclicks == 2) {
                    this.selectWord(e);
                }
            }
        }
    }

    private void adjustCaretAndFocus(MouseEvent e) {
        this.adjustCaret(e);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent e) {
        if ((e.getModifiersEx() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e);
        } else {
            this.positionCaret(e);
        }
    }

    private void adjustFocus(boolean inWindow) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (inWindow) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(e)) {
            this.adjustCaretAndFocus(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e)) {
            this.moveCaret(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            try {
                Element bidi;
                TextUI mapper = this.component.getUI();
                Rectangle2D r = mapper.modelToView2D(this.component, this.dot, this.dotBias);
                if (r == null || r.getWidth() == 0.0 && r.getHeight() == 0.0) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this._contains((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight())) {
                    Rectangle clip = g.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r);
                }
                g.setColor(this.component.getCaretColor());
                int paintWidth = this.getCaretWidth((int)r.getHeight());
                r.setFrame(r.getX() - (double)(paintWidth >> 1), r.getY(), r.getWidth(), r.getHeight());
                g.fillRect((int)r.getX(), (int)r.getY(), paintWidth, (int)r.getHeight());
                Document doc = this.component.getDocument();
                if (doc instanceof AbstractDocument && (bidi = ((AbstractDocument)doc).getBidiRootElement()) != null && bidi.getElementCount() > 1) {
                    this.flagXPoints[0] = (int)r.getX() + (this.dotLTR ? paintWidth : 0);
                    this.flagYPoints[0] = (int)r.getY();
                    this.flagXPoints[1] = this.flagXPoints[0];
                    this.flagYPoints[1] = this.flagYPoints[0] + 4;
                    this.flagXPoints[2] = this.flagXPoints[0] + (this.dotLTR ? 4 : -4);
                    this.flagYPoints[2] = this.flagYPoints[0];
                    g.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void install(JTextComponent c) {
        Number ratio;
        this.component = c;
        Document doc = c.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (doc != null) {
            doc.addDocumentListener(this.handler);
        }
        c.addPropertyChangeListener(this.handler);
        c.addFocusListener(this);
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
        this.aspectRatio = (ratio = (Number)c.getClientProperty("caretAspectRatio")) != null ? ratio.floatValue() : -1.0f;
        Integer width = (Integer)c.getClientProperty("caretWidth");
        this.caretWidth = width != null ? width : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JTextComponent c) {
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
        c.removeFocusListener(this);
        c.removePropertyChangeListener(this.handler);
        Document doc = c.getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this.handler);
        }
        ActivityCaret activityCaret = this;
        synchronized (activityCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void setSelectionVisible(boolean vis) {
        if (vis != this.selectionVisible) {
            this.selectionVisible = vis;
            if (this.selectionVisible) {
                Highlighter h = this.component.getHighlighter();
                if (this.dot != this.mark && h != null && this.selectionTag == null) {
                    int p0 = Math.min(this.dot, this.mark);
                    int p1 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter p = this.getSelectionPainter();
                    try {
                        this.selectionTag = h.addHighlight(p0, p1, p);
                    }
                    catch (BadLocationException bl) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter h = this.component.getHighlighter();
                h.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    @Override
    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean e) {
        if (this.component != null) {
            this.active = e;
            TextUI mapper = this.component.getUI();
            if (this.visible != e) {
                this.visible = e;
                try {
                    Rectangle2D loc = mapper.modelToView2D(this.component, this.dot, this.dotBias);
                    this.damage(loc);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    @Override
    public void setBlinkRate(int rate) {
        if (rate != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(rate, this.handler);
            }
            this.flasher.setDelay(rate);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.handler);
            this.flasher = null;
        }
    }

    @Override
    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    @Override
    public int getDot() {
        return this.dot;
    }

    @Override
    public int getMark() {
        return this.mark;
    }

    @Override
    public void setDot(int dot) {
        this.setDot(dot, Position.Bias.Forward);
    }

    @Override
    public void moveDot(int dot) {
        this.moveDot(dot, Position.Bias.Forward);
    }

    public void moveDot(int dot, Position.Bias dotBias) {
        if (dotBias == null) {
            throw new IllegalArgumentException("null bias");
        }
        if (!this.component.isEnabled()) {
            this.setDot(dot, dotBias);
            return;
        }
        if (dot != this.dot) {
            NavigationFilter filter = this.component.getNavigationFilter();
            if (filter != null) {
                filter.moveDot(this.getFilterBypass(), dot, dotBias);
            } else {
                try {
                    this.handleMoveDot(dot, dotBias);
                }
                catch (BadLocationException e) {
                    Common.logger.log(Level.FINE, "Cannot move dot", e);
                }
            }
        }
    }

    void handleMoveDot(int dot, Position.Bias dotBias) throws BadLocationException {
        Highlighter h;
        this.changeCaretPosition(dot, dotBias);
        if (this.selectionVisible && (h = this.component.getHighlighter()) != null) {
            int p1;
            int p0 = Math.min(dot, this.mark);
            if (p0 == (p1 = Math.max(dot, this.mark))) {
                if (this.selectionTag != null) {
                    h.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        h.changeHighlight(this.selectionTag, p0, p1);
                    } else {
                        Highlighter.HighlightPainter p = this.getSelectionPainter();
                        this.selectionTag = h.addHighlight(p0, p1, p);
                    }
                }
                catch (BadLocationException e) {
                    throw new BadLocationException(e.getMessage(), e.offsetRequested());
                }
            }
        }
    }

    public void setDot(int dot, Position.Bias dotBias) {
        if (dotBias == null) {
            throw new IllegalArgumentException("null bias");
        }
        NavigationFilter filter = this.component.getNavigationFilter();
        if (filter != null) {
            filter.setDot(this.getFilterBypass(), dot, dotBias);
        } else {
            this.handleSetDot(dot, dotBias);
        }
    }

    void handleSetDot(int dot, Position.Bias dotBias) {
        Document doc = this.component.getDocument();
        if (doc != null) {
            dot = Math.min(dot, doc.getLength());
        }
        if ((dot = Math.max(dot, 0)) == 0) {
            dotBias = Position.Bias.Forward;
        }
        this.mark = dot;
        if (this.dot != dot || this.dotBias != dotBias || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(dot, dotBias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter h = this.component.getHighlighter();
        if (h != null && this.selectionTag != null) {
            h.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public Position.Bias getDotBias() {
        return this.dotBias;
    }

    public Position.Bias getMarkBias() {
        return this.markBias;
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    boolean isPositionLTR(int position, Position.Bias bias) {
        Document doc = this.component.getDocument();
        if (doc instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --position < 0) {
                position = 0;
            }
            return this.isLeftToRight((AbstractDocument)doc, position, position);
        }
        return true;
    }

    Position.Bias guessBiasForOffset(int offset, Position.Bias lastBias, boolean lastLTR) {
        if (lastLTR != this.isPositionLTR(offset, lastBias)) {
            lastBias = Position.Bias.Backward;
        } else if (lastBias != Position.Bias.Backward && lastLTR != this.isPositionLTR(offset, Position.Bias.Backward)) {
            lastBias = Position.Bias.Backward;
        }
        if (lastBias == Position.Bias.Backward && offset > 0) {
            try {
                Segment s = new Segment();
                this.component.getDocument().getText(offset - 1, 1, s);
                if (s.count > 0 && s.array[s.offset] == '\n') {
                    lastBias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return lastBias;
    }

    void changeCaretPosition(int dot, Position.Bias dotBias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = dot;
        this.dotBias = dotBias;
        this.dotLTR = this.isPositionLTR(dot, dotBias);
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable callRepaintNewCaret = new Runnable(){

            @Override
            public void run() {
                ActivityCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(callRepaintNewCaret);
    }

    void repaintNewCaret() {
        block7: {
            if (this.component != null) {
                try {
                    Rectangle2D newLoc;
                    TextUI mapper = this.component.getUI();
                    Document doc = this.component.getDocument();
                    if (mapper == null || doc == null) break block7;
                    try {
                        newLoc = mapper.modelToView2D(this.component, this.dot, this.dotBias);
                    }
                    catch (BadLocationException e) {
                        newLoc = null;
                    }
                    if (newLoc != null) {
                        this.adjustVisibility(newLoc);
                        if (this.getMagicCaretPosition() == null) {
                            this.setMagicCaretPosition(new Point((int)newLoc.getX(), (int)newLoc.getX()));
                        }
                    }
                    this.damage(newLoc);
                }
                catch (Exception e) {
                    Common.logger.log(Level.FINE, "Cannot change caret Position", e);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (this.dot != this.mark && this.component != null && (clip = this.getSystemSelection()) != null) {
            String selectedText = null;
            if (this.component instanceof JPasswordField && this.component.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                StringBuffer txt = null;
                char echoChar = ((JPasswordField)this.component).getEchoChar();
                int p0 = Math.min(this.getDot(), this.getMark());
                int p1 = Math.max(this.getDot(), this.getMark());
                for (int i = p0; i < p1; ++i) {
                    if (txt == null) {
                        txt = new StringBuffer();
                    }
                    txt.append(echoChar);
                }
                selectedText = txt != null ? txt.toString() : null;
            } else {
                selectedText = this.component.getSelectedText();
            }
            try {
                clip.setContents(new StringSelection(selectedText), this.getClipboardOwner());
                this.ownsSelection = true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private ClipboardOwner getClipboardOwner() {
        return this.handler;
    }

    private void ensureValidPosition() {
        int length = this.component.getDocument().getLength();
        if (this.dot > length || this.mark > length) {
            this.handleSetDot(length, Position.Bias.Forward);
        }
    }

    @Override
    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    @Override
    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        String s = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        s = s + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return s;
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    private boolean _contains(int X, int Y, int W, int H) {
        int w = this.width;
        int h = this.height;
        if ((w | h | W | H) < 0) {
            return false;
        }
        int x = this.x;
        int y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        if (W > 0) {
            w += x;
            if ((W += X) <= X ? w >= x || W > w : w >= x && W > w) {
                return false;
            }
        } else if (x + w < X) {
            return false;
        }
        if (H > 0) {
            h += y;
            if ((H += Y) <= Y ? h >= y || H > h : h >= y && H > h) {
                return false;
            }
        } else if (y + h < Y) {
            return false;
        }
        return true;
    }

    int getCaretWidth(int height) {
        if (this.aspectRatio > -1.0f) {
            return (int)(this.aspectRatio * (float)height) + 1;
        }
        if (this.caretWidth > -1) {
            return this.caretWidth;
        }
        return 1;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.handler = new Handler();
        this.dotBias = !s.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !s.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeBoolean(this.dotBias == Position.Bias.Backward);
        s.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        @Override
        public Caret getCaret() {
            return ActivityCaret.this;
        }

        @Override
        public void setDot(int dot, Position.Bias bias) {
            ActivityCaret.this.handleSetDot(dot, bias);
        }

        @Override
        public void moveDot(int dot, Position.Bias bias) {
            try {
                ActivityCaret.this.handleMoveDot(dot, bias);
            }
            catch (BadLocationException e) {
                Common.logger.log(Level.FINE, "Cannot move dot", e);
            }
        }
    }

    class Handler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener,
    ClipboardOwner {
        Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((ActivityCaret.this.width == 0 || ActivityCaret.this.height == 0) && ActivityCaret.this.component != null) {
                TextUI mapper = ActivityCaret.this.component.getUI();
                try {
                    Rectangle2D r = mapper.modelToView2D(ActivityCaret.this.component, ActivityCaret.this.dot, ActivityCaret.this.dotBias);
                    if (r != null && r.getWidth() != 0.0 && r.getHeight() != 0.0) {
                        ActivityCaret.this.damage(r);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ActivityCaret.this.visible = !ActivityCaret.this.visible;
            ActivityCaret.this.repaint();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int newMark;
            if (ActivityCaret.this.getUpdatePolicy() == 1 || ActivityCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                if ((e.getOffset() <= ActivityCaret.this.dot || e.getOffset() <= ActivityCaret.this.mark) && ActivityCaret.this.selectionTag != null) {
                    try {
                        ActivityCaret.this.component.getHighlighter().changeHighlight(ActivityCaret.this.selectionTag, Math.min(ActivityCaret.this.dot, ActivityCaret.this.mark), Math.max(ActivityCaret.this.dot, ActivityCaret.this.mark));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                return;
            }
            int offset = e.getOffset();
            int length = e.getLength();
            int newDot = ActivityCaret.this.dot;
            short changed = 0;
            if (newDot >= offset) {
                newDot += length;
                changed = (short)(changed | 1);
            }
            if ((newMark = ActivityCaret.this.mark) >= offset) {
                newMark += length;
                changed = (short)(changed | 2);
            }
            if (changed != 0) {
                Position.Bias dotBias = ActivityCaret.this.dotBias;
                if (ActivityCaret.this.dot == offset) {
                    boolean isNewline;
                    Document doc = ActivityCaret.this.component.getDocument();
                    try {
                        Segment s = new Segment();
                        doc.getText(newDot - 1, 1, s);
                        isNewline = s.count > 0 && s.array[s.offset] == '\n';
                    }
                    catch (BadLocationException ble) {
                        isNewline = false;
                    }
                    dotBias = isNewline ? Position.Bias.Forward : Position.Bias.Backward;
                }
                if (newMark == newDot) {
                    ActivityCaret.this.setDot(newDot, dotBias);
                    ActivityCaret.this.ensureValidPosition();
                } else {
                    ActivityCaret.this.setDot(newMark, ActivityCaret.this.markBias);
                    if (ActivityCaret.this.getDot() == newMark) {
                        ActivityCaret.this.moveDot(newDot, dotBias);
                    }
                    ActivityCaret.this.ensureValidPosition();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUpdate(DocumentEvent e) {
            if (ActivityCaret.this.getUpdatePolicy() == 1 || ActivityCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                int length = ActivityCaret.this.component.getDocument().getLength();
                ActivityCaret.this.dot = Math.min(ActivityCaret.this.dot, length);
                ActivityCaret.this.mark = Math.min(ActivityCaret.this.mark, length);
                if ((e.getOffset() < ActivityCaret.this.dot || e.getOffset() < ActivityCaret.this.mark) && ActivityCaret.this.selectionTag != null) {
                    try {
                        ActivityCaret.this.component.getHighlighter().changeHighlight(ActivityCaret.this.selectionTag, Math.min(ActivityCaret.this.dot, ActivityCaret.this.mark), Math.max(ActivityCaret.this.dot, ActivityCaret.this.mark));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                return;
            }
            int offs0 = e.getOffset();
            int offs1 = offs0 + e.getLength();
            int newDot = ActivityCaret.this.dot;
            boolean adjustDotBias = false;
            int newMark = ActivityCaret.this.mark;
            boolean adjustMarkBias = false;
            if (newDot >= offs1) {
                if ((newDot -= offs1 - offs0) == offs1) {
                    adjustDotBias = true;
                }
            } else if (newDot >= offs0) {
                newDot = offs0;
                adjustDotBias = true;
            }
            if (newMark >= offs1) {
                if ((newMark -= offs1 - offs0) == offs1) {
                    adjustMarkBias = true;
                }
            } else if (newMark >= offs0) {
                newMark = offs0;
                adjustMarkBias = true;
            }
            if (newMark == newDot) {
                ActivityCaret.this.forceCaretPositionChange = true;
                try {
                    ActivityCaret.this.setDot(newDot, ActivityCaret.this.guessBiasForOffset(newDot, ActivityCaret.this.dotBias, ActivityCaret.this.dotLTR));
                }
                finally {
                    ActivityCaret.this.forceCaretPositionChange = false;
                }
                ActivityCaret.this.ensureValidPosition();
            } else {
                Position.Bias dotBias = ActivityCaret.this.dotBias;
                Position.Bias markBias = ActivityCaret.this.markBias;
                if (adjustDotBias) {
                    dotBias = ActivityCaret.this.guessBiasForOffset(newDot, dotBias, ActivityCaret.this.dotLTR);
                }
                if (adjustMarkBias) {
                    markBias = ActivityCaret.this.guessBiasForOffset(ActivityCaret.this.mark, markBias, ActivityCaret.this.markLTR);
                }
                ActivityCaret.this.setDot(newMark, markBias);
                if (ActivityCaret.this.getDot() == newMark) {
                    ActivityCaret.this.moveDot(newDot, dotBias);
                }
                ActivityCaret.this.ensureValidPosition();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (ActivityCaret.this.getUpdatePolicy() == 1 || ActivityCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                return;
            }
            ActivityCaret.this.setDot(e.getOffset() + e.getLength());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (oldValue instanceof Document || newValue instanceof Document) {
                ActivityCaret.this.setDot(0);
                if (oldValue != null) {
                    ((Document)oldValue).removeDocumentListener(this);
                }
                if (newValue != null) {
                    ((Document)newValue).addDocumentListener(this);
                }
            } else if ("enabled".equals(evt.getPropertyName())) {
                Boolean enabled = (Boolean)evt.getNewValue();
                if (ActivityCaret.this.component.isFocusOwner()) {
                    if (enabled == Boolean.TRUE) {
                        if (ActivityCaret.this.component.isEditable()) {
                            ActivityCaret.this.setVisible(true);
                        }
                        ActivityCaret.this.setSelectionVisible(true);
                    } else {
                        ActivityCaret.this.setVisible(false);
                        ActivityCaret.this.setSelectionVisible(false);
                    }
                }
            } else if ("caretWidth".equals(evt.getPropertyName())) {
                Integer newWidth = (Integer)evt.getNewValue();
                ActivityCaret.this.caretWidth = newWidth != null ? newWidth : -1;
                ActivityCaret.this.repaint();
            } else if ("caretAspectRatio".equals(evt.getPropertyName())) {
                Number newRatio = (Number)evt.getNewValue();
                ActivityCaret.this.aspectRatio = newRatio != null ? newRatio.floatValue() : -1.0f;
                ActivityCaret.this.repaint();
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            if (ActivityCaret.this.ownsSelection) {
                ActivityCaret.this.ownsSelection = false;
                if (ActivityCaret.this.component != null && !ActivityCaret.this.component.hasFocus()) {
                    ActivityCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle r) {
            this.r = r;
        }

        @Override
        public void run() {
            if (ActivityCaret.this.component != null) {
                ActivityCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

