/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.swing.thumbnail;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jorigin.swing.thumbnail.JThumbnail;
import org.jorigin.swing.thumbnail.JThumbnailPanelListener;
import org.jorigin.task.TaskEvent;
import org.jorigin.task.TaskListener;

public class JThumbnailPanel<T>
extends JPanel {
    private static final long serialVersionUID = 202111241200L;
    protected int labelWidth = 0;
    protected int labelHeight = 0;
    protected double thumbRatio = 0.0;
    protected int labelMargin = 5;
    protected int labelCount = 0;
    protected ArrayList<JThumbnail<T>> labels = null;
    protected List<JThumbnail<T>> selectedLabels;
    protected int lastSelectedIndex = -1;
    protected JThumbnail<T> activatedLabel;
    protected volatile boolean isLabelLoading = false;
    protected EventListenerList idListenerList = new EventListenerList();
    private int selectionMode = 0;
    protected Color normalColor = Color.LIGHT_GRAY;
    protected Color focusColor = Color.GREEN;
    protected Color selectedColor = Color.RED;
    protected Color itemPResentColor = Color.YELLOW;
    protected String state = "";
    private int labelPerLine = 1;

    public JThumbnailPanel() {
        this(1);
    }

    public JThumbnailPanel(int labelPerLine) {
        this.selectedLabels = new ArrayList<JThumbnail<T>>();
        this.labels = new ArrayList();
        this.labelPerLine = labelPerLine;
        this.setBackground(Color.WHITE);
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
    }

    public Rectangle getCellBounds(int index0, int index1) {
        Rectangle rectangle = null;
        JThumbnail<T> l0 = null;
        JThumbnail<T> l1 = null;
        if (index0 > index1 || index0 < 0 || index1 > this.labels.size()) {
            return null;
        }
        l0 = this.labels.get(index0);
        l1 = this.labels.get(index1);
        if (l0 == null || l1 == null) {
            return null;
        }
        rectangle = new Rectangle((int)l0.getBounds().getX(), (int)l0.getBounds().getY(), (int)(l1.getBounds().getX() + l1.getBounds().getWidth()), (int)(l1.getBounds().getY() + l1.getBounds().getHeight()));
        return rectangle;
    }

    public void setSelectedIndices(int[] indices) {
        this.unselectAll();
        if (indices != null && this.labels != null) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] < 0 || indices[i] >= this.labels.size()) continue;
                this.select(this.labels.get(indices[i]));
            }
        }
    }

    public int[] getSelectedIndices() {
        int[] indices = null;
        Iterator<JThumbnail<T>> iter = null;
        int index = 0;
        int i = 0;
        if (this.selectedLabels.size() > 0) {
            indices = new int[this.selectedLabels.size()];
            iter = this.selectedLabels.iterator();
            while (iter.hasNext()) {
                indices[i] = index = this.labels.indexOf(iter.next());
                ++i;
            }
            Arrays.sort(indices);
        } else {
            indices = new int[]{};
        }
        return indices;
    }

    public int getSelectedIndex() {
        if (this.selectedLabels.size() > 0) {
            return this.labels.indexOf(this.selectedLabels.get(0));
        }
        return -1;
    }

    public void setSelectedIndex(int index) {
        if (index > 0 && index < this.labels.size()) {
            this.unselectAll();
            this.select(this.labels.get(index));
        }
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        JThumbnail<T> label = null;
        Iterator<JThumbnail<T>> iter = null;
        boolean found = false;
        iter = this.labels.iterator();
        while (iter.hasNext() && !found) {
            label = iter.next();
            if (label != anObject) continue;
            found = true;
        }
        if (label != null) {
            this.unselectAll();
            this.select(label);
            if (shouldScroll) {
                this.scrollToSelected();
            }
        }
    }

    public void setSelectedThumbnail(JThumbnail<T> label, boolean shouldScroll) {
        if (this.labels.contains(label)) {
            this.unselectAll();
            this.select(label);
            if (shouldScroll) {
                this.scrollToSelected();
            }
        }
    }

    public JThumbnail<T> getSelectedThumbnail() {
        if (this.selectedLabels.size() > 0) {
            return this.selectedLabels.get(0);
        }
        return null;
    }

    public List<JThumbnail<T>> getSelectedThumbnails() {
        ArrayList<JThumbnail<T>> thumbnails = new ArrayList<JThumbnail<T>>(this.selectedLabels);
        Collections.sort(thumbnails, new Comparator<JThumbnail<T>>(){

            @Override
            public int compare(JThumbnail<T> o1, JThumbnail<T> o2) {
                int i2;
                int i1 = JThumbnailPanel.this.labels.indexOf(o1);
                if (i1 < (i2 = JThumbnailPanel.this.labels.indexOf(o2))) {
                    return 1;
                }
                if (i2 > i1) {
                    return -1;
                }
                return 0;
            }
        });
        return thumbnails;
    }

    public Object[] getSelectedValues() {
        JThumbnail[] labelsArray = this.selectedLabels.toArray(new JThumbnail[this.selectedLabels.size()]);
        Object[] values = null;
        Arrays.sort(labelsArray, new Comparator<JThumbnail<T>>(){

            @Override
            public int compare(JThumbnail<T> o1, JThumbnail<T> o2) {
                int i2;
                int i1 = JThumbnailPanel.this.labels.indexOf(o1);
                if (i1 < (i2 = JThumbnailPanel.this.labels.indexOf(o2))) {
                    return 1;
                }
                if (i2 > i1) {
                    return -1;
                }
                return 0;
            }
        });
        values = new Object[labelsArray.length];
        for (int i = 0; i < labelsArray.length; ++i) {
            values[i] = labelsArray[i].getContent();
        }
        return values;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode == 0 || selectionMode == 1 || selectionMode == 2) {
            this.selectionMode = selectionMode;
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public int indexOf(Object o) {
        int index = -1;
        int i = 0;
        Iterator<JThumbnail<T>> iter = this.labels.iterator();
        Object content = null;
        while (iter.hasNext() && index == -1) {
            content = iter.next().getContent();
            if (content.equals(o)) {
                index = i;
                continue;
            }
            ++i;
        }
        return index;
    }

    public int indexOf(JThumbnail<T> label) {
        int index = -1;
        int i = 0;
        Iterator<JThumbnail<T>> iter = this.labels.iterator();
        JThumbnail<T> content = null;
        while (iter.hasNext() && index == -1) {
            content = iter.next();
            if (content.equals(label)) {
                index = i;
                continue;
            }
            ++i;
        }
        return index;
    }

    public boolean contains(Object o) {
        boolean contain = false;
        Iterator<JThumbnail<T>> iter = this.labels.iterator();
        while (iter.hasNext() && !contain) {
            contain = iter.next().getContent().equals(o);
        }
        return contain;
    }

    public boolean contains(JThumbnail<T> label) {
        boolean contain = false;
        Iterator<JThumbnail<T>> iter = this.labels.iterator();
        while (iter.hasNext() && !contain) {
            contain = iter.next().equals(label);
        }
        return contain;
    }

    public JThumbnail<T> getActivatedLabel() {
        return this.activatedLabel;
    }

    public void setThumbRatio(double thumbRatio) {
        this.thumbRatio = thumbRatio;
    }

    public double getThumbRatio() {
        return this.thumbRatio;
    }

    public void setLabelWidth(int width) {
        this.labelWidth = width;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelHeight(int height) {
        this.labelHeight = height;
    }

    public int getLabelHeight() {
        return this.labelHeight;
    }

    public void setLabelMargin(int margin) {
        this.labelMargin = margin;
    }

    public int getLabelMargin() {
        return this.labelMargin;
    }

    public void setLabelCount(int count) {
        this.labelCount = count;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public String getState() {
        return this.state;
    }

    public void setLoading(boolean b) {
        this.isLabelLoading = b;
    }

    public boolean isLoading() {
        return this.isLabelLoading;
    }

    public void scrollToSelected() {
        this.scrollToSelectedIndices();
    }

    public void refresh() {
        for (int i = 0; i < this.getComponents().length; ++i) {
            if (!(this.getComponent(i) instanceof JThumbnail)) continue;
            this.getComponent(i).validate();
            this.getComponent(i).setVisible(true);
            if (!(this.getComponent(i) instanceof JThumbnail)) continue;
            ((JThumbnail)this.getComponent(i)).refresh();
        }
        this.repaint();
    }

    public boolean add(JThumbnail<T> label) {
        GridBagConstraints c = null;
        Insets insets = new Insets(2, 2, 2, 2);
        if (this.labels.add(label)) {
            if (this.getLayout() instanceof GridBagLayout) {
                if (this.labels.size() % this.labelPerLine == 0) {
                    c = new GridBagConstraints();
                    c.gridx = -1;
                    c.gridy = -1;
                    c.gridheight = 1;
                    c.gridwidth = 0;
                    c.fill = 0;
                    c.insets = insets;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    c.anchor = 17;
                    this.add(label, c);
                } else {
                    c = new GridBagConstraints();
                    c.gridx = -1;
                    c.gridy = -1;
                    c.gridheight = 1;
                    c.gridwidth = 1;
                    c.fill = 0;
                    c.insets = insets;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    c.anchor = 17;
                    this.add(label, c);
                }
            } else {
                super.add(label);
            }
        } else {
            return false;
        }
        label.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JThumbnailPanel.this.processActiveLabelMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JThumbnailPanel.this.processActiveLabelMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JThumbnailPanel.this.processActiveLabelMouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JThumbnailPanel.this.processActiveLabelMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JThumbnailPanel.this.processActiveLabelMouseEvent(e);
            }
        });
        this.validate();
        label.setVisible(true);
        this.repaint();
        this.setLabelCount(this.getLabelCount() + 1);
        this.fireThumbnailAdded(this, label);
        return true;
    }

    public boolean remove(JThumbnail<T> label) {
        if (!this.labels.remove(label)) {
            return false;
        }
        super.remove(label);
        this.setLabelCount(this.getLabelCount() - 1);
        this.validate();
        this.fireThumbnailRemoved(this, label);
        return true;
    }

    public void select(JThumbnail<T> l) {
        this.selectedLabels.add(l);
        l.setSelected(true);
        this.refresh();
    }

    public void unselect(JThumbnail<T> l) {
        this.selectedLabels.remove(l);
        l.setSelected(false);
        this.refresh();
    }

    public void unselectAll() {
        for (JThumbnail<T> lr : this.selectedLabels) {
            lr.setSelected(false);
            lr.refresh();
        }
        this.selectedLabels.clear();
    }

    public void scrollToSelectedIndices() {
        int[] indices = this.getSelectedIndices();
        if (indices != null && indices.length > 0) {
            Rectangle rect = this.getCellBounds(indices[0], indices[indices.length - 1]);
            this.scrollRectToVisible(rect);
        }
    }

    public void scrollToIndices(int[] indices) {
        if (indices != null && indices.length > 0 && indices.length <= this.labels.size()) {
            Rectangle rect = this.getCellBounds(indices[0], indices[indices.length - 1]);
            this.scrollRectToVisible(rect);
        }
    }

    public JThumbnail<T> getLabelContaining(Object content) {
        Iterator<JThumbnail<T>> iter = null;
        JThumbnail<T> label = null;
        boolean found = false;
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        iter = this.labels.iterator();
        while (iter.hasNext() && !found) {
            label = iter.next();
            if (label.getContent() == null) {
                if (content != null) continue;
                found = true;
                continue;
            }
            found = label.getContent().equals(content);
        }
        if (found) {
            return label;
        }
        return null;
    }

    protected void fireThumbnailAdded(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailAdded(panel, thumbnail);
        }
    }

    protected void fireThumbnailRemoved(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailRemoved(panel, thumbnail);
        }
    }

    protected void fireThumbnailSelected(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailSelected(panel, thumbnail);
        }
    }

    protected void fireThumbnailSelected(JThumbnailPanel<T> panel, List<JThumbnail<T>> thumbnails) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailSelected(panel, thumbnails);
        }
    }

    protected void fireThumbnailActivated(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailActivated(panel, thumbnail);
        }
    }

    protected void fireThumbnailEntered(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailEntered(panel, thumbnail);
        }
    }

    protected void fireThumbnailExited(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailExited(panel, thumbnail);
        }
    }

    protected void fireThumbnailNeedRefresh(JThumbnailPanel<T> panel, JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailPanelListener.class) continue;
            ((JThumbnailPanelListener)listeners[i + 1]).thumbnailNeedRefresh(panel, thumbnail);
        }
    }

    protected void fireEvent(TaskEvent e) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TaskListener.class) continue;
            ((TaskListener)listeners[i + 1]).eventDispatched(e);
        }
    }

    public void addThumbnailPanelListener(JThumbnailPanelListener<T> l) {
        this.idListenerList.add(JThumbnailPanelListener.class, l);
    }

    public void removeThumbnailPanelListener(JThumbnailPanelListener<T> l) {
        this.idListenerList.remove(JThumbnailPanelListener.class, l);
    }

    public void addTaskListener(TaskListener l) {
        this.idListenerList.add(TaskListener.class, l);
    }

    public void removeTaskListener(TaskListener l) {
        this.idListenerList.remove(TaskListener.class, l);
    }

    protected void processActiveLabelMouseEvent(MouseEvent e) {
        int clickCount = 0;
        boolean shiftActivated = false;
        boolean ctrlActivated = false;
        clickCount = e.getClickCount();
        shiftActivated = e.isShiftDown();
        ctrlActivated = e.isControlDown();
        JThumbnail source = (JThumbnail)e.getSource();
        int labelIndex = -1;
        int start = -1;
        int end = -1;
        labelIndex = this.labels.indexOf(source);
        switch (e.getID()) {
            case 500: {
                if (clickCount == 1) {
                    switch (this.selectionMode) {
                        case 0: {
                            if (!shiftActivated) {
                                if (ctrlActivated) {
                                    if (labelIndex == this.lastSelectedIndex) {
                                        this.unselect(source);
                                    } else {
                                        this.unselectAll();
                                        this.select(source);
                                    }
                                } else {
                                    this.unselectAll();
                                    this.select(source);
                                }
                            }
                            this.lastSelectedIndex = labelIndex;
                            this.fireThumbnailSelected(this, source);
                            break;
                        }
                        case 1: {
                            labelIndex = this.labels.indexOf(source);
                            if (this.lastSelectedIndex < 0) {
                                this.lastSelectedIndex = 0;
                            }
                            start = -1;
                            end = -1;
                            if (labelIndex > this.lastSelectedIndex) {
                                start = this.lastSelectedIndex;
                                end = labelIndex;
                            } else {
                                start = labelIndex;
                                end = this.lastSelectedIndex;
                            }
                            this.unselectAll();
                            for (int i = start; i <= end; ++i) {
                                this.select(this.labels.get(i));
                            }
                            this.lastSelectedIndex = labelIndex;
                            this.fireThumbnailSelected(this, this.selectedLabels);
                            break;
                        }
                        case 2: {
                            if (!shiftActivated && !ctrlActivated) {
                                this.unselectAll();
                                this.select(source);
                            } else if (!shiftActivated && ctrlActivated) {
                                if (labelIndex == this.lastSelectedIndex) {
                                    this.unselect(source);
                                } else {
                                    this.select(source);
                                }
                            } else if (shiftActivated && !ctrlActivated) {
                                if (this.lastSelectedIndex < 0) {
                                    this.lastSelectedIndex = 0;
                                }
                                start = -1;
                                end = -1;
                                if (labelIndex > this.lastSelectedIndex) {
                                    start = this.lastSelectedIndex;
                                    end = labelIndex;
                                } else {
                                    start = labelIndex;
                                    end = this.lastSelectedIndex;
                                }
                                this.unselectAll();
                                for (int i = start; i <= end; ++i) {
                                    this.select(this.labels.get(i));
                                }
                            } else if (shiftActivated && ctrlActivated) {
                                if (this.lastSelectedIndex < 0) {
                                    this.lastSelectedIndex = 0;
                                }
                                start = -1;
                                end = -1;
                                if (labelIndex > this.lastSelectedIndex) {
                                    start = this.lastSelectedIndex;
                                    end = labelIndex;
                                } else {
                                    start = labelIndex;
                                    end = this.lastSelectedIndex;
                                }
                                for (int i = start; i <= end; ++i) {
                                    if (this.selectedLabels.contains(source)) continue;
                                    this.select(this.labels.get(i));
                                }
                            }
                            this.lastSelectedIndex = labelIndex;
                            this.fireThumbnailSelected(this, this.selectedLabels);
                        }
                    }
                    if (!shiftActivated) break;
                    break;
                }
                if (e.getClickCount() <= 1) break;
                this.activatedLabel = source;
                this.fireThumbnailActivated(this, source);
            }
        }
    }
}

