/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import org.jorigin.Common;
import org.jorigin.lang.PathUtil;

public class IconLoader {
    private static String resourcesPath = "";

    public static ImageIcon getIcon(String path) {
        ImageIcon i = null;
        if (!PathUtil.isAbsolutePath(path)) {
            try {
                i = new ImageIcon(PathUtil.URIToPath(resourcesPath + "/" + path));
                if (i.getIconWidth() < 1) {
                    i = null;
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + resourcesPath + "/" + path + " cannot be loaded: " + ex.getMessage(), ex);
                i = null;
            }
            if (i == null) {
                try {
                    i = new ImageIcon(IconLoader.class.getResource(path));
                    if (i.getIconWidth() < 1) {
                        i = null;
                    }
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Icon " + path + " cannot be loaded: " + e.getMessage(), e);
                    i = null;
                }
            }
        } else {
            try {
                i = new ImageIcon(PathUtil.URIToPath(path));
                if (i.getIconWidth() < 1) {
                    i = null;
                }
            }
            catch (Exception ex) {
                Common.logger.log(Level.WARNING, "Icon " + path + " cannot be loaded: " + ex.getMessage(), ex);
                i = null;
            }
        }
        return i;
    }

    public static Image getImage(String path) {
        ImageIcon i = IconLoader.getIcon(path);
        if (i != null) {
            return i.getImage();
        }
        return null;
    }

    public static ImageIcon getScaledIcon(String name, Dimension dimension) {
        ImageIcon icon = IconLoader.getIcon(name);
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        if (icon != null) {
            icon.setImage(icon.getImage().getScaledInstance((int)(dimension.getWidth() * (double)dpi / 25.4), (int)(dimension.getHeight() * (double)dpi / 25.4), 4));
        }
        return icon;
    }

    public static String getIconPath() {
        return resourcesPath;
    }

    public static void setIconPath(String path) {
        resourcesPath = path;
    }
}

