/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jorigin.lang.LangResourceBundle;

public class JDatePanel
extends JPanel {
    private static final long serialVersionUID = 201812141330L;
    private LangResourceBundle langResource = (LangResourceBundle)LangResourceBundle.getBundle(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
    private static int MAX_YEAR = 9999;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    private GregorianCalendar calendar = null;
    protected EventListenerList idListenerList = new EventListenerList();
    private JLabel dayLB = null;
    private JSpinner dayTF = null;
    private SpinnerModel dayTFModel = null;
    private JLabel monthLB = null;
    private JComboBox<String> monthCB = null;
    private JLabel yearLB = null;
    private JSpinner yearTF = null;
    private SpinnerModel yearTFModel = null;
    private JSpinner hourMinuteTF = null;
    private boolean showLabel = false;
    private boolean listening = true;

    public JDatePanel() {
        this(new Date());
    }

    public JDatePanel(Date date) {
        this.calendar = new GregorianCalendar();
        this.initGUI();
        this.setDate(date);
    }

    protected void initGUI() {
        this.dayLB = new JLabel(this.langResource.getString("DATE_DAY"));
        this.dayTFModel = new SpinnerNumberModel(this.calendar.get(5), 1, this.getMaxDay(this.calendar.get(2), this.calendar.get(1)), 1);
        this.dayTF = new JSpinner(this.dayTFModel);
        this.dayTF.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JDatePanel.this.listening) {
                    int day = Integer.parseInt("" + JDatePanel.this.dayTF.getValue());
                    JDatePanel.this.setDay(day);
                    JDatePanel.this.fireChangeEvent();
                }
            }
        });
        this.monthLB = new JLabel(this.langResource.getString("DATE_MONTH"));
        this.monthCB = new JComboBox<String>(new String[]{this.langResource.getString("DATE_JANUARY"), this.langResource.getString("DATE_FEBRUARY"), this.langResource.getString("DATE_MARCH"), this.langResource.getString("DATE_APRIL"), this.langResource.getString("DATE_MAY"), this.langResource.getString("DATE_JUNE"), this.langResource.getString("DATE_JULY"), this.langResource.getString("DATE_AUGUST"), this.langResource.getString("DATE_SEPTEMBER"), this.langResource.getString("DATE_OCTOBER"), this.langResource.getString("DATE_NOVEMBER"), this.langResource.getString("DATE_DECEMBER")});
        this.monthCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (JDatePanel.this.listening) {
                    int month = JDatePanel.this.monthCB.getSelectedIndex();
                    JDatePanel.this.setMonth(month);
                    JDatePanel.this.fireChangeEvent();
                }
            }
        });
        this.yearLB = new JLabel(this.langResource.getString("DATE_YEAR"));
        this.yearTFModel = new SpinnerNumberModel(this.calendar.get(1), 1, MAX_YEAR, 1);
        this.yearTF = new JSpinner(this.yearTFModel);
        this.yearTF.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JDatePanel.this.listening) {
                    int year = Integer.parseInt("" + JDatePanel.this.yearTF.getValue());
                    JDatePanel.this.setYear(year);
                    JDatePanel.this.fireChangeEvent();
                }
            }
        });
        GregorianCalendar firstDate = new GregorianCalendar();
        firstDate.setTime(new Date());
        firstDate.set(10, 0);
        firstDate.set(12, 0);
        GregorianCalendar lastDate = new GregorianCalendar();
        lastDate.setTime(new Date());
        lastDate.set(10, 23);
        lastDate.set(12, 59);
        final SpinnerDateModel model = new SpinnerDateModel(this.calendar.getTime(), firstDate.getTime(), lastDate.getTime(), 12);
        this.hourMinuteTF = new JSpinner(model);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.hourMinuteTF, "hh:mm");
        this.hourMinuteTF.setEditor(editor);
        this.hourMinuteTF.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JDatePanel.this.listening) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(model.getDate());
                    int hour = cal.get(11);
                    int minute = cal.get(12);
                    JDatePanel.this.setHour(hour);
                    JDatePanel.this.setMinute(minute);
                    cal = null;
                    JDatePanel.this.fireChangeEvent();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = null;
        Insets labelInsets = new Insets(0, 8, 0, 0);
        Insets fieldInsets = new Insets(0, 5, 0, 0);
        Insets currentInsets = null;
        if (this.showLabel) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.fill = 0;
            c.insets = labelInsets;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.dayLB, c);
            currentInsets = fieldInsets;
        } else {
            currentInsets = new Insets(0, 0, 0, 0);
        }
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = currentInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.dayTF, c);
        if (this.showLabel) {
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.fill = 0;
            c.insets = labelInsets;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.monthLB, c);
        }
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add(this.monthCB, c);
        if (this.showLabel) {
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.fill = 0;
            c.insets = labelInsets;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.yearLB, c);
        }
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.yearTF, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.hourMinuteTF, c);
        c = null;
        labelInsets = new Insets(0, 8, 0, 0);
        fieldInsets = new Insets(0, 5, 0, 0);
        currentInsets = null;
    }

    protected void updateGUI() {
        this.listening = false;
        this.dayTF.setValue(this.calendar.get(5));
        this.monthCB.setSelectedIndex(this.calendar.get(2));
        this.monthCB.setSelectedItem(this.monthCB.getSelectedItem());
        this.yearTF.setValue(this.calendar.get(1));
        this.hourMinuteTF.setValue(this.calendar.getTime());
        this.listening = true;
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void setDate(Date newDate) {
        if (newDate != null) {
            this.listening = false;
            this.calendar.setTime(newDate);
            this.updateGUI();
            this.listening = true;
        }
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            return;
        }
        this.calendar.set(12, minute);
        this.updateGUI();
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            return;
        }
        this.calendar.set(11, hour);
        this.updateGUI();
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            return;
        }
        this.calendar.set(2, month);
        int maxDay = this.getMaxDay(month, this.calendar.get(1));
        if (this.calendar.get(5) > maxDay) {
            this.calendar.set(5, maxDay);
        }
        this.updateGUI();
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public void setDay(int day) {
        int maxDay = this.getMaxDay(this.calendar.get(2), this.calendar.get(1));
        if (day >= 1 && day <= maxDay) {
            this.calendar.set(5, day);
            this.updateGUI();
        }
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public void setYear(int year) {
        if (year > 0) {
            this.calendar.set(1, year);
            int maxDay = this.getMaxDay(this.calendar.get(2), year);
            if (this.calendar.get(5) > maxDay) {
                this.calendar.set(5, maxDay);
            }
            this.updateGUI();
        }
    }

    private int getMaxDay(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                if (this.isBisextile(year)) {
                    return 29;
                }
                return 28;
            }
        }
        return -1;
    }

    public boolean isBisextile(int year) {
        if (year % 400 == 0) {
            return true;
        }
        return year % 4 == 0 && year % 100 != 100;
    }

    public void addChangeListener(ChangeListener l) {
        this.idListenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.idListenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

