/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class JPanelFrame
extends JPanel
implements RootPaneContainer {
    private static final long serialVersionUID = 201812141330L;
    private JLabel titleLabel = null;
    private GradientPanel gradientPanel = null;
    private JPanel headerPanel = null;
    private boolean selected = false;
    private JRootPane rootPane = null;
    private boolean rootPaneCheckingEnabled = true;
    private Image iconImage = null;

    public JPanelFrame(String title) {
        this(null, title, null, null);
    }

    public JPanelFrame(Icon icon, String title) {
        this(icon, title, null, null);
    }

    public JPanelFrame(String title, JToolBar bar, JComponent content) {
        this(null, title, bar, content);
    }

    public JPanelFrame(Icon icon, String title, JToolBar bar, JComponent content) {
        super(new BorderLayout());
        this.createRootPane();
        this.selected = false;
        this.titleLabel = new JLabel(title, icon, 10);
        JPanel top = this.buildHeader(this.titleLabel, bar);
        super.addImpl(top, "North", -1);
        super.addImpl(this.rootPane, "Center", -1);
        if (content != null) {
            this.getContentPane().add(content);
        }
        this.setBorder(new ShadowBorder());
        this.setSelected(true);
        this.updateHeader();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public void setContentPane(Container contentPane) {
    }

    @Override
    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    @Override
    public void setLayeredPane(JLayeredPane layeredPane) {
        this.getRootPane().setLayeredPane(layeredPane);
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    @Override
    public void setGlassPane(Component glassPane) {
        this.getRootPane().setGlassPane(glassPane);
    }

    @Override
    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    @Override
    public Component add(Component comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        this.addImpl(comp, null, index);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    protected void createRootPane() {
        this.rootPane = new JRootPane();
        this.rootPane.getContentPane().setLayout(new BorderLayout());
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.rootPaneCheckingEnabled) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.add(comp, constraints, index);
        }
    }

    public void setJMenuBar(JMenuBar menu) {
        this.getRootPane().setJMenuBar(menu);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void processWindowEvent(WindowEvent e) {
    }

    @Override
    public void remove(Component comp) {
        if (comp != this.rootPane) {
            this.getContentPane().remove(comp);
        }
    }

    public void setDefaultCloseOperation(int operation) {
    }

    public int getDefaultCloseOperation() {
        return 0;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void setIconImage(Image image) {
        this.iconImage = image;
    }

    public Image getIconImage() {
        return this.iconImage;
    }

    public Icon getFrameIcon() {
        return this.titleLabel.getIcon();
    }

    public void setFrameIcon(Icon newIcon) {
        Icon oldIcon = this.getFrameIcon();
        this.titleLabel.setIcon(newIcon);
        this.firePropertyChange("frameIcon", oldIcon, newIcon);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String newText) {
        String oldText = this.getTitle();
        this.titleLabel.setText(newText);
        this.firePropertyChange("title", oldText, newText);
    }

    public JToolBar getToolBar() {
        return this.headerPanel.getComponentCount() > 1 ? (JToolBar)this.headerPanel.getComponent(1) : null;
    }

    public void setToolBar(JToolBar newToolBar) {
        JToolBar oldToolBar = this.getToolBar();
        if (oldToolBar == newToolBar) {
            return;
        }
        if (oldToolBar != null) {
            this.headerPanel.remove(oldToolBar);
        }
        if (newToolBar != null) {
            newToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.add((Component)newToolBar, "East");
        }
        this.updateHeader();
        this.firePropertyChange("toolBar", oldToolBar, newToolBar);
    }

    public Component getContent() {
        return this.getContentPane();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newValue) {
        boolean oldValue = this.isSelected();
        this.selected = newValue;
        this.updateHeader();
        this.firePropertyChange("selected", oldValue, newValue);
    }

    private JPanel buildHeader(JLabel label, JToolBar bar) {
        this.gradientPanel = new GradientPanel(new BorderLayout(), this.getHeaderBackground());
        label.setOpaque(false);
        this.gradientPanel.add((Component)label, "West");
        this.gradientPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.add((Component)this.gradientPanel, "Center");
        this.setToolBar(bar);
        this.headerPanel.setBorder(new RaisedHeaderBorder());
        this.headerPanel.setOpaque(false);
        return this.headerPanel;
    }

    private void updateHeader() {
        this.gradientPanel.setBackground(this.getHeaderBackground());
        this.gradientPanel.setOpaque(this.isSelected());
        this.titleLabel.setForeground(this.getTextForeground(this.isSelected()));
        this.headerPanel.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.titleLabel != null) {
            this.updateHeader();
        }
    }

    protected Color getTextForeground(boolean isSelected) {
        Color c = null;
        c = isSelected ? UIManager.getColor("SimpleInternalFrame.activeTitleForeground") : UIManager.getColor("SimpleInternalFrame.inactiveTitleForeground");
        if (c != null) {
            return c;
        }
        if (isSelected) {
            return UIManager.getColor("InternalFrame.activeTitleForeground");
        }
        return UIManager.getColor("Label.foreground");
    }

    protected Color getHeaderBackground() {
        Color c = UIManager.getColor("SimpleInternalFrame.activeTitleBackground");
        if (c != null) {
            return c;
        }
        return UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    private static class GradientPanel
    extends JPanel {
        private static final long serialVersionUID = 201812141330L;

        private GradientPanel(LayoutManager lm, Color background) {
            super(lm);
            this.setBackground(background);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.isOpaque()) {
                return;
            }
            Color control = UIManager.getColor("control");
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            Paint storedPaint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), width, 0.0f, control));
            g2.fillRect(0, 0, width, height);
            g2.setPaint(storedPaint);
        }
    }

    private static class ShadowBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 201812141330L;
        private static final Insets INSETS = new Insets(1, 1, 3, 3);

        private ShadowBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow = UIManager.getColor("controlShadow");
            if (shadow == null) {
                shadow = Color.GRAY;
            }
            Color lightShadow = new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 170);
            Color lighterShadow = new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 70);
            g.translate(x, y);
            g.setColor(shadow);
            g.fillRect(0, 0, w - 3, 1);
            g.fillRect(0, 0, 1, h - 3);
            g.fillRect(w - 3, 1, 1, h - 3);
            g.fillRect(1, h - 3, w - 3, 1);
            g.setColor(lightShadow);
            g.fillRect(w - 3, 0, 1, 1);
            g.fillRect(0, h - 3, 1, 1);
            g.fillRect(w - 2, 1, 1, h - 3);
            g.fillRect(1, h - 2, w - 3, 1);
            g.setColor(lighterShadow);
            g.fillRect(w - 2, 0, 1, 1);
            g.fillRect(0, h - 2, 1, 1);
            g.fillRect(w - 2, h - 2, 1, 1);
            g.fillRect(w - 1, 1, 1, h - 2);
            g.fillRect(1, h - 1, w - 2, 1);
            g.translate(-x, -y);
        }
    }

    private static class RaisedHeaderBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 201812141330L;
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        private RaisedHeaderBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(UIManager.getColor("controlLtHighlight"));
            g.fillRect(0, 0, w, 1);
            g.fillRect(0, 1, 1, h - 1);
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(0, h - 1, w, 1);
            g.translate(-x, -y);
        }
    }
}

