/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jorigin.lang.LangResourceBundle;

public class JRenderingHintsPanel
extends JPanel {
    private static final long serialVersionUID = 201812141330L;
    private LangResourceBundle lr = (LangResourceBundle)LangResourceBundle.getBundle(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
    private boolean showBorder = false;
    private RenderingHints hints = null;
    private Object[] alphaInterpolationValues = new Object[]{RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY};
    private Object[] antiAliasingValues = new Object[]{RenderingHints.VALUE_ANTIALIAS_DEFAULT, RenderingHints.VALUE_ANTIALIAS_OFF, RenderingHints.VALUE_ANTIALIAS_ON};
    private Object[] colorRenderingValues = new Object[]{RenderingHints.VALUE_COLOR_RENDER_DEFAULT, RenderingHints.VALUE_COLOR_RENDER_SPEED, RenderingHints.VALUE_COLOR_RENDER_QUALITY};
    private Object[] ditheringValues = new Object[]{RenderingHints.VALUE_DITHER_DEFAULT, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.VALUE_DITHER_ENABLE};
    private Object[] fractionalMetricsValues = new Object[]{RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_ON};
    private Object[] interpolationValues = new Object[]{RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.VALUE_INTERPOLATION_BICUBIC};
    private Object[] renderingValues = new Object[]{RenderingHints.VALUE_RENDER_DEFAULT, RenderingHints.VALUE_RENDER_SPEED, RenderingHints.VALUE_RENDER_QUALITY};
    private Object[] strokeControlValues = new Object[]{RenderingHints.VALUE_STROKE_DEFAULT, RenderingHints.VALUE_STROKE_PURE, RenderingHints.VALUE_STROKE_NORMALIZE};
    private Object[] textAntiAliasingValues = new Object[]{RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR};
    private JLabel alphaInterpolationLB = null;
    private JLabel antiAliasingLB = null;
    private JLabel colorRenderingLB = null;
    private JLabel ditheringLB = null;
    private JLabel fractionalLB = null;
    private JLabel interpolationLB = null;
    private JLabel renderingLB = null;
    private JLabel strokeControlLB = null;
    private JLabel textAntiAliasingLB = null;
    private JLabel textLCDContrastLB = null;
    private JComboBox<Object> alphaInterpolationCB = null;
    private JComboBox<Object> antiAliasingCB = null;
    private JComboBox<Object> colorRenderingCB = null;
    private JComboBox<Object> ditheringCB = null;
    private JComboBox<Object> fractionalCB = null;
    private JComboBox<Object> interpolationCB = null;
    private JComboBox<Object> renderingCB = null;
    private JComboBox<Object> strokeControlCB = null;
    private JComboBox<Object> textAntiAliasingCB = null;
    private JSpinner textLCDContrastSI = null;
    private boolean isListening = true;

    public JRenderingHintsPanel(RenderingHints hints) {
        this(hints, false);
    }

    public JRenderingHintsPanel(RenderingHints hints, boolean showTitle) {
        if (hints != null) {
            this.hints = hints;
        } else {
            hints = new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
        }
        this.showBorder = showTitle;
        this.initGUI();
        this.refreshGUI();
    }

    protected void initGUI() {
        GridBagConstraints c = null;
        Insets labelInsets = new Insets(3, 6, 3, 0);
        Insets fieldInsets = new Insets(3, 0, 3, 6);
        this.isListening = false;
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRenderingHintsPanel.this.processItemEvent(e);
            }
        };
        this.alphaInterpolationLB = new JLabel(this.lr.getString("GUI_RH_ALPHA_INTERPOLATION_LB") + ": ");
        this.alphaInterpolationLB.setToolTipText(this.lr.getString("GUI_RH_ALPHA_INTERPOLATION_TIP"));
        this.antiAliasingLB = new JLabel(this.lr.getString("GUI_RH_ANTIALIASING_LB") + ": ");
        this.antiAliasingLB.setToolTipText(this.lr.getString("GUI_RH_ANTIALIASING_TIP"));
        this.colorRenderingLB = new JLabel(this.lr.getString("GUI_RH_COLOR_RENDERING_LB") + ": ");
        this.colorRenderingLB.setToolTipText(this.lr.getString("GUI_RH_COLOR_RENDERING_TIP"));
        this.ditheringLB = new JLabel(this.lr.getString("GUI_RH_DITHERING_LB") + ": ");
        this.ditheringLB.setToolTipText(this.lr.getString("GUI_RH_DITHERING_TIP"));
        this.fractionalLB = new JLabel(this.lr.getString("GUI_RH_FRACTIONALMETRICS_LB") + ": ");
        this.fractionalLB.setToolTipText(this.lr.getString("GUI_RH_FRACTIONALMETRICS_TIP"));
        this.interpolationLB = new JLabel(this.lr.getString("GUI_RH_INTERPOLATION_LB") + ": ");
        this.interpolationLB.setToolTipText(this.lr.getString("GUI_RH_INTERPOLATION_TIP"));
        this.renderingLB = new JLabel(this.lr.getString("GUI_RH_RENDERING_LB") + ": ");
        this.renderingLB.setToolTipText(this.lr.getString("GUI_RH_RENDERING_TIP"));
        this.strokeControlLB = new JLabel(this.lr.getString("GUI_RH_STROKE_CONTROL_LB") + ": ");
        this.strokeControlLB.setToolTipText(this.lr.getString("GUI_RH_STROKE_CONTROL_TIP"));
        this.textAntiAliasingLB = new JLabel(this.lr.getString("GUI_RH_TEXT_ANTIALIASING_LB") + ": ");
        this.textAntiAliasingLB.setToolTipText(this.lr.getString("GUI_RH_TEXT_ANTIALIASING_TIP"));
        this.textLCDContrastLB = new JLabel(this.lr.getString("GUI_RH_TEXT_LCD_CONTRAST_LB") + ": ");
        this.textLCDContrastLB.setToolTipText(this.lr.getString("GUI_RH_TEXT_LCD_CONTRAST_TIP"));
        this.alphaInterpolationCB = new JComboBox<Object>(this.alphaInterpolationValues);
        this.alphaInterpolationCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_SPEED_LB"));
                    } else if (value.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_QUALITY_LB"));
                    }
                }
                return label;
            }
        });
        this.alphaInterpolationCB.addItemListener(itemListener);
        this.antiAliasingCB = new JComboBox<Object>(this.antiAliasingValues);
        this.antiAliasingCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_ANTIALIAS_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_ANTIALIAS_OFF)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_OFF_LB"));
                    } else if (value.equals(RenderingHints.VALUE_ANTIALIAS_ON)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_ON_LB"));
                    }
                }
                return label;
            }
        });
        this.antiAliasingCB.addItemListener(itemListener);
        this.colorRenderingCB = new JComboBox<Object>(this.colorRenderingValues);
        this.colorRenderingCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_COLOR_RENDER_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_COLOR_RENDER_SPEED)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_OFF_LB"));
                    } else if (value.equals(RenderingHints.VALUE_COLOR_RENDER_QUALITY)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_ON_LB"));
                    }
                }
                return label;
            }
        });
        this.colorRenderingCB.addItemListener(itemListener);
        this.ditheringCB = new JComboBox<Object>(this.ditheringValues);
        this.ditheringCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_DITHER_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_DITHER_DISABLE)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_OFF_LB"));
                    } else if (value.equals(RenderingHints.VALUE_DITHER_ENABLE)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_ON_LB"));
                    }
                }
                return label;
            }
        });
        this.ditheringCB.addItemListener(itemListener);
        this.fractionalCB = new JComboBox<Object>(this.fractionalMetricsValues);
        this.fractionalCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_FRACTIONALMETRICS_OFF)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_OFF_LB"));
                    } else if (value.equals(RenderingHints.VALUE_FRACTIONALMETRICS_ON)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_ON_LB"));
                    }
                }
                return label;
            }
        });
        this.fractionalCB.addItemListener(itemListener);
        this.interpolationCB = new JComboBox<Object>(this.interpolationValues);
        this.interpolationCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_NEAREST_NEIGHBOUR_LB"));
                    } else if (value.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_BILINEAR_LB"));
                    } else if (value.equals(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_BICUBIC_LB"));
                    }
                }
                return label;
            }
        });
        this.interpolationCB.addItemListener(itemListener);
        this.renderingCB = new JComboBox<Object>(this.renderingValues);
        this.renderingCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_RENDER_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_RENDER_SPEED)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_SPEED_LB"));
                    } else if (value.equals(RenderingHints.VALUE_RENDER_QUALITY)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_QUALITY_LB"));
                    }
                }
                return label;
            }
        });
        this.renderingCB.addItemListener(itemListener);
        this.strokeControlCB = new JComboBox<Object>(this.strokeControlValues);
        this.strokeControlCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_STROKE_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_STROKE_PURE)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_PURE_LB"));
                    } else if (value.equals(RenderingHints.VALUE_STROKE_NORMALIZE)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_NORMALIZE_LB"));
                    }
                }
                return label;
            }
        });
        this.strokeControlCB.addItemListener(itemListener);
        this.textAntiAliasingCB = new JComboBox<Object>(this.textAntiAliasingValues);
        this.textAntiAliasingCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_DEFAULT_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_GASP)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_TEXT_ANTIALIAS_GASP_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_TEXT_ANTIALIAS_LCD_HBGR_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_TEXT_ANTIALIAS_LCD_HRGB_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_TEXT_ANTIALIAS_LCD_VBGR_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_TEXT_ANTIALIAS_LCD_VRGB_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_OFF_LB"));
                    } else if (value.equals(RenderingHints.VALUE_TEXT_ANTIALIAS_ON)) {
                        label.setText(JRenderingHintsPanel.this.lr.getString("GUI_RH_VALUE_ON_LB"));
                    }
                }
                return label;
            }
        });
        this.textAntiAliasingCB.addItemListener(itemListener);
        SpinnerNumberModel sopacmodel = new SpinnerNumberModel(140, 100, 250, 1);
        this.textLCDContrastSI = new JSpinner(sopacmodel);
        this.textLCDContrastSI.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRenderingHintsPanel.this.processChangeEvent(e);
            }
        });
        this.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.renderingLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.renderingCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.colorRenderingLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.colorRenderingCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.interpolationLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.interpolationCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.alphaInterpolationLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.alphaInterpolationCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.antiAliasingLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.antiAliasingCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.ditheringLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.ditheringCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.fractionalLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.fractionalCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.strokeControlLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.strokeControlCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.textAntiAliasingLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add(this.textAntiAliasingCB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = labelInsets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        this.add((Component)this.textLCDContrastLB, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = fieldInsets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        this.add((Component)this.textLCDContrastSI, c);
        if (this.showBorder) {
            this.setBorder(BorderFactory.createTitledBorder(this.lr.getString("GUI_RH_ID")));
        }
        this.isListening = true;
    }

    public void refreshGUI() {
        this.isListening = false;
        if (this.hints != null) {
            this.renderingCB.setSelectedItem(this.hints.get(RenderingHints.KEY_RENDERING));
            this.colorRenderingCB.setSelectedItem(this.hints.get(RenderingHints.KEY_COLOR_RENDERING));
            this.interpolationCB.setSelectedItem(this.hints.get(RenderingHints.KEY_INTERPOLATION));
            this.alphaInterpolationCB.setSelectedItem(this.hints.get(RenderingHints.KEY_ALPHA_INTERPOLATION));
            this.antiAliasingCB.setSelectedItem(this.hints.get(RenderingHints.KEY_ANTIALIASING));
            this.ditheringCB.setSelectedItem(this.hints.get(RenderingHints.KEY_DITHERING));
            this.fractionalCB.setSelectedItem(this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS));
            this.strokeControlCB.setSelectedItem(this.hints.get(RenderingHints.KEY_STROKE_CONTROL));
            this.textAntiAliasingCB.setSelectedItem(this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING));
            if (this.hints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST) != null) {
                this.textLCDContrastSI.setValue(this.hints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            } else {
                this.textLCDContrastSI.setValue(140);
            }
        }
        this.isListening = true;
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.isListening) {
            if (e.getSource() == this.alphaInterpolationCB) {
                this.hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, this.alphaInterpolationCB.getSelectedItem());
            } else if (e.getSource() == this.antiAliasingCB) {
                this.hints.put(RenderingHints.KEY_ANTIALIASING, this.antiAliasingCB.getSelectedItem());
            } else if (e.getSource() == this.colorRenderingCB) {
                this.hints.put(RenderingHints.KEY_COLOR_RENDERING, this.colorRenderingCB.getSelectedItem());
            } else if (e.getSource() == this.ditheringCB) {
                this.hints.put(RenderingHints.KEY_DITHERING, this.ditheringCB.getSelectedItem());
            } else if (e.getSource() == this.fractionalCB) {
                this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fractionalCB.getSelectedItem());
            } else if (e.getSource() == this.interpolationCB) {
                this.hints.put(RenderingHints.KEY_INTERPOLATION, this.interpolationCB.getSelectedItem());
            } else if (e.getSource() == this.renderingCB) {
                this.hints.put(RenderingHints.KEY_RENDERING, this.renderingCB.getSelectedItem());
            } else if (e.getSource() == this.strokeControlCB) {
                this.hints.put(RenderingHints.KEY_STROKE_CONTROL, this.strokeControlCB.getSelectedItem());
            } else if (e.getSource() == this.textAntiAliasingCB) {
                this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAntiAliasingCB.getSelectedItem());
            }
        }
    }

    protected void processChangeEvent(ChangeEvent e) {
        if (this.isListening && e.getSource() == this.textLCDContrastSI) {
            this.hints.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, this.textLCDContrastSI.getValue());
        }
    }

    public void setRenderingHints(RenderingHints hints) {
        if (hints != null) {
            this.hints = hints;
            this.refreshGUI();
        }
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

