/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashWindow
extends JWindow {
    private static final long serialVersionUID = 201812141330L;
    private JProgressBar progressBar = null;
    private int maxValue = 0;
    private JLabel state = null;
    private JPanel southPanel = null;
    final Runnable closerRunner = new Runnable(){

        @Override
        public void run() {
            SplashWindow.this.setVisible(false);
            SplashWindow.this.dispose();
        }
    };

    public SplashWindow(ImageIcon image) {
        this(image, 0);
    }

    public SplashWindow(ImageIcon image, int intProgressMaxValue) {
        this.state = new JLabel("");
        this.state.setForeground(Color.white);
        if (intProgressMaxValue > 0) {
            this.progressBar = new JProgressBar(0, intProgressMaxValue);
            this.maxValue = intProgressMaxValue;
        } else {
            this.progressBar = new JProgressBar();
            this.progressBar.setIndeterminate(true);
            this.maxValue = 0;
        }
        this.southPanel = new JPanel();
        this.southPanel.setBackground(Color.black);
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.add((Component)this.state, "North");
        this.southPanel.add((Component)this.progressBar, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        JLabel label = new JLabel(image);
        this.getContentPane().add((Component)label, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = label.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void setProgressMaxValue(int maxValue) {
        if (maxValue > 0) {
            this.progressBar.setMaximum(maxValue);
            this.progressBar.setIndeterminate(false);
        } else {
            this.progressBar.setMaximum(0);
            this.progressBar.setIndeterminate(true);
        }
    }

    public void setProgressValue(int value) {
        this.progressBar.setValue(value);
        if (value >= this.maxValue && this.maxValue > 0) {
            try {
                SwingUtilities.invokeAndWait(this.closerRunner);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void setState(String text) {
        this.state.setText(text);
        this.state.repaint();
    }
}

