/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.lang;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import org.jorigin.Common;
import org.jorigin.lang.PathUtil;
import org.jorigin.lang.xml.LangResourceXMLReader;

public class LangResource {
    private HashMap<String, String> resources = null;
    private String resourcesPath = "resource" + File.separator + "lang" + File.separator;
    private Locale locale = null;
    private ArrayList<String> availableLocales = null;

    public LangResource() {
        this(null, null);
    }

    public LangResource(String baseName) {
        this(baseName, null);
    }

    public LangResource(String baseName, Locale locale) {
        if (baseName == null) {
            if (System.getProperty("lang.resource.root") != null) {
                try {
                    this.resourcesPath = PathUtil.URIToPath(System.getProperty("lang.resource.root"));
                }
                catch (Exception e) {
                    Common.logger.log(Level.SEVERE, "Cannot use lang.resource.root property value: " + System.getProperty("lang.resource.root"), e);
                }
            }
        } else {
            this.resourcesPath = baseName;
        }
        if (locale == null) {
            try {
                this.locale = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
            }
            catch (RuntimeException e) {
                Common.logger.log(Level.SEVERE, "Cannot instanciate locale: " + System.getProperty("user.language") + "_" + System.getProperty("user.country"), e);
            }
        } else {
            this.locale = locale;
        }
        this.locale = new Locale(System.getProperty("user.language"), System.getProperty("user.country"));
        this.resources = new HashMap();
        this.availableLocales = new ArrayList();
        Common.logger.log(Level.CONFIG, "Lang resource path         : " + this.resourcesPath);
        Common.logger.log(Level.CONFIG, "Lang resource Given locale : " + locale);
        Common.logger.log(Level.CONFIG, "Lang resource System locale: " + this.locale);
        this.init();
    }

    protected void init() {
        File f = null;
        File[] files = null;
        String str = null;
        if (this.resourcesPath == null) {
            Common.logger.log(Level.SEVERE, "[LangResource] [init()] Lang resource directory " + PathUtil.URIToPath(this.resourcesPath) + " does not exist.");
            return;
        }
        f = new File(this.resourcesPath);
        if (f == null || !f.exists()) {
            Common.logger.log(Level.SEVERE, "[LangResource] [init()] Lang resource directory " + PathUtil.URIToPath(this.resourcesPath) + " does not exist.");
            return;
        }
        files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".xml");
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                str = files[i].getPath();
                if ((str = str.substring(0, str.lastIndexOf("."))).length() <= 4 || this.availableLocales.contains(str = str.substring(str.length() - 5))) continue;
                this.availableLocales.add(str);
            }
        }
        if (this.locale != null) {
            f = new File(this.resourcesPath);
            this.addResource(f);
            f = null;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.init();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setResourcePath(String path) {
        this.resourcesPath = path;
        this.init();
    }

    public String getResourcePath() {
        return this.resourcesPath;
    }

    public HashMap<String, String> getResources() {
        return this.resources;
    }

    public ArrayList<String> getAvailableLocales() {
        return this.availableLocales;
    }

    public Set<String> getKeySet() {
        return this.resources.keySet();
    }

    public int size() {
        return this.resources.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addResource(File resourceFile) {
        File[] files = null;
        HashMap<String, String> resources = null;
        if (!resourceFile.exists()) {
            return;
        }
        if (resourceFile.isDirectory()) {
            files = resourceFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    return pathname.getPath().endsWith(LangResource.this.locale + ".xml");
                }
            });
            if (files == null) return;
            int i = 0;
            while (i < files.length) {
                this.addResource(files[i]);
                ++i;
            }
            return;
        }
        try {
            Common.logger.config("Lang resource file " + resourceFile.getPath() + " loaded");
            resources = new LangResourceXMLReader().getParsedLangResource(resourceFile.getPath());
            if (resources == null) return;
            this.addResources(resources);
            return;
        }
        catch (IOException ex) {
            Common.logger.log(Level.SEVERE, "Cannot read resource file " + resourceFile.getPath(), ex);
        }
    }

    public void addResources(HashMap<String, String> resources) {
        this.resources.putAll(resources);
    }

    public void addResources(LangResource resource) {
        this.resources.putAll(resource.getResources());
    }

    public Object getResource(String key) {
        return this.getResource(key, (String[])null);
    }

    public Object getResource(String key, String param) {
        return this.getResource(key, new String[]{param});
    }

    public Object getResource(String key, String[] params) {
        String value = null;
        int paramCount = -1;
        if (this.resources == null) {
            Common.logger.log(Level.WARNING, "No resource bundle available " + key);
            return key;
        }
        value = this.resources.get(key);
        if (value == null) {
            Common.logger.log(Level.WARNING, "No resource value available for key " + key);
            return key;
        }
        if (params == null || params.length < 1) {
            return value.replaceAll("%%\\d++", "");
        }
        paramCount = params.length;
        for (int i = 0; i < paramCount; ++i) {
            value.replace("%%" + i, params[i]);
        }
        return value;
    }

    public String getString(String key) {
        return this.getResource(key).toString();
    }

    public String getString(String key, String[] aParams) {
        return this.getResource(key).toString();
    }
}

