/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jorigin.Common;
import org.jorigin.task.ActivityCaret;
import org.jorigin.task.TaskEvent;

public class ActivityMonitor
extends JDialog {
    private static final long serialVersionUID = 201812141330L;
    public static final int SHOW_PROGRESS_PERCENT = 1;
    public static final int SHOW_PROGRESS_COUNT = 2;
    public static final int SHOW_PROGRESS_ALL = 3;
    public Lock lock = null;
    Icon frameIcon;
    GridBagLayout layout;
    JProgressBar progressBar;
    DefaultStyledDocument activityTracerDocument;
    StyleContext sc = null;
    Style taskStartedStyle = null;
    Style taskFinishedStyle = null;
    Style taskProgressStyle = null;
    Style taskInfoStyle = null;
    Style taskWarningStyle = null;
    Style taskErrorStyle = null;
    JTextPane activityTracer;
    JScrollPane activityTracerScrollPane;
    JCheckBox persistenceCheckBox;
    boolean showProgressionText = true;
    int showProgressType = 3;
    boolean isPersistent = true;
    boolean PROGRESS_BAR_VISIBLE;
    boolean ACTIVITY_TRACER_VISIBLE;
    int boundedTask;
    Font taskStartFont = new Font("Dialog", 1, 11);
    Color taskStartColor = Color.green;
    Font taskProgressFont = new Font("Dialog", 2, 10);
    Color taskProgressColor = Color.black;

    public ActivityMonitor(JFrame owner) {
        super(owner);
        super.setDefaultCloseOperation(1);
        this.setSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(600, 500));
        this.sc = new StyleContext();
        this.taskStartedStyle = this.sc.addStyle("taskStarted", null);
        this.taskFinishedStyle = this.sc.addStyle("taskFinished", null);
        this.taskProgressStyle = this.sc.addStyle("taskProgress", null);
        this.taskInfoStyle = this.sc.addStyle("taskInfo", null);
        this.taskWarningStyle = this.sc.addStyle("taskWarning", null);
        this.taskErrorStyle = this.sc.addStyle("taskError", null);
        StyleConstants.setBold(this.taskStartedStyle, true);
        StyleConstants.setFontFamily(this.taskStartedStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskStartedStyle, 11);
        StyleConstants.setForeground(this.taskStartedStyle, Color.black);
        StyleConstants.setBold(this.taskFinishedStyle, true);
        StyleConstants.setFontFamily(this.taskFinishedStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskFinishedStyle, 11);
        StyleConstants.setForeground(this.taskFinishedStyle, Color.black);
        StyleConstants.setBold(this.taskProgressStyle, false);
        StyleConstants.setFontFamily(this.taskProgressStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskProgressStyle, 11);
        StyleConstants.setForeground(this.taskProgressStyle, Color.black);
        StyleConstants.setBold(this.taskInfoStyle, false);
        StyleConstants.setFontFamily(this.taskInfoStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskInfoStyle, 11);
        StyleConstants.setForeground(this.taskInfoStyle, Color.black);
        StyleConstants.setBold(this.taskWarningStyle, false);
        StyleConstants.setFontFamily(this.taskWarningStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskWarningStyle, 11);
        StyleConstants.setForeground(this.taskWarningStyle, Color.ORANGE);
        StyleConstants.setBold(this.taskErrorStyle, false);
        StyleConstants.setFontFamily(this.taskErrorStyle, "Helvetica");
        StyleConstants.setFontSize(this.taskErrorStyle, 11);
        StyleConstants.setForeground(this.taskErrorStyle, Color.RED);
        this.lock = new ReentrantLock();
        this.initGUI();
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
        if (isPersistent) {
            this.persistenceCheckBox.setSelected(false);
        } else {
            this.persistenceCheckBox.setSelected(true);
        }
    }

    public boolean isPersistent() {
        return this.isPersistent();
    }

    protected void initGUI() {
        this.activityTracer = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public void repaint() {
                try {
                    super.repaint();
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Cannot repaint activity tracer");
                }
            }

            @Override
            public void repaint(long tm) {
                try {
                    super.repaint(tm);
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Cannot repaint activity tracer");
                }
            }

            @Override
            public void repaint(int x, int y, int width, int height) {
                try {
                    super.repaint(x, y, width, height);
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Cannot repaint activity tracer");
                }
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
                try {
                    super.repaint(tm, x, y, width, height);
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Cannot repaint activity tracer");
                }
            }

            @Override
            public void setCaretPosition(int position) {
                try {
                    super.setCaretPosition(position);
                }
                catch (Exception e) {
                    Common.logger.log(Level.WARNING, "Cannot set caret position in activity tracer");
                }
            }
        };
        this.activityTracer.setCaret(new ActivityCaret());
        this.activityTracer.setMaximumSize(new Dimension(65535, 65535));
        this.activityTracerDocument = (DefaultStyledDocument)this.activityTracer.getDocument();
        this.activityTracerScrollPane = new JScrollPane();
        this.activityTracerScrollPane.setSize(320, 400);
        this.activityTracerScrollPane.setPreferredSize(new Dimension(320, 400));
        this.activityTracerScrollPane.setMinimumSize(new Dimension(180, 250));
        this.activityTracerScrollPane.setHorizontalScrollBarPolicy(30);
        this.activityTracerScrollPane.setVerticalScrollBarPolicy(20);
        this.activityTracerScrollPane.setWheelScrollingEnabled(true);
        this.activityTracerScrollPane.getViewport().add(this.activityTracer);
        this.progressBar = new JProgressBar();
        this.progressBar.setSize(new Dimension(320, 20));
        this.progressBar.setPreferredSize(new Dimension(320, 20));
        this.progressBar.setMinimumSize(new Dimension(320, 20));
        this.progressBar.setStringPainted(true);
        this.persistenceCheckBox = new JCheckBox("Close");
        this.persistenceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ActivityMonitor.this.isPersistent = e.getStateChange() != 1;
            }
        });
        this.layout = new GridBagLayout();
        this.setTitle("Monitor");
        this.setName("Monitor");
        this.getContentPane().setLayout(this.layout);
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.add((Component)this.activityTracerScrollPane, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.add((Component)this.progressBar, c);
        c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 11;
        this.add((Component)this.persistenceCheckBox, c);
        this.pack();
    }

    public void init(boolean activityVisible, boolean progressBarVisible) {
        Point location = null;
        Dimension ownerSize = null;
        if (this.getOwner() != null) {
            location = this.getOwner().getLocation();
            ownerSize = this.getOwner().getSize();
            this.setLocation((int)location.getX() + ownerSize.width / 2 - this.getWidth() / 2, ((int)location.getY() + ownerSize.height) / 2 - this.getHeight() / 2);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation(0, 0);
        }
        this.activityTracerScrollPane.setVisible(activityVisible);
        this.progressBar.setVisible(progressBarVisible);
        this.progressBar.setEnabled(progressBarVisible);
        this.boundedTask = 0;
        this.isPersistent = true;
        this.pack();
    }

    private String indent(String str, int indent) {
        Object tmp = new String();
        for (int i = 0; i < indent; ++i) {
            tmp = (String)tmp + " ";
        }
        tmp = (String)tmp + str;
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String str, Style style) {
        try {
            this.lock.lock();
            this.activityTracerDocument.insertString(this.activityTracerDocument.getLength(), "    " + str + "\n", style);
            this.activityTracer.setCaretPosition(this.activityTracerDocument.getLength());
        }
        catch (Exception ex) {
            Common.logger.log(Level.WARNING, "Cannot display message on activity monitor", ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeWithIndent(String str, int indent, Style style) {
        this.write(this.indent(str, indent * 2), style);
    }

    public void processTaskEvent(TaskEvent event) {
        try {
            switch (event.getID()) {
                case 3998: {
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask, this.taskStartedStyle);
                    }
                    ++this.boundedTask;
                    if (event.getSize() > 0) {
                        this.progressBar.setMinimum(0);
                        this.progressBar.setMaximum(event.getSize());
                        this.progressBar.setValue(0);
                        this.progressBar.setIndeterminate(false);
                    } else {
                        this.progressBar.setMinimum(0);
                        this.progressBar.setMaximum(0);
                        this.progressBar.setValue(0);
                        this.progressBar.setIndeterminate(true);
                    }
                    this.setVisible(true);
                    break;
                }
                case 7996: {
                    Object progress = "";
                    Object percent = "";
                    Object text = "";
                    int ratio = 0;
                    int size = event.getSize();
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskProgressStyle);
                    }
                    this.progressBar.setValue(size);
                    if (this.showProgressionText && !this.progressBar.isIndeterminate()) {
                        if ((this.showProgressType & 2) != 0) {
                            progress = (String)progress + size + " / " + this.progressBar.getMaximum();
                        }
                        if ((this.showProgressType & 1) != 0) {
                            ratio = (int)((double)size / (double)this.progressBar.getMaximum() * 100.0);
                            percent = (String)percent + ratio + " %";
                        }
                        if (progress != null) {
                            text = (String)text + (String)progress;
                        }
                        if (percent != null) {
                            text = !((String)text).equals("") ? (String)text + " - " + (String)percent : (String)text + (String)percent;
                        }
                    }
                    this.progressBar.setString((String)text);
                    this.progressBar.repaint();
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 15992: {
                    break;
                }
                case 31984: {
                    --this.boundedTask;
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription() + "\n", this.boundedTask, this.taskFinishedStyle);
                    }
                    if (this.boundedTask < 1 && !this.isPersistent) {
                        this.setVisible(false);
                    }
                    this.progressBar.setIndeterminate(false);
                    break;
                }
                case 63968: {
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskWarningStyle);
                    }
                    this.progressBar.repaint();
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 127936: {
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskErrorStyle);
                    }
                    this.progressBar.repaint();
                    this.activityTracer.repaint();
                    this.repaint();
                    break;
                }
                case 255872: {
                    if (event.getDescription() != null && !event.getDescription().trim().equals("")) {
                        this.writeWithIndent(event.getDescription(), this.boundedTask + 3, this.taskInfoStyle);
                    }
                    this.progressBar.repaint();
                    this.activityTracer.repaint();
                    this.repaint();
                }
            }
        }
        catch (Exception e) {
            Common.logger.log(Level.WARNING, "Cannot repaint activity monitor", e);
        }
    }
}

