/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.gui.thumbnail;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.jorigin.gui.thumbnail.JThumbnailListener;

public class JThumbnail<T>
extends JPanel
implements EventListener,
MouseListener {
    private static final long serialVersionUID = 201801141330L;
    protected JPanel thumbnailPN = null;
    protected JLabel nameLB = null;
    protected int thumbnailMargin = 5;
    protected Font idFont;
    protected Color idColor = Color.BLACK;
    protected Color standardBgColor = (Color)UIManager.get("List.background");
    protected Color focusBgColor = (Color)UIManager.get("Label.background");
    protected Color selectedBgColor = (Color)UIManager.get("List.selectionBackground");
    protected Color markedBgColor = Color.YELLOW;
    protected Border focusedBorder = (Border)UIManager.get("List.focusCellHighlightBorder");
    protected Border currentBorder = null;
    protected Color currentBgColor = this.standardBgColor;
    protected boolean standard = true;
    protected boolean focused = false;
    protected boolean selected = false;
    protected boolean marked = false;
    protected int thumbnailID;
    protected String name;
    protected T content;
    protected JComponent thumbnailComponent;
    protected EventListenerList idListenerList = new EventListenerList();
    protected boolean nameVisible = true;
    protected String nameOrientation = "South";
    protected boolean idVisible = true;

    public JThumbnail(String name, int width, int height, int margin, int ID) {
        this.nameLB = new JLabel(name);
        this.thumbnailPN = new JPanel();
        this.thumbnailPN.setBackground(Color.cyan);
        this.thumbnailPN.setLayout(new FlowLayout());
        this.setSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
        BorderLayout labelLayout = new BorderLayout();
        labelLayout.setVgap(margin);
        labelLayout.setHgap(margin);
        this.setLayout(labelLayout);
        this.add((Component)this.thumbnailPN, "Center");
        this.add((Component)this.nameLB, this.nameOrientation);
        this.idFont = new Font("Dialog", 1, 11);
        this.focused = false;
        this.selected = false;
        this.marked = false;
        this.thumbnailMargin = margin;
        this.setBackground(this.standardBgColor);
        this.thumbnailID = ID;
        this.setName(name);
        this.setContent(this.content);
        this.setToolTipText(name);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JThumbnail.this.processLabelMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JThumbnail.this.processLabelMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JThumbnail.this.processLabelMouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JThumbnail.this.processLabelMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JThumbnail.this.processLabelMouseEvent(e);
            }
        });
        this.refreshGUI();
    }

    public JThumbnail(String name, T content, JComponent component, int width, int height, int margin, int labelID) {
        this(name, width, height, margin, labelID);
        this.content = content;
        this.thumbnailComponent = component;
        this.thumbnailComponent.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JThumbnail.this.processComponentMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JThumbnail.this.processComponentMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JThumbnail.this.processComponentMouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JThumbnail.this.processComponentMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JThumbnail.this.processComponentMouseEvent(e);
            }
        });
        this.thumbnailPN.add((Component)this.thumbnailComponent, "Center");
        this.refreshGUI();
    }

    public void setStandard(boolean b) {
        this.standard = b;
        this.refresh();
    }

    public boolean isStandard() {
        return this.standard;
    }

    public void setMarked(boolean b) {
        this.marked = b;
        this.refresh();
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setFocused(boolean b) {
        this.focused = b;
        this.refresh();
    }

    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public int getID() {
        return this.thumbnailID;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.refresh();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setIdFont(Font f) {
        this.idFont = f;
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean nameVisible) {
        this.nameVisible = nameVisible;
    }

    public String getNameOrientation() {
        return this.nameOrientation;
    }

    public void setNameOrientation(String nameOrientation) {
        this.nameOrientation = nameOrientation;
    }

    public boolean isIdVisible() {
        return this.idVisible;
    }

    public void setIdVisible(boolean visible) {
        this.idVisible = visible;
    }

    public void refresh() {
        if (this.standard) {
            this.currentBgColor = this.standardBgColor;
            this.currentBorder = null;
        }
        if (this.marked) {
            this.currentBgColor = this.markedBgColor;
            this.currentBorder = null;
        }
        if (this.focused) {
            this.currentBgColor = this.focusBgColor;
            this.currentBorder = this.focusedBorder;
        }
        if (this.selected) {
            this.currentBgColor = this.selectedBgColor;
            this.currentBorder = null;
        }
        this.setBorder(this.currentBorder);
        this.setBackground(this.currentBgColor);
        if (this.thumbnailComponent != null) {
            this.thumbnailComponent.validate();
            this.thumbnailComponent.setVisible(true);
            this.thumbnailComponent.repaint();
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Color oldColor = g.getColor();
        if (this.idVisible) {
            g.setColor(this.currentBgColor);
            g.fillRect(0, 0, 15, 10);
            g.setColor(this.idColor);
            g.setFont(this.idFont);
            g.drawString("" + this.thumbnailID, 3, 8);
        }
        if (this.nameVisible) {
            this.nameLB.setText(this.getName());
        } else {
            this.nameLB.setText(null);
        }
        g.setColor(oldColor);
    }

    protected void fireThumbnailFocused(JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailListener.class) continue;
            ((JThumbnailListener)listeners[i + 1]).thumbnailFocused(thumbnail);
        }
    }

    protected void fireThumbnailUnfocused(JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailListener.class) continue;
            ((JThumbnailListener)listeners[i + 1]).thumbnailUnfocused(thumbnail);
        }
    }

    protected void fireThumbnailSelected() {
        this.fireThumbnailSelected(this);
    }

    protected void fireThumbnailSelected(JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailListener.class) continue;
            ((JThumbnailListener)listeners[i + 1]).thumbnailSelected(thumbnail);
        }
    }

    protected void fireThumbnailActivated(JThumbnail<T> thumbnail) {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailListener.class) continue;
            ((JThumbnailListener)listeners[i + 1]).thumbnailActivated(thumbnail);
        }
    }

    protected void labelActivated() {
        Object[] listeners = this.idListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JThumbnailListener.class) continue;
            ((JThumbnailListener)listeners[i + 1]).thumbnailActivated(this);
        }
    }

    public void addThumbnailListener(JThumbnailListener<T> l) {
        this.idListenerList.add(JThumbnailListener.class, l);
    }

    public void removeThumbnailListener(JThumbnailListener<T> l) {
        this.idListenerList.remove(JThumbnailListener.class, l);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.labelActivated();
        } else if (e.getClickCount() == 1) {
            this.fireThumbnailSelected();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected void processLabelMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 504: {
                if (this.focused) break;
                this.focused = true;
                this.refresh();
                this.fireThumbnailFocused(this);
                break;
            }
            case 505: {
                this.focused = false;
                this.fireThumbnailUnfocused(this);
                this.refresh();
                break;
            }
            case 500: {
                if (e.getClickCount() >= 2) {
                    this.labelActivated();
                    break;
                }
                if (e.getClickCount() != 1) break;
                this.fireThumbnailSelected();
            }
        }
    }

    protected void refreshGUI() {
        Dimension size = this.getSize();
        if (this.isNameVisible()) {
            Dimension nameLBSize = this.nameLB.getSize();
            if ("South".equals(this.nameOrientation) || "North".equals(this.nameOrientation)) {
                this.thumbnailPN.setSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin - nameLBSize.height));
                this.thumbnailPN.setPreferredSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin - nameLBSize.height));
                this.thumbnailPN.setMaximumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin - nameLBSize.height));
                this.thumbnailPN.setMinimumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin - nameLBSize.height));
            } else if ("West".equals(this.nameOrientation) || "East".equals(this.nameOrientation)) {
                this.thumbnailPN.setSize(new Dimension(size.width - 2 * this.thumbnailMargin - nameLBSize.width, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setPreferredSize(new Dimension(size.width - 2 * this.thumbnailMargin - nameLBSize.width, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setMaximumSize(new Dimension(size.width - 2 * this.thumbnailMargin - nameLBSize.width, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setMinimumSize(new Dimension(size.width - 2 * this.thumbnailMargin - nameLBSize.width, size.height - 2 * this.thumbnailMargin));
            } else {
                this.thumbnailPN.setSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setPreferredSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setMaximumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
                this.thumbnailPN.setMinimumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
            }
        } else {
            this.thumbnailPN.setSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
            this.thumbnailPN.setPreferredSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
            this.thumbnailPN.setMaximumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
            this.thumbnailPN.setMinimumSize(new Dimension(size.width - 2 * this.thumbnailMargin, size.height - 2 * this.thumbnailMargin));
        }
    }

    protected void processComponentMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 504: {
                if (this.focused) break;
                this.focused = true;
                this.refresh();
                e.setSource(this);
                this.processMouseEvent(e);
                this.fireThumbnailFocused(this);
                break;
            }
            case 505: {
                this.focused = false;
                e.setSource(this);
                this.processMouseEvent(e);
                this.fireThumbnailUnfocused(this);
                this.refresh();
                break;
            }
            case 500: {
                if (e.getClickCount() >= 2) {
                    this.labelActivated();
                } else if (e.getClickCount() == 1) {
                    this.fireThumbnailSelected();
                }
                e.setSource(this);
                this.processMouseEvent(e);
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
    }
}

