/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jorigin.lang.PathUtil;

public class IOStreamUtil {
    public static InputStream getInputStream(String uri) throws IOException {
        InputStream is = null;
        URL url = null;
        File file = null;
        switch (PathUtil.getProtocol(uri)) {
            case 1: {
                file = new File(uri);
                if (file.exists()) {
                    try {
                        is = new FileInputStream(file);
                        break;
                    }
                    catch (FileNotFoundException ex) {
                        is = null;
                        throw new IOException(ex.getMessage());
                    }
                }
                is = null;
                throw new IOException("File " + file.getPath() + " does not exist");
            }
            case 2: {
                file = new File(PathUtil.URIToPath(uri));
                if (file.exists()) {
                    try {
                        file = new File(PathUtil.URIToPath(uri));
                        is = new FileInputStream(file);
                        break;
                    }
                    catch (FileNotFoundException ex) {
                        is = null;
                        throw new IOException(ex.getMessage());
                    }
                }
                is = null;
                throw new IOException("File " + file.getPath() + " does not exist");
            }
            case 4: {
                try {
                    url = new URL(uri);
                    is = new BufferedInputStream(url.openStream());
                    break;
                }
                catch (MalformedURLException ex) {
                    is = null;
                    throw new IOException(ex.getMessage());
                }
                catch (IOException ex) {
                    is = null;
                    throw new IOException(ex.getMessage());
                }
            }
            case 3: {
                try {
                    url = new URL(uri);
                    is = url.openStream();
                    break;
                }
                catch (MalformedURLException ex) {
                    is = null;
                    throw new IOException(ex.getMessage());
                }
                catch (IOException ex) {
                    is = null;
                    throw new IOException(ex.getMessage());
                }
            }
            default: {
                is = null;
                throw new IOException("Cannot determine protocol used by " + uri);
            }
        }
        return is;
    }

    public static BufferedInputStream getBufferedInputStream(String uri) throws IOException {
        return IOStreamUtil.getBufferedInputStream(uri, -1);
    }

    public static BufferedInputStream getBufferedInputStream(String uri, int bufferSize) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = bufferSize > 0 ? new BufferedInputStream(IOStreamUtil.getInputStream(uri), bufferSize) : new BufferedInputStream(IOStreamUtil.getInputStream(uri));
        }
        catch (IOException e) {
            bis = null;
        }
        if (bis == null) {
            throw new IOException("Cannot create a buffered input stream for " + uri);
        }
        return bis;
    }

    public static OutputStream getOutputStream(String uri) throws IOException {
        FileOutputStream os = null;
        File file = null;
        switch (PathUtil.getProtocol(uri)) {
            case 1: {
                try {
                    file = new File(uri);
                    if (!file.exists()) {
                        if (file.getParentFile() != null) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    os = new FileOutputStream(file);
                    break;
                }
                catch (FileNotFoundException ex) {
                    os = null;
                    throw new IOException(ex.getMessage());
                }
            }
            case 2: {
                try {
                    file = new File(PathUtil.URIToPath(uri));
                    if (!file.exists()) {
                        if (file.getParentFile() != null) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    os = new FileOutputStream(file);
                    break;
                }
                catch (FileNotFoundException ex) {
                    os = null;
                    throw new IOException(ex.getMessage());
                }
            }
            case 4: {
                System.err.println("[IOStreamUtil] FTP output not yet implemented");
                os = null;
                throw new IOException("Protocol FTP not implemented " + uri);
            }
            case 3: {
                System.err.println("[IOStreamUtil] HTTP output not yet implemented");
                os = null;
                throw new IOException("Protocol HTTP not implemented " + uri);
            }
            default: {
                os = null;
                throw new IOException("Cannot determine protocol used by " + uri);
            }
        }
        return os;
    }

    public static BufferedOutputStream getBufferedOutputStream(String uri) throws IOException {
        return IOStreamUtil.getBufferedOutputStream(uri, -1);
    }

    public static BufferedOutputStream getBufferedOutputStream(String uri, int bufferSize) throws IOException {
        BufferedOutputStream bos = null;
        try {
            bos = bufferSize > 0 ? new BufferedOutputStream(IOStreamUtil.getOutputStream(uri), bufferSize) : new BufferedOutputStream(IOStreamUtil.getOutputStream(uri));
        }
        catch (IOException e) {
            bos = null;
        }
        if (bos == null) {
            throw new IOException("Cannot create a buffered output stream for " + uri);
        }
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream source, OutputStream destination) {
        boolean result = false;
        try {
            int nbLecture;
            byte[] buffer = new byte[1024];
            while ((nbLecture = source.read(buffer)) != -1) {
                destination.write(buffer, 0, nbLecture);
            }
            result = true;
        }
        catch (FileNotFoundException f) {
            System.err.println(f);
            result = false;
        }
        catch (IOException e) {
            System.err.println(e);
            result = false;
        }
        finally {
            try {
                source.close();
            }
            catch (Exception f) {}
            try {
                destination.close();
            }
            catch (Exception f) {}
        }
        return result;
    }
}

