/*
 * Decompiled with CFR 0.152.
 */
package org.jorigin.lang;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static boolean isImplements(Class<?> theClass, Class<?> theInterface) {
        return ClassUtil.distanceToInterface(theClass, theInterface) > 0;
    }

    public static boolean isSubClass(Class<?> theClass, Class<?> theAncestor) {
        return ClassUtil.distanceToClass(theClass, theAncestor) > -1;
    }

    public static boolean isSubEntity(Class<?> entity, Class<?> ancestor) {
        if (entity != null && ancestor != null) {
            if (ancestor.isInterface()) {
                return ClassUtil.isImplements(entity, ancestor);
            }
            return ClassUtil.isSubClass(entity, ancestor);
        }
        return false;
    }

    public static int distanceToInterface(Class<?> theClass, Class<?> theInterface) {
        int tmpDistance = 0;
        Class<?>[] interfaces = null;
        if (theClass != null && theInterface != null && theInterface.isInterface()) {
            if (theInterface.equals(theClass)) {
                return 0;
            }
            interfaces = theClass.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                int j;
                for (j = 0; j < interfaces.length; ++j) {
                    if (!theInterface.equals(interfaces[j])) continue;
                    return 1;
                }
                for (j = 0; j < interfaces.length; ++j) {
                    tmpDistance = ClassUtil.distanceToInterface(interfaces[j], theInterface);
                    if (tmpDistance <= -1) continue;
                    return 1 + tmpDistance;
                }
                interfaces = null;
            }
            if ((tmpDistance = ClassUtil.distanceToInterface(theClass.getSuperclass(), theInterface)) > -1) {
                return 1 + tmpDistance;
            }
        }
        return -1;
    }

    public static int distanceToClass(Class<?> theClass, Class<?> theAncestor) {
        Class<?> superClass = null;
        if (theClass != null && theAncestor != null && !theAncestor.isInterface()) {
            if (theAncestor.equals(theClass)) {
                return 0;
            }
            superClass = theClass.getSuperclass();
            if (superClass != null) {
                if (superClass.equals(theAncestor)) {
                    return 1;
                }
                int tmp = ClassUtil.distanceToClass(theClass.getSuperclass(), theAncestor);
                if (tmp > -1) {
                    return 1 + tmp;
                }
            }
            superClass = null;
        }
        return -1;
    }

    public static int distanceToAncestor(Class<?> entity, Class<?> ancestor) {
        if (entity != null && ancestor != null) {
            if (ancestor.isInterface()) {
                return ClassUtil.distanceToInterface(entity, ancestor);
            }
            return ClassUtil.distanceToClass(entity, ancestor);
        }
        return -1;
    }

    private static void checkDirectory(File directory, String pckgname, List<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String file : files = directory.list()) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(pckgname + "." + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                ClassUtil.checkDirectory(tmpDirectory, pckgname + "." + file, classes);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String pckgname, List<Class<?>> classes) throws ClassNotFoundException, IOException {
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry jarEntry = null;
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(pckgname)) continue;
            classes.add(Class.forName(name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> listClasses(String pckgname) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            URL url = null;
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        ClassUtil.checkJarFile((JarURLConnection)connection, pckgname, classes);
                        continue;
                    }
                    if (!(connection instanceof URLConnection)) throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package");
                    try {
                        ClassUtil.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), pckgname, classes);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException ioex) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
        }
    }
}

