/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.jpmml.evaluator.ParameterUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUtil {
    private TableUtil() {
    }

    public static List<Map<String, String>> parse(InlineTable table) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<Row> rows = table.getRows();
        for (Row row : rows) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            List<Object> cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                map.put(element.getTagName(), element.getTextContent());
            }
            result.add(map);
        }
        return result;
    }

    public static Map<String, String> match(List<Map<String, String>> rows, Map<String, ?> values) {
        LinkedHashMap<String, DataType> dataTypes = new LinkedHashMap<String, DataType>();
        block0: for (Map<String, String> row : rows) {
            if (values.size() < row.size()) continue;
            Set<Map.Entry<String, ?>> entries = values.entrySet();
            for (Map.Entry<String, ?> entry : entries) {
                boolean equals;
                String rowValue = row.get(entry.getKey());
                if (rowValue == null) continue block0;
                DataType dataType = (DataType)((Object)dataTypes.get(entry.getKey()));
                if (dataType == null) {
                    dataType = ParameterUtil.getDataType(entry.getValue());
                    dataTypes.put(entry.getKey(), dataType);
                }
                if (equals = ParameterUtil.parse(dataType, rowValue).equals(entry.getValue())) continue;
                continue block0;
            }
            return row;
        }
        return null;
    }
}

