/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

public class VerificationUtil {
    private VerificationUtil() {
    }

    public static boolean acceptable(Object expected, Object actual, double precision) {
        if (expected == null) {
            return actual == null;
        }
        if (expected instanceof Number && actual instanceof Number) {
            return VerificationUtil.acceptable((Number)expected, (Number)actual, precision);
        }
        return expected.equals(actual);
    }

    public static boolean acceptable(Number expected, Number actual, double precision) {
        double zeroBoundary = expected.doubleValue() * (1.0 - precision);
        double infinityBoundary = expected.doubleValue() * (1.0 + precision);
        if (expected.doubleValue() >= 0.0) {
            return actual.doubleValue() >= zeroBoundary && actual.doubleValue() <= infinityBoundary;
        }
        return actual.doubleValue() <= zeroBoundary && actual.doubleValue() >= infinityBoundary;
    }
}

