/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Computable;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Object decode(Object object) {
        if (object instanceof Computable) {
            Computable computable = (Computable)object;
            return computable.getResult();
        }
        return object;
    }

    public static Map<String, ?> decode(Map<FieldName, ?> map) {
        return EvaluatorUtil.decodeKeys(EvaluatorUtil.decodeValues(map));
    }

    public static <V> Map<FieldName, V> encodeKeys(Map<String, V> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(new FieldName((String)entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static <V> Map<String, V> decodeKeys(Map<FieldName, V> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, V>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(((FieldName)entry.getKey()).getValue(), entry.getValue());
        }
        return result;
    }

    public static <K> Map<K, ?> decodeValues(Map<K, ?> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set<Map.Entry<K, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            result.put(entry.getKey(), EvaluatorUtil.decode(entry.getValue()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Map<FieldName, Object>> groupRows(FieldName groupField, List<Map<FieldName, Object>> table) {
        LinkedHashMap groupedRows = Maps.newLinkedHashMap();
        LinkedHashSet<FieldName> keys = Sets.newLinkedHashSet();
        for (int i = 0; i < table.size(); ++i) {
            Map<FieldName, Object> row = table.get(i);
            Object groupValue = row.get(groupField);
            ListMultimap listMultimap = (ListMultimap)groupedRows.get(groupValue);
            if (listMultimap == null) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                groupedRows.put(groupValue, arrayListMultimap);
            }
            Set<Map.Entry<FieldName, Object>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                void var7_8;
                FieldName key = (FieldName)entry.getKey();
                Object value = entry.getValue();
                keys.add(key);
                if (groupField.equals(key)) continue;
                var7_8.put(key, value);
            }
        }
        ArrayList<Map<FieldName, Object>> result = Lists.newArrayList();
        Set entries = groupedRows.entrySet();
        for (Map.Entry entry : entries) {
            LinkedHashMap<FieldName, Object> row = Maps.newLinkedHashMap();
            Object groupValue = entry.getKey();
            ListMultimap listMultimap = (ListMultimap)entry.getValue();
            for (FieldName key : keys) {
                if (groupField.equals(key)) {
                    row.put(key, groupValue);
                    continue;
                }
                row.put(key, listMultimap.get(key));
            }
            result.add(row);
        }
        return result;
    }
}

