/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.jpmml.manager.EntityUtil;
import org.jpmml.manager.HasEntityRegistry;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;

public class AssociationModelManager
extends ModelManager<AssociationModel>
implements HasEntityRegistry<AssociationRule> {
    private AssociationModel associationModel = null;

    public AssociationModelManager() {
    }

    public AssociationModelManager(PMML pmml) {
        this(pmml, AssociationModelManager.find(pmml.getContent(), AssociationModel.class));
    }

    public AssociationModelManager(PMML pmml, AssociationModel associationModel) {
        super(pmml);
        this.associationModel = associationModel;
    }

    @Override
    public String getSummary() {
        return "Association rules model";
    }

    public FieldName getActiveField() {
        List<FieldName> activeFields = this.getActiveFields();
        if (activeFields.size() < 1) {
            throw new InvalidFeatureException("No active fields", this.getMiningSchema());
        }
        if (activeFields.size() > 1) {
            throw new InvalidFeatureException("Too many active fields", this.getMiningSchema());
        }
        return activeFields.get(0);
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public AssociationModel getModel() {
        Preconditions.checkState(this.associationModel != null);
        return this.associationModel;
    }

    public AssociationModel createModel(Double minimumSupport, Double minimumConfidence) {
        Preconditions.checkState(this.associationModel == null);
        this.associationModel = new AssociationModel(new MiningSchema(), MiningFunctionType.ASSOCIATION_RULES, 0, minimumSupport, minimumConfidence, 0, 0, 0);
        this.getModels().add(this.associationModel);
        return this.associationModel;
    }

    public BiMap<String, Item> getItemRegistry() {
        HashBiMap<String, Item> result = HashBiMap.create();
        List<Item> items = this.getItems();
        for (Item item : items) {
            result.put(item.getId(), item);
        }
        return result;
    }

    public BiMap<String, Itemset> getItemsetRegistry() {
        HashBiMap<String, Itemset> result = HashBiMap.create();
        List<Itemset> itemsets = this.getItemsets();
        for (Itemset itemset : itemsets) {
            result.put(itemset.getId(), itemset);
        }
        return result;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        HashBiMap<String, AssociationRule> result = HashBiMap.create();
        List<AssociationRule> associationRules = this.getAssociationRules();
        EntityUtil.putAll(associationRules, result);
        return result;
    }

    public List<Item> getItems() {
        AssociationModel associationModel = this.getModel();
        return associationModel.getItems();
    }

    public List<Itemset> getItemsets() {
        AssociationModel associationModel = this.getModel();
        return associationModel.getItemsets();
    }

    public List<AssociationRule> getAssociationRules() {
        AssociationModel associationModel = this.getModel();
        return associationModel.getAssociationRules();
    }
}

