/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.ClusterClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.ClusteringModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class ClusteringModelEvaluator
extends ClusteringModelManager
implements Evaluator {
    private BiMap<String, Cluster> entities = null;

    public ClusteringModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public ClusteringModelEvaluator(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml, clusteringModel);
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        if (this.entities == null) {
            this.entities = super.getEntityRegistry();
        }
        return this.entities;
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ClusterClassificationMap> predictions;
        ClusteringModel clusteringModel = this.getModel();
        if (!clusteringModel.isScorable()) {
            throw new InvalidResultException(clusteringModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this, arguments);
        MiningFunctionType miningFunction = clusteringModel.getFunctionName();
        switch (miningFunction) {
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(clusteringModel, miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ClusterClassificationMap> evaluateClustering(EvaluationContext context) {
        ClusteringModel clusteringModel = this.getModel();
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case CENTER_BASED: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(clusteringModel, modelClass);
            }
        }
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isDistance(measure)) {
            return this.evaluateDistanceClustering(context);
        }
        if (MeasureUtil.isSimilarity(measure)) {
            return this.evaluateSimilarityClustering(context);
        }
        throw new UnsupportedFeatureException(clusteringModel);
    }

    private Map<FieldName, ClusterClassificationMap> evaluateDistanceClustering(EvaluationContext context) {
        Double adjustment;
        ClusteringModel clusteringModel = this.getModel();
        ClusterClassificationMap result = new ClusterClassificationMap(ClassificationMap.Type.DISTANCE);
        ArrayList<Number> values = Lists.newArrayList();
        ArrayList<Double> fieldWeights = Lists.newArrayList();
        List<ClusteringField> clusteringFields = this.getCenterClusteringFields();
        for (ClusteringField clusteringField : clusteringFields) {
            FieldName name = clusteringField.getField();
            Object value = ExpressionUtil.evaluate(name, context);
            DataType dataType = ParameterUtil.getDataType(value);
            switch (dataType) {
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: {
                    values.add((Number)value);
                    break;
                }
                default: {
                    throw new EvaluationException();
                }
            }
            Double fieldWeight = clusteringField.getFieldWeight();
            fieldWeights.add(fieldWeight);
        }
        MissingValueWeights missingValueWeights = clusteringModel.getMissingValueWeights();
        if (missingValueWeights != null) {
            Array array = missingValueWeights.getArray();
            List<Double> adjustmentValues = ArrayUtil.getRealContent(array);
            if (values.size() != adjustmentValues.size()) {
                throw new EvaluationException();
            }
            double sum = 0.0;
            double nonmissingSum = 0.0;
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                Double adjustmentValue = adjustmentValues.get(i);
                sum += adjustmentValue.doubleValue();
                nonmissingSum += value != null ? adjustmentValue : 0.0;
            }
            adjustment = sum / nonmissingSum;
        } else {
            double sum = 0.0;
            double nonmissingSum = 0.0;
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                sum += 1.0;
                nonmissingSum += value != null ? 1.0 : 0.0;
            }
            adjustment = sum / nonmissingSum;
        }
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        BiMap<Cluster, String> inverseEntities = this.getEntityRegistry().inverse();
        List<Cluster> clusters = this.getClusters();
        for (Cluster cluster : clusters) {
            Array array = cluster.getArray();
            List<? extends Number> clusterValues = ArrayUtil.getNumberContent(array);
            if (values.size() != clusterValues.size()) {
                throw new EvaluationException();
            }
            String id = (String)inverseEntities.get(cluster);
            Double distance = MeasureUtil.evaluateDistance(comparisonMeasure, clusteringFields, values, clusterValues, fieldWeights, adjustment);
            result.put(cluster, id, distance);
        }
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private Map<FieldName, ClusterClassificationMap> evaluateSimilarityClustering(EvaluationContext context) {
        ClusteringModel clusteringModel = this.getModel();
        throw new UnsupportedFeatureException(clusteringModel);
    }

    private List<ClusteringField> getCenterClusteringFields() {
        ArrayList<ClusteringField> result = Lists.newArrayList();
        List<ClusteringField> clusteringFields = this.getClusteringFields();
        block4: for (ClusteringField clusteringField : clusteringFields) {
            ClusteringField.CenterField centerField = clusteringField.getCenterField();
            switch (centerField) {
                case TRUE: {
                    result.add(clusteringField);
                    continue block4;
                }
                case FALSE: {
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException(clusteringField, centerField);
        }
        return result;
    }
}

