/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;

public abstract class EvaluationContext {
    private Deque<Map<FieldName, ?>> stack = Queues.newArrayDeque();
    private List<String> warnings = Lists.newArrayList();

    public EvaluationContext() {
    }

    public EvaluationContext(Map<FieldName, ?> arguments) {
        this.pushFrame(arguments);
    }

    public abstract DerivedField resolveField(FieldName var1);

    public abstract DefineFunction resolveFunction(String var1);

    public Map<FieldName, ?> getArguments() {
        LinkedHashMap<FieldName, ?> result = Maps.newLinkedHashMap();
        Deque<Map<FieldName, ?>> stack = this.getStack();
        Iterator<Map<FieldName, ?>> it = stack.descendingIterator();
        while (it.hasNext()) {
            Map<FieldName, ?> frame = it.next();
            result.putAll(frame);
        }
        return result;
    }

    public Object getArgument(FieldName name) {
        Map.Entry<FieldName, Object> entry = this.getArgumentEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<FieldName, Object> getArgumentEntry(FieldName name) {
        Deque<Map<FieldName, ?>> stack = this.getStack();
        for (Map<FieldName, ?> frame : stack) {
            if (!frame.containsKey(name)) continue;
            AbstractMap.SimpleEntry<FieldName, Object> entry = new AbstractMap.SimpleEntry<FieldName, Object>(name, frame.get(name));
            return entry;
        }
        return null;
    }

    public Map<FieldName, ?> popFrame() {
        return this.getStack().pop();
    }

    public void pushFrame(Map<FieldName, ?> frame) {
        this.getStack().push(frame);
    }

    public void addWarning(String warning) {
        List<String> warnings = this.getWarnings();
        warnings.add(warning);
    }

    Deque<Map<FieldName, ?>> getStack() {
        return this.stack;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

