/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Categories;
import org.dmg.pmml.Category;
import org.dmg.pmml.CumulativeLinkFunctionType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.LinkFunctionType;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PCell;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PPCell;
import org.dmg.pmml.PPMatrix;
import org.dmg.pmml.ParamMatrix;
import org.dmg.pmml.ParameterCell;
import org.dmg.pmml.Predictor;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MatrixUtil;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.GeneralRegressionModelManager;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class GeneralRegressionModelEvaluator
extends GeneralRegressionModelManager
implements Evaluator {
    private BiMap<FieldName, Predictor> factors = null;
    private BiMap<FieldName, Predictor> covariates = null;
    private Map<String, Map<String, Row>> ppMatrixMap = null;
    private Map<String, List<PCell>> paramMatrixMap = null;

    public GeneralRegressionModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
    }

    @Override
    public BiMap<FieldName, Predictor> getFactorRegistry() {
        if (this.factors == null) {
            this.factors = super.getFactorRegistry();
        }
        return this.factors;
    }

    @Override
    public BiMap<FieldName, Predictor> getCovariateRegistry() {
        if (this.covariates == null) {
            this.covariates = super.getCovariateRegistry();
        }
        return this.covariates;
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        return ArgumentUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, Object> predictions;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        if (!generalRegressionModel.isScorable()) {
            throw new InvalidResultException(generalRegressionModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = generalRegressionModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(generalRegressionModel, miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelManagerEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Map<FieldName, FieldValue> arguments = this.getArguments(context);
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.size() != 1 || !ppMatrixMap.containsKey(null)) {
            throw new InvalidFeatureException(this.getPPMatrix());
        }
        Map<String, Row> parameterPredictorRows = ppMatrixMap.get(null);
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        if (paramMatrixMap.size() != 1 || !paramMatrixMap.containsKey(null)) {
            throw new InvalidFeatureException(this.getParamMatrix());
        }
        Iterable parameterCells = paramMatrixMap.get(null);
        Double result = this.computeDotProduct(parameterCells, parameterPredictorRows, arguments);
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case REGRESSION: {
                break;
            }
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(generalRegressionModel, modelType);
            }
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ? extends ClassificationMap> evaluateClassification(ModelManagerEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        FieldName targetField = this.getTargetField();
        DataField dataField = this.getDataField(targetField);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(dataField, opType);
            }
        }
        List<String> targetCategories = ArgumentUtil.getValidValues(dataField);
        if (targetCategories.size() < 2) {
            throw new InvalidFeatureException(dataField);
        }
        Map<FieldName, FieldValue> arguments = this.getArguments(context);
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        final Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        String targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        switch (modelType) {
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                Predicate<String> filter = new Predicate<String>(){

                    @Override
                    public boolean apply(String string) {
                        return !paramMatrixMap.containsKey(string);
                    }
                };
                LinkedHashSet<String> targetReferenceCategories = Sets.newLinkedHashSet(Iterables.filter(targetCategories, filter));
                if (targetReferenceCategories.size() != 1) {
                    throw new InvalidFeatureException(this.getParamMatrix());
                }
                targetReferenceCategory = Iterables.getOnlyElement(targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(generalRegressionModel, modelType);
            }
        }
        if (targetReferenceCategory != null && targetCategories.remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        ClassificationMap result = new ClassificationMap(ClassificationMap.Type.PROBABILITY);
        Double previousValue = null;
        for (int i = 0; i < targetCategories.size(); ++i) {
            Double value;
            String targetCategory = targetCategories.get(i);
            if (i < targetCategories.size() - 1) {
                Iterable parameterCells;
                Map<String, Row> parameterPredictorRow = ppMatrixMap.get(targetCategory);
                if (parameterPredictorRow == null) {
                    parameterPredictorRow = ppMatrixMap.get(null);
                }
                if (parameterPredictorRow == null) {
                    throw new InvalidFeatureException(this.getPPMatrix());
                }
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        throw new InvalidFeatureException(this.getParamMatrix());
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            throw new InvalidFeatureException(this.getParamMatrix());
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            throw new InvalidFeatureException(this.getParamMatrix());
                        }
                        parameterCells = Iterables.concat(interceptCells, parameterCells);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(generalRegressionModel, modelType);
                    }
                }
                value = this.computeDotProduct(parameterCells, parameterPredictorRow, arguments);
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(value);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(generalRegressionModel, modelType);
                    }
                }
            } else {
                value = 0.0;
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(value);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = 1.0;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(generalRegressionModel, modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERAL_LINEAR: 
                case GENERALIZED_LINEAR: 
                case MULTINOMIAL_LOGISTIC: {
                    result.put(targetCategory, value);
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    if (previousValue == null) {
                        result.put(targetCategory, value);
                        break;
                    }
                    result.put(targetCategory, value - previousValue);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(generalRegressionModel, modelType);
                }
            }
            previousValue = value;
        }
        switch (modelType) {
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                result.normalizeValues();
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(generalRegressionModel, modelType);
            }
        }
        return TargetUtil.evaluateClassification(Collections.singletonMap(targetField, result), context);
    }

    private Double computeDotProduct(Iterable<PCell> parameterCells, Map<String, Row> parameterPredictorRows, Map<FieldName, FieldValue> arguments) {
        double sum = 0.0;
        for (PCell parameterCell : parameterCells) {
            Row parameterPredictorRow = parameterPredictorRows.get(parameterCell.getParameterName());
            Double x = parameterPredictorRow != null ? parameterPredictorRow.evaluate(arguments) : Double.valueOf(1.0);
            if (x == null) continue;
            sum += x * parameterCell.getBeta();
        }
        return sum;
    }

    private Double computeLink(Double value, EvaluationContext context) {
        Integer b;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Double a = GeneralRegressionModelEvaluator.getValue(DataType.DOUBLE, context.getArgument(generalRegressionModel.getOffsetVariable()), generalRegressionModel.getOffsetValue());
        if (a == null) {
            a = 0.0;
        }
        if ((b = GeneralRegressionModelEvaluator.getValue(DataType.INTEGER, context.getArgument(generalRegressionModel.getTrialsVariable()), generalRegressionModel.getTrialsValue())) == null) {
            b = 1;
        }
        Double d = generalRegressionModel.getLinkParameter();
        LinkFunctionType linkFunction = generalRegressionModel.getLinkFunction();
        if (linkFunction == null) {
            throw new InvalidFeatureException(generalRegressionModel);
        }
        switch (linkFunction) {
            case ODDSPOWER: 
            case POWER: {
                if (d != null) break;
                throw new InvalidFeatureException(generalRegressionModel);
            }
        }
        switch (linkFunction) {
            case CLOGLOG: {
                return (1.0 - Math.exp(-Math.exp(value + a))) * (double)b.intValue();
            }
            case IDENTITY: {
                return (value + a) * (double)b.intValue();
            }
            case LOG: {
                return Math.exp(value + a) * (double)b.intValue();
            }
            case LOGC: {
                return (1.0 - Math.exp(value + a)) * (double)b.intValue();
            }
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a))) * (double)b.intValue();
            }
            case ODDSPOWER: {
                if (d < 0.0 || d > 0.0) {
                    return 1.0 / (1.0 + Math.pow(1.0 + d * (value + a), -(1.0 / d))) * (double)b.intValue();
                }
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case POWER: {
                if (d < 0.0 || d > 0.0) {
                    return Math.pow(value + a, 1.0 / d) * (double)b.intValue();
                }
                return Math.exp(value + a) * (double)b.intValue();
            }
        }
        throw new UnsupportedFeatureException(generalRegressionModel, linkFunction);
    }

    private Double computeCumulativeLink(Double value, EvaluationContext context) {
        CumulativeLinkFunctionType cumulativeLinkFunction;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Double a = GeneralRegressionModelEvaluator.getValue(DataType.DOUBLE, context.getArgument(generalRegressionModel.getOffsetVariable()), generalRegressionModel.getOffsetValue());
        if (a == null) {
            a = 0.0;
        }
        if ((cumulativeLinkFunction = generalRegressionModel.getCumulativeLink()) == null) {
            throw new InvalidFeatureException(generalRegressionModel);
        }
        switch (cumulativeLinkFunction) {
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a)));
            }
            case CLOGLOG: {
                return 1.0 - Math.exp(-Math.exp(value + a));
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a)));
            }
            case CAUCHIT: {
                return 0.5 + 0.3183098861837907 * Math.atan(value + a);
            }
        }
        throw new UnsupportedFeatureException(generalRegressionModel, cumulativeLinkFunction);
    }

    private Map<FieldName, FieldValue> getArguments(EvaluationContext context) {
        BiMap<FieldName, Predictor> factors = this.getFactorRegistry();
        BiMap<FieldName, Predictor> covariates = this.getCovariateRegistry();
        LinkedHashMap<FieldName, FieldValue> result = Maps.newLinkedHashMap();
        Iterable<Predictor> predictors = Iterables.concat(factors.values(), covariates.values());
        for (Predictor predictor : predictors) {
            FieldName name = predictor.getName();
            result.put(name, context.getArgument(name));
        }
        return result;
    }

    private Map<String, Map<String, Row>> getPPMatrixMap() {
        if (this.ppMatrixMap == null) {
            this.ppMatrixMap = this.parsePPMatrix();
        }
        return this.ppMatrixMap;
    }

    private Map<String, Map<String, Row>> parsePPMatrix() {
        Function<List<PPCell>, Row> function = new Function<List<PPCell>, Row>(){
            private BiMap<FieldName, Predictor> factors;
            private BiMap<FieldName, Predictor> covariates;
            {
                this.factors = GeneralRegressionModelEvaluator.this.getFactorRegistry();
                this.covariates = GeneralRegressionModelEvaluator.this.getCovariateRegistry();
            }

            @Override
            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    FieldName name = ppCell.getPredictorName();
                    Predictor factor = (Predictor)this.factors.get(name);
                    if (factor != null) {
                        result.addFactor(ppCell, factor);
                        continue;
                    }
                    Predictor covariate = (Predictor)this.covariates.get(name);
                    if (covariate != null) {
                        result.addCovariate(ppCell);
                        continue;
                    }
                    throw new InvalidFeatureException(ppCell);
                }
                return result;
            }
        };
        PPMatrix ppMatrix = this.getPPMatrix();
        ListMultimap<String, PPCell> targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap<String, Map<String, Row>> result = Maps.newLinkedHashMap();
        Set<Map.Entry<String, List<PPCell>>> targetCategoryEntries = GeneralRegressionModelEvaluator.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap predictorMap = Maps.newLinkedHashMap();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = GeneralRegressionModelEvaluator.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put(entry2.getKey(), function.apply((List<PPCell>)entry2.getValue()));
            }
            result.put((String)entry.getKey(), predictorMap);
        }
        return result;
    }

    private Map<String, List<PCell>> getParamMatrixMap() {
        if (this.paramMatrixMap == null) {
            this.paramMatrixMap = this.parseParamMatrix();
        }
        return this.paramMatrixMap;
    }

    private Map<String, List<PCell>> parseParamMatrix() {
        ParamMatrix paramMatrix = this.getParamMatrix();
        ListMultimap<String, PCell> targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return GeneralRegressionModelEvaluator.asMap(targetCategoryCells);
    }

    private static <V extends Number> V getValue(DataType dataType, FieldValue argumentValue, V xmlValue) {
        if (argumentValue != null) {
            return (V)argumentValue.asNumber();
        }
        return xmlValue;
    }

    private static <C extends ParameterCell> Map<String, List<C>> asMap(ListMultimap<String, C> multimap) {
        return multimap.asMap();
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        Function function = new Function<C, String>(){

            @Override
            public String apply(C cell) {
                return ((ParameterCell)cell).getParameterName();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByTargetCategory(List<C> cells) {
        Function function = new Function<C, String>(){

            @Override
            public String apply(C cell) {
                return ((ParameterCell)cell).getTargetCategory();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupCells(List<C> cells, Function<C, String> function) {
        ArrayListMultimap<String, ParameterCell> result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply(cell), cell);
        }
        return result;
    }

    private static class Row {
        private List<FactorHandler> factorHandlers = Lists.newArrayList();
        private List<CovariateHandler> covariateHandlers = Lists.newArrayList();

        private Row() {
        }

        public Double evaluate(Map<FieldName, FieldValue> arguments) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            if (factorHandlers.isEmpty() && covariateHandlers.isEmpty()) {
                return 1.0;
            }
            Double factorProduct = Row.computeProduct(factorHandlers, arguments);
            Double covariateProduct = Row.computeProduct(covariateHandlers, arguments);
            if (covariateHandlers.isEmpty()) {
                return factorProduct;
            }
            if (factorHandlers.isEmpty()) {
                return covariateProduct;
            }
            if (factorProduct != null && covariateProduct != null) {
                return factorProduct * covariateProduct;
            }
            return null;
        }

        public void addFactor(PPCell ppCell, Predictor predictor) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            Matrix matrix = predictor.getMatrix();
            if (matrix != null) {
                Categories categories = predictor.getCategories();
                if (categories == null) {
                    throw new UnsupportedFeatureException(predictor);
                }
                Function<Category, String> function = new Function<Category, String>(){

                    @Override
                    public String apply(Category category) {
                        return category.getValue();
                    }
                };
                List<String> values = Lists.transform(categories.getCategories(), function);
                factorHandlers.add(new ContrastMatrixHandler(ppCell, matrix, values));
            } else {
                factorHandlers.add(new FactorHandler(ppCell));
            }
        }

        private void addCovariate(PPCell ppCell) {
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            covariateHandlers.add(new CovariateHandler(ppCell));
        }

        public List<FactorHandler> getFactorHandlers() {
            return this.factorHandlers;
        }

        public List<CovariateHandler> getCovariateHandlers() {
            return this.covariateHandlers;
        }

        private static Double computeProduct(List<? extends PredictorHandler> predictorHandlers, Map<FieldName, FieldValue> arguments) {
            Double result = null;
            for (PredictorHandler predictorHandler : predictorHandlers) {
                FieldValue value = arguments.get(predictorHandler.getPredictorName());
                if (value == null) {
                    return null;
                }
                if (result == null) {
                    result = predictorHandler.evaluate(value);
                    continue;
                }
                result = result * predictorHandler.evaluate(value);
            }
            return result;
        }

        private class CovariateHandler
        extends PredictorHandler {
            private CovariateHandler(PPCell ppCell) {
                super(ppCell);
            }

            @Override
            public Double evaluate(FieldValue value) {
                return Math.pow(value.asNumber().doubleValue(), this.getMultiplicity());
            }

            public Double getMultiplicity() {
                PPCell ppCell = this.getPPCell();
                return Double.valueOf(ppCell.getValue());
            }
        }

        private class ContrastMatrixHandler
        extends FactorHandler {
            private Matrix matrix;
            private List<String> categories;

            private ContrastMatrixHandler(PPCell ppCell, Matrix matrix, List<String> categories) {
                super(ppCell);
                this.matrix = null;
                this.categories = null;
                this.setMatrix(matrix);
                this.setCategories(categories);
            }

            @Override
            public Double evaluate(FieldValue value) {
                Matrix matrix = this.getMatrix();
                int row = this.getIndex(value);
                int column = this.getIndex(this.getCategory());
                if (row < 0 || column < 0) {
                    throw new EvaluationException();
                }
                Number result = MatrixUtil.getElementAt(matrix, row + 1, column + 1);
                if (result == null) {
                    throw new EvaluationException();
                }
                return result.doubleValue();
            }

            public int getIndex(FieldValue value) {
                List<String> categories = this.getCategories();
                for (int i = 0; i < categories.size(); ++i) {
                    String category = categories.get(i);
                    boolean equals = value.equalsString(category);
                    if (!equals) continue;
                    return i;
                }
                return -1;
            }

            public int getIndex(String category) {
                List<String> categories = this.getCategories();
                return categories.indexOf(category);
            }

            public Matrix getMatrix() {
                return this.matrix;
            }

            private void setMatrix(Matrix matrix) {
                this.matrix = matrix;
            }

            public List<String> getCategories() {
                return this.categories;
            }

            private void setCategories(List<String> categories) {
                this.categories = categories;
            }
        }

        private class FactorHandler
        extends PredictorHandler {
            private FactorHandler(PPCell ppCell) {
                super(ppCell);
            }

            @Override
            public Double evaluate(FieldValue value) {
                boolean equals = value.equalsString(this.getCategory());
                return equals ? 1.0 : 0.0;
            }

            public String getCategory() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getValue();
            }
        }

        private abstract class PredictorHandler {
            private PPCell ppCell = null;

            private PredictorHandler(PPCell ppCell) {
                this.setPPCell(ppCell);
            }

            public abstract Double evaluate(FieldValue var1);

            public FieldName getPredictorName() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getPredictorName();
            }

            public PPCell getPPCell() {
                return this.ppCell;
            }

            private void setPPCell(PPCell ppCell) {
                this.ppCell = ppCell;
            }
        }
    }
}

