/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import org.dmg.pmml.CovariateList;
import org.dmg.pmml.FactorList;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PPMatrix;
import org.dmg.pmml.ParamMatrix;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.PredictorList;
import org.jpmml.manager.ModelManager;

public class GeneralRegressionModelManager
extends ModelManager<GeneralRegressionModel> {
    private GeneralRegressionModel generalRegressionModel = null;

    public GeneralRegressionModelManager() {
    }

    public GeneralRegressionModelManager(PMML pmml) {
        this(pmml, GeneralRegressionModelManager.find(pmml.getContent(), GeneralRegressionModel.class));
    }

    public GeneralRegressionModelManager(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml);
        this.generalRegressionModel = generalRegressionModel;
    }

    @Override
    public String getSummary() {
        return "General regression";
    }

    @Override
    public GeneralRegressionModel getModel() {
        Preconditions.checkState(this.generalRegressionModel != null);
        return this.generalRegressionModel;
    }

    public BiMap<FieldName, Predictor> getFactorRegistry() {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        FactorList predictorList = generalRegressionModel.getFactorList();
        return GeneralRegressionModelManager.toPredictorRegistry(predictorList);
    }

    public BiMap<FieldName, Predictor> getCovariateRegistry() {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        CovariateList predictorList = generalRegressionModel.getCovariateList();
        return GeneralRegressionModelManager.toPredictorRegistry(predictorList);
    }

    public PPMatrix getPPMatrix() {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        return generalRegressionModel.getPPMatrix();
    }

    public ParamMatrix getParamMatrix() {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        return generalRegressionModel.getParamMatrix();
    }

    private static BiMap<FieldName, Predictor> toPredictorRegistry(PredictorList predictorList) {
        HashBiMap<FieldName, Predictor> result = HashBiMap.create();
        List<Predictor> predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            result.put(predictor.getName(), predictor);
        }
        return result;
    }
}

