/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeCheckException;

public class TypeUtil {
    private static final DataType[] inheritanceSequence = new DataType[]{DataType.STRING, DataType.DOUBLE, DataType.FLOAT, DataType.INTEGER};
    private static final LocalDate YEAR_1960 = new LocalDate(1960, 1, 1);
    private static final LocalDate YEAR_1970 = new LocalDate(1970, 1, 1);
    private static final LocalDate YEAR_1980 = new LocalDate(1980, 1, 1);

    private TypeUtil() {
    }

    public static boolean equals(DataType dataType, Object left, Object right) {
        return TypeUtil.cast(dataType, left).equals(TypeUtil.cast(dataType, right));
    }

    public static int compare(DataType dataType, Object left, Object right) {
        return ((Comparable)TypeUtil.cast(dataType, left)).compareTo(TypeUtil.cast(dataType, right));
    }

    public static Object parseOrCast(DataType dataType, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return TypeUtil.parse(dataType, string);
        }
        return TypeUtil.cast(dataType, value);
    }

    public static Object parse(DataType dataType, String value) {
        switch (dataType) {
            case STRING: {
                return value;
            }
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case DATE: {
                return TypeUtil.parseDate(value);
            }
            case TIME: {
                return TypeUtil.parseTime(value);
            }
            case DATE_TIME: {
                return TypeUtil.parseDateTime(value);
            }
            case DATE_DAYS_SINCE_1960: {
                return new DaysSinceDate(YEAR_1960, TypeUtil.parseDate(value));
            }
            case DATE_DAYS_SINCE_1970: {
                return new DaysSinceDate(YEAR_1970, TypeUtil.parseDate(value));
            }
            case DATE_DAYS_SINCE_1980: {
                return new DaysSinceDate(YEAR_1980, TypeUtil.parseDate(value));
            }
            case TIME_SECONDS: {
                return new SecondsSinceMidnight(TypeUtil.parseSeconds(value));
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return new SecondsSinceDate(YEAR_1960, TypeUtil.parseDateTime(value));
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return new SecondsSinceDate(YEAR_1970, TypeUtil.parseDateTime(value));
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return new SecondsSinceDate(YEAR_1980, TypeUtil.parseDateTime(value));
            }
        }
        throw new EvaluationException();
    }

    private static LocalDate parseDate(String value) {
        return LocalDate.parse(value);
    }

    private static LocalTime parseTime(String value) {
        return LocalTime.parse(value);
    }

    private static LocalDateTime parseDateTime(String value) {
        return LocalDateTime.parse(value);
    }

    private static Seconds parseSeconds(String value) {
        DateTimeFormatter format = SecondsSinceMidnight.getFormat();
        DateTimeParser parser = format.getParser();
        DateTimeParserBucket bucket = new DateTimeParserBucket(0L, null, null);
        bucket.setZone(null);
        int result = parser.parseInto(bucket, value, 0);
        if (result >= 0 && result >= value.length()) {
            long millis = bucket.computeMillis(true);
            return Seconds.seconds((int)(millis / 1000L));
        }
        throw new IllegalArgumentException(value);
    }

    public static String format(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        throw new EvaluationException();
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof LocalTime) {
            return DataType.TIME;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATE_TIME;
        }
        if (value instanceof DaysSinceDate) {
            DaysSinceDate period = (DaysSinceDate)value;
            LocalDate epoch = period.getEpoch();
            if (epoch.equals(YEAR_1960)) {
                return DataType.DATE_DAYS_SINCE_1960;
            }
            if (epoch.equals(YEAR_1970)) {
                return DataType.DATE_DAYS_SINCE_1970;
            }
            if (epoch.equals(YEAR_1980)) {
                return DataType.DATE_DAYS_SINCE_1980;
            }
        } else {
            if (value instanceof SecondsSinceMidnight) {
                return DataType.TIME_SECONDS;
            }
            if (value instanceof SecondsSinceDate) {
                SecondsSinceDate period = (SecondsSinceDate)value;
                LocalDate epoch = period.getEpoch();
                if (epoch.equals(YEAR_1960)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1960;
                }
                if (epoch.equals(YEAR_1970)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1970;
                }
                if (epoch.equals(YEAR_1980)) {
                    return DataType.DATE_TIME_SECONDS_SINCE_1980;
                }
            }
        }
        throw new EvaluationException();
    }

    public static DataType getResultDataType(DataType left, DataType right) {
        if (left.equals((Object)right)) {
            return left;
        }
        for (int i = 0; i < inheritanceSequence.length; ++i) {
            DataType dataType = inheritanceSequence[i];
            if (!dataType.equals((Object)left) && !dataType.equals((Object)right)) continue;
            return dataType;
        }
        throw new EvaluationException();
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: 
            case DATE_DAYS_SINCE_1960: 
            case DATE_DAYS_SINCE_1970: 
            case DATE_DAYS_SINCE_1980: 
            case DATE_TIME_SECONDS_SINCE_1960: 
            case DATE_TIME_SECONDS_SINCE_1970: 
            case DATE_TIME_SECONDS_SINCE_1980: 
            case DATE_DAYS_SINCE_0: 
            case DATE_TIME_SECONDS_SINCE_0: {
                return OpType.ORDINAL;
            }
        }
        throw new EvaluationException();
    }

    public static Object cast(DataType dataType, Object value) {
        switch (dataType) {
            case STRING: {
                return TypeUtil.toString(value);
            }
            case INTEGER: {
                return TypeUtil.toInteger(value);
            }
            case FLOAT: {
                return TypeUtil.toFloat(value);
            }
            case DOUBLE: {
                return TypeUtil.toDouble(value);
            }
            case BOOLEAN: {
                return TypeUtil.toBoolean(value);
            }
            case DATE: {
                return TypeUtil.toDate(value);
            }
            case TIME: {
                return TypeUtil.toTime(value);
            }
            case DATE_TIME: {
                return TypeUtil.toDateTime(value);
            }
            case DATE_DAYS_SINCE_1960: {
                return TypeUtil.toDaysSinceDate(value, YEAR_1960);
            }
            case DATE_DAYS_SINCE_1970: {
                return TypeUtil.toDaysSinceDate(value, YEAR_1970);
            }
            case DATE_DAYS_SINCE_1980: {
                return TypeUtil.toDaysSinceDate(value, YEAR_1980);
            }
            case TIME_SECONDS: {
                return TypeUtil.toSecondsSinceMidnight(value);
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return TypeUtil.toSecondsSinceDate(value, YEAR_1960);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return TypeUtil.toSecondsSinceDate(value, YEAR_1970);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return TypeUtil.toSecondsSinceDate(value, YEAR_1980);
            }
        }
        throw new EvaluationException();
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Integer) {
            Number number = (Number)value;
            return number.toString();
        }
        throw new TypeCheckException(DataType.STRING, value);
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new TypeCheckException(DataType.INTEGER, value);
    }

    private static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Integer) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        throw new TypeCheckException(DataType.FLOAT, value);
    }

    private static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float || value instanceof Integer) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new TypeCheckException(DataType.DOUBLE, value);
    }

    private static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new TypeCheckException(DataType.BOOLEAN, value);
    }

    private static LocalDate toDate(Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        throw new TypeCheckException(DataType.DATE, value);
    }

    private static LocalTime toTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        throw new TypeCheckException(DataType.TIME, value);
    }

    private static LocalDateTime toDateTime(Object value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new TypeCheckException(DataType.DATE_TIME, value);
    }

    private static DaysSinceDate toDaysSinceDate(Object value, LocalDate epoch) {
        DaysSinceDate period;
        if (value instanceof DaysSinceDate && (period = (DaysSinceDate)value).getEpoch().equals(epoch)) {
            return period;
        }
        throw new TypeCheckException(DataType.DATE_DAYS_SINCE_1970, value);
    }

    private static SecondsSinceMidnight toSecondsSinceMidnight(Object value) {
        if (value instanceof SecondsSinceMidnight) {
            return (SecondsSinceMidnight)value;
        }
        throw new TypeCheckException(DataType.TIME_SECONDS, value);
    }

    private static SecondsSinceDate toSecondsSinceDate(Object value, LocalDate epoch) {
        SecondsSinceDate period;
        if (value instanceof SecondsSinceDate && (period = (SecondsSinceDate)value).getEpoch().equals(epoch)) {
            return period;
        }
        throw new TypeCheckException(DataType.DATE_TIME_SECONDS_SINCE_1970, value);
    }

    public static DataType getConstantDataType(String string) {
        try {
            if (string.indexOf(46) > -1) {
                Float.parseFloat(string);
                return DataType.FLOAT;
            }
            Integer.parseInt(string);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }
}

