/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.collect.BiMap;
import java.util.List;
import org.dmg.pmml.Entity;
import org.jpmml.manager.InvalidFeatureException;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <E extends Entity> void put(E entity, BiMap<String, E> map) {
        String id = entity.getId();
        if (id == null || map.containsKey(id)) {
            throw new InvalidFeatureException(entity);
        }
        map.put(id, entity);
    }

    public static <E extends Entity> void putAll(List<E> entities, BiMap<String, E> map) {
        int i = 0;
        int j = 1;
        while (i < entities.size()) {
            Entity entity = (Entity)entities.get(i);
            String id = entity.getId();
            if (id == null) {
                id = String.valueOf(j);
            }
            if (map.containsKey(id)) {
                throw new InvalidFeatureException(entity);
            }
            map.put(id, entity);
            ++i;
            ++j;
        }
    }
}

