/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.jpmml.manager.Consumer;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.PMMLManager;

public abstract class ModelManager<M extends Model>
extends PMMLManager
implements Consumer {
    public ModelManager() {
    }

    public ModelManager(PMML pmml) {
        super(pmml);
    }

    public abstract M getModel();

    public void addField(FieldName name, String displayName, OpType opType, DataType dataType, FieldUsageType fieldUsageType) {
        this.addDataField(name, displayName, opType, dataType);
        this.addMiningField(name, fieldUsageType);
    }

    @Override
    public List<FieldName> getActiveFields() {
        return this.getMiningFields(FieldUsageType.ACTIVE);
    }

    @Override
    public List<FieldName> getGroupFields() {
        return this.getMiningFields(FieldUsageType.GROUP);
    }

    @Override
    public FieldName getTargetField() {
        List<FieldName> predictedFields = this.getPredictedFields();
        if (predictedFields.size() < 1) {
            return null;
        }
        if (predictedFields.size() > 1) {
            throw new InvalidFeatureException("Too many predicted fields", this.getMiningSchema());
        }
        return predictedFields.get(0);
    }

    @Override
    public List<FieldName> getPredictedFields() {
        return this.getMiningFields(FieldUsageType.PREDICTED);
    }

    public List<FieldName> getMiningFields(FieldUsageType fieldUsageType) {
        ArrayList<FieldName> result = Lists.newArrayList();
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        for (MiningField miningField : miningFields) {
            if (!miningField.getUsageType().equals((Object)fieldUsageType)) continue;
            result.add(miningField.getName());
        }
        return result;
    }

    @Override
    public MiningField getMiningField(FieldName name) {
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        return ModelManager.find(miningFields, name);
    }

    public MiningField addMiningField(FieldName name, FieldUsageType usageType) {
        MiningField miningField = new MiningField(name);
        miningField.setUsageType(usageType);
        List<MiningField> miningFields = this.getMiningSchema().getMiningFields();
        miningFields.add(miningField);
        return miningField;
    }

    @Override
    public List<FieldName> getOutputFields() {
        ArrayList<FieldName> result = Lists.newArrayList();
        Output output = this.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            result.add(outputField.getName());
        }
        return result;
    }

    @Override
    public OutputField getOutputField(FieldName name) {
        Output output = this.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        return ModelManager.find(outputFields, name);
    }

    @Override
    public DerivedField resolveField(FieldName name) {
        LocalTransformations localTransformations = this.getOrCreateLocalTransformations();
        List<DerivedField> derivedFields = localTransformations.getDerivedFields();
        DerivedField derivedField = ModelManager.find(derivedFields, name);
        if (derivedField == null) {
            derivedField = super.resolveField(name);
        }
        return derivedField;
    }

    public Target getTarget(FieldName name) {
        Targets targetDictionary = this.getOrCreateTargets();
        List<Target> targets = targetDictionary.getTargets();
        for (Target target : targets) {
            if (!target.getField().equals(name)) continue;
            return target;
        }
        return null;
    }

    public MiningSchema getMiningSchema() {
        M model = this.getModel();
        return ((Model)model).getMiningSchema();
    }

    public LocalTransformations getOrCreateLocalTransformations() {
        M model = this.getModel();
        LocalTransformations localTransformations = ((Model)model).getLocalTransformations();
        if (localTransformations == null) {
            localTransformations = new LocalTransformations();
            ((Model)model).setLocalTransformations(localTransformations);
        }
        return localTransformations;
    }

    public Output getOrCreateOutput() {
        M model = this.getModel();
        Output output = ((Model)model).getOutput();
        if (output == null) {
            output = new Output();
            ((Model)model).setOutput(output);
        }
        return output;
    }

    public Targets getOrCreateTargets() {
        M model = this.getModel();
        Targets targets = ((Model)model).getTargets();
        if (targets == null) {
            targets = new Targets();
            ((Model)model).setTargets(targets);
        }
        return targets;
    }
}

