/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Attribute;
import org.dmg.pmml.Characteristic;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Scorecard;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.Score;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ScorecardManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class ScorecardEvaluator
extends ScorecardManager
implements Evaluator {
    public ScorecardEvaluator(PMML pmml) {
        super(pmml);
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        return ArgumentUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ?> predictions;
        Scorecard scorecard = this.getModel();
        if (!scorecard.isScorable()) {
            throw new InvalidResultException(scorecard);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = scorecard.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(scorecard, miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelManagerEvaluationContext context) {
        Scorecard scorecard = this.getModel();
        double value = 0.0;
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        LinkedHashMap<String, Double> reasonCodePoints = Maps.newLinkedHashMap();
        List<Characteristic> characteristics = this.getCharacteristics();
        block4: for (Characteristic characteristic : characteristics) {
            Double baselineScore = characteristic.getBaselineScore();
            if (baselineScore == null) {
                baselineScore = scorecard.getBaselineScore();
            }
            if (useReasonCodes && baselineScore == null) {
                throw new InvalidFeatureException(characteristic);
            }
            List<Attribute> attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                Double difference;
                Predicate predicate = attribute.getPredicate();
                if (predicate == null) {
                    throw new InvalidFeatureException(attribute);
                }
                Boolean status = PredicateUtil.evaluate(predicate, context);
                if (status == null || !status.booleanValue()) continue;
                Double partialScore = attribute.getPartialScore();
                if (partialScore == null) {
                    throw new InvalidFeatureException(attribute);
                }
                value += partialScore.doubleValue();
                String reasonCode = attribute.getReasonCode();
                if (reasonCode == null) {
                    reasonCode = characteristic.getReasonCode();
                }
                if (!useReasonCodes) continue block4;
                if (reasonCode == null) {
                    throw new InvalidFeatureException(attribute);
                }
                Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
                switch (reasonCodeAlgorithm) {
                    case POINTS_ABOVE: {
                        difference = partialScore - baselineScore;
                        break;
                    }
                    case POINTS_BELOW: {
                        difference = baselineScore - partialScore;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(scorecard, reasonCodeAlgorithm);
                    }
                }
                Double points = (Double)reasonCodePoints.get(reasonCode);
                if (points == null) {
                    points = 0.0;
                }
                reasonCodePoints.put(reasonCode, points + difference);
                continue block4;
            }
        }
        Map<FieldName, ? extends Number> result = TargetUtil.evaluateRegression(value, context);
        if (useReasonCodes) {
            Map.Entry entry;
            ArrayList entries = Lists.newArrayList(reasonCodePoints.entrySet());
            Comparator<Map.Entry<String, Double>> comparator = new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> left, Map.Entry<String, Double> right) {
                    return -left.getValue().compareTo(right.getValue());
                }
            };
            Collections.sort(entries, comparator);
            ArrayList<String> reasonCodes = Lists.newArrayList();
            Iterator<Attribute> i$ = entries.iterator();
            while (i$.hasNext() && !((Double)(entry = (Map.Entry)((Object)i$.next())).getValue() < 0.0)) {
                reasonCodes.add((String)entry.getKey());
            }
            Map.Entry<FieldName, ? extends Number> resultEntry = Iterables.getOnlyElement(result.entrySet());
            return Collections.singletonMap(resultEntry.getKey(), new Score(resultEntry.getValue(), reasonCodes));
        }
        return result;
    }
}

