/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.True;
import org.jpmml.manager.EntityUtil;
import org.jpmml.manager.HasEntityRegistry;
import org.jpmml.manager.ModelManager;

public class TreeModelManager
extends ModelManager<TreeModel>
implements HasEntityRegistry<Node> {
    private TreeModel treeModel = null;

    public TreeModelManager() {
    }

    public TreeModelManager(PMML pmml) {
        this(pmml, TreeModelManager.find(pmml.getContent(), TreeModel.class));
    }

    public TreeModelManager(PMML pmml, TreeModel treeModel) {
        super(pmml);
        this.treeModel = treeModel;
    }

    @Override
    public String getSummary() {
        return "Tree model";
    }

    @Override
    public TreeModel getModel() {
        Preconditions.checkState(this.treeModel != null);
        return this.treeModel;
    }

    public TreeModel createModel(MiningFunctionType miningFunction) {
        Preconditions.checkState(this.treeModel == null);
        Node root = new Node();
        root.setPredicate(new True());
        this.treeModel = new TreeModel(new MiningSchema(), root, miningFunction);
        this.getModels().add(this.treeModel);
        return this.treeModel;
    }

    public Node getRoot() {
        TreeModel treeModel = this.getModel();
        return treeModel.getNode();
    }

    @Override
    public BiMap<String, Node> getEntityRegistry() {
        HashBiMap<String, Node> result = HashBiMap.create();
        TreeModelManager.collectNodes(this.getRoot(), result);
        return result;
    }

    public Node addNode(String id, Predicate predicate) {
        return this.addNode(this.getRoot(), id, predicate);
    }

    public Node addNode(Node parentNode, String id, Predicate predicate) {
        Node node = new Node();
        node.setId(id);
        node.setPredicate(predicate);
        parentNode.getNodes().add(node);
        return node;
    }

    public ScoreDistribution getOrAddScoreDistribution(Node node, String value) {
        List<ScoreDistribution> scoreDistributions = node.getScoreDistributions();
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            if (!scoreDistribution.getValue().equals(value)) continue;
            return scoreDistribution;
        }
        ScoreDistribution scoreDistribution = new ScoreDistribution(value, 0.0);
        scoreDistributions.add(scoreDistribution);
        return scoreDistribution;
    }

    private static void collectNodes(Node node, BiMap<String, Node> map) {
        EntityUtil.put(node, map);
        List<Node> children = node.getNodes();
        for (Node child : children) {
            TreeModelManager.collectNodes(child, map);
        }
    }
}

