/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dmg.pmml.ImportFilter;
import org.dmg.pmml.ObjectFactory;
import org.dmg.pmml.PMML;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IOUtil {
    private static JAXBContext jaxbCtx = null;

    private IOUtil() {
    }

    public static Source createImportSource(InputSource source) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        ImportFilter filter = new ImportFilter(reader);
        return new SAXSource(filter, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PMML unmarshal(File file) throws IOException, SAXException, JAXBException {
        FileInputStream is = new FileInputStream(file);
        try {
            PMML pMML = IOUtil.unmarshal(is);
            return pMML;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static PMML unmarshal(InputStream is) throws SAXException, JAXBException {
        return IOUtil.unmarshal(new InputSource(is));
    }

    public static PMML unmarshal(InputSource source) throws SAXException, JAXBException {
        return (PMML)IOUtil.unmarshal(IOUtil.createImportSource(source));
    }

    public static Object unmarshal(Source source) throws JAXBException {
        Unmarshaller unmarshaller = IOUtil.getJAXBContext().createUnmarshaller();
        return unmarshaller.unmarshal(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshal(PMML pmml, File file) throws IOException, JAXBException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            IOUtil.marshal(pmml, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static void marshal(PMML pmml, OutputStream os) throws JAXBException {
        IOUtil.marshal(pmml, new StreamResult(os));
    }

    public static void marshal(PMML pmml, Result result) throws JAXBException {
        Marshaller marshaller = IOUtil.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)pmml, result);
    }

    private static JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbCtx == null) {
            jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        return jaxbCtx;
    }
}

