/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Target;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.ClusterClassificationMap;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ClusteringModelEvaluator
extends ModelEvaluator<ClusteringModel>
implements HasEntityRegistry<Cluster> {
    private static final LoadingCache<Cluster, List<FieldValue>> clusterValueCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Cluster, List<FieldValue>>(){

        @Override
        public List<FieldValue> load(Cluster cluster) {
            Array array = cluster.getArray();
            ArrayList<FieldValue> result = Lists.newArrayList();
            List<? extends Number> values = ArrayUtil.getNumberContent(array);
            for (Number number : values) {
                result.add(FieldValueUtil.create(number));
            }
            return result;
        }
    });
    private static final LoadingCache<Cluster, BitSet> clusterFlagCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Cluster, BitSet>(){

        @Override
        public BitSet load(Cluster cluster) {
            List values = (List)CacheUtil.getValue(cluster, clusterValueCache);
            return MeasureUtil.toBitSet(values);
        }
    });
    private static final LoadingCache<ClusteringModel, BiMap<String, Cluster>> entityCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<ClusteringModel, BiMap<String, Cluster>>(){

        @Override
        public BiMap<String, Cluster> load(ClusteringModel clusteringModel) {
            HashBiMap<String, Cluster> result = HashBiMap.create();
            EntityUtil.putAll(clusteringModel.getClusters(), result);
            return result;
        }
    });

    public ClusteringModelEvaluator(PMML pmml) {
        this(pmml, ClusteringModelEvaluator.find(pmml.getModels(), ClusteringModel.class));
    }

    public ClusteringModelEvaluator(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml, clusteringModel);
    }

    @Override
    public String getSummary() {
        return "Clustering model";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ClusterClassificationMap> predictions;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        if (!clusteringModel.isScorable()) {
            throw new InvalidResultException(clusteringModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = clusteringModel.getFunctionName();
        switch (miningFunction) {
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException(clusteringModel, miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ClusterClassificationMap> evaluateClustering(EvaluationContext context) {
        ClusterClassificationMap result;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case CENTER_BASED: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException(clusteringModel, modelClass);
            }
        }
        ArrayList<FieldValue> values = Lists.newArrayList();
        List<ClusteringField> clusteringFields = this.getCenterClusteringFields();
        for (ClusteringField clusteringField : clusteringFields) {
            FieldValue value = ExpressionUtil.evaluate(clusteringField.getField(), context);
            values.add(value);
        }
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isSimilarity(measure)) {
            result = this.evaluateSimilarity(comparisonMeasure, clusteringFields, values);
        } else if (MeasureUtil.isDistance(measure)) {
            result = this.evaluateDistance(comparisonMeasure, clusteringFields, values);
        } else {
            throw new UnsupportedFeatureException(measure);
        }
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private ClusterClassificationMap evaluateSimilarity(ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ClusterClassificationMap result = new ClusterClassificationMap(ClassificationMap.Type.SIMILARITY);
        BitSet flags = MeasureUtil.toBitSet(values);
        BiMap<Cluster, String> inverseEntities = this.getEntityRegistry().inverse();
        List<Cluster> clusters = clusteringModel.getClusters();
        for (Cluster cluster : clusters) {
            BitSet clusterFlags = CacheUtil.getValue(cluster, clusterFlagCache);
            if (flags.size() != clusterFlags.size()) {
                throw new InvalidFeatureException(cluster);
            }
            String id = (String)inverseEntities.get(cluster);
            Double similarity = MeasureUtil.evaluateSimilarity(comparisonMeasure, clusteringFields, flags, clusterFlags);
            result.put(cluster, id, similarity);
        }
        return result;
    }

    private ClusterClassificationMap evaluateDistance(ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        Double adjustment;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ClusterClassificationMap result = new ClusterClassificationMap(ClassificationMap.Type.DISTANCE);
        MissingValueWeights missingValueWeights = clusteringModel.getMissingValueWeights();
        if (missingValueWeights != null) {
            Array array = missingValueWeights.getArray();
            List<Double> adjustmentValues = ArrayUtil.getRealContent(array);
            if (values.size() != adjustmentValues.size()) {
                throw new InvalidFeatureException(missingValueWeights);
            }
            adjustment = MeasureUtil.calculateAdjustment(values, adjustmentValues);
        } else {
            adjustment = MeasureUtil.calculateAdjustment(values);
        }
        BiMap<Cluster, String> inverseEntities = this.getEntityRegistry().inverse();
        List<Cluster> clusters = clusteringModel.getClusters();
        for (Cluster cluster : clusters) {
            List<FieldValue> clusterValues = CacheUtil.getValue(cluster, clusterValueCache);
            if (values.size() != clusterValues.size()) {
                throw new InvalidFeatureException(cluster);
            }
            String id = (String)inverseEntities.get(cluster);
            Double distance = MeasureUtil.evaluateDistance(comparisonMeasure, clusteringFields, values, clusterValues, adjustment);
            result.put(cluster, id, distance);
        }
        return result;
    }

    private List<ClusteringField> getCenterClusteringFields() {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ArrayList<ClusteringField> result = Lists.newArrayList();
        List<ClusteringField> clusteringFields = clusteringModel.getClusteringFields();
        block4: for (ClusteringField clusteringField : clusteringFields) {
            ClusteringField.CenterField centerField = clusteringField.getCenterField();
            switch (centerField) {
                case TRUE: {
                    result.add(clusteringField);
                    continue block4;
                }
                case FALSE: {
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException(clusteringField, centerField);
        }
        return result;
    }
}

