/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;

public abstract class EvaluationContext {
    private Deque<Map<FieldName, FieldValue>> stack = Queues.newArrayDeque();
    private List<String> warnings = Lists.newArrayList();

    public abstract DerivedField resolveField(FieldName var1);

    public abstract DefineFunction resolveFunction(String var1);

    public Map<FieldName, FieldValue> getArguments() {
        Deque<Map<FieldName, FieldValue>> stack = this.getStack();
        LinkedHashMap<FieldName, FieldValue> result = Maps.newLinkedHashMap();
        Iterator<Map<FieldName, FieldValue>> it = stack.descendingIterator();
        while (it.hasNext()) {
            Map<FieldName, FieldValue> frame = it.next();
            result.putAll(frame);
        }
        return result;
    }

    public FieldValue getArgument(FieldName name) {
        Map.Entry<FieldName, FieldValue> entry = this.getArgumentEntry(name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<FieldName, FieldValue> getArgumentEntry(FieldName name) {
        Deque<Map<FieldName, FieldValue>> stack = this.getStack();
        for (Map<FieldName, FieldValue> frame : stack) {
            if (!frame.containsKey(name)) continue;
            AbstractMap.SimpleEntry<FieldName, FieldValue> entry = new AbstractMap.SimpleEntry<FieldName, FieldValue>(name, frame.get(name));
            return entry;
        }
        return null;
    }

    public FieldValue createFieldValue(FieldName name, Object value) {
        return FieldValueUtil.create(value);
    }

    public Map<FieldName, FieldValue> pushFrame(Map<FieldName, ?> arguments) {
        Maps.EntryTransformer<FieldName, Object, FieldValue> transformer = new Maps.EntryTransformer<FieldName, Object, FieldValue>(){

            @Override
            public FieldValue transformEntry(FieldName name, Object value) {
                if (value instanceof FieldValue) {
                    return (FieldValue)value;
                }
                return EvaluationContext.this.createFieldValue(name, value);
            }
        };
        LinkedHashMap<FieldName, FieldValue> frame = Maps.newLinkedHashMap();
        frame.putAll(Maps.transformEntries(arguments, transformer));
        this.getStack().push(frame);
        return frame;
    }

    public Map<FieldName, FieldValue> popFrame() {
        return this.getStack().pop();
    }

    public void addWarning(String warning) {
        List<String> warnings = this.getWarnings();
        warnings.add(warning);
    }

    Deque<Map<FieldName, FieldValue>> getStack() {
        return this.stack;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

