/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.FieldValue;
import org.w3c.dom.Element;

public class InlineTableUtil {
    private static final LoadingCache<InlineTable, Table<Integer, String, String>> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<InlineTable, Table<Integer, String, String>>(){

        @Override
        public Table<Integer, String, String> load(InlineTable inlineTable) {
            return InlineTableUtil.parse(inlineTable);
        }
    });

    private InlineTableUtil() {
    }

    public static Table<Integer, String, String> getContent(InlineTable inlineTable) {
        return CacheUtil.getValue(inlineTable, cache);
    }

    public static Table<Integer, String, String> parse(InlineTable inlineTable) {
        HashBasedTable<Integer, String, String> result = HashBasedTable.create();
        Integer rowKey = 1;
        List<Row> rows = inlineTable.getRows();
        for (Row row : rows) {
            List<Object> cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                result.put(rowKey, element.getTagName(), element.getTextContent());
            }
            rowKey = rowKey + 1;
        }
        return Tables.unmodifiableTable(result);
    }

    public static Map<String, String> match(Table<Integer, String, String> table, Map<String, FieldValue> values) {
        Set<Integer> rowKeys = table.rowKeySet();
        block0: for (Integer rowKey : rowKeys) {
            Map<String, String> row = table.row(rowKey);
            if (values.size() < row.size() - 1) continue;
            Set<Map.Entry<String, FieldValue>> entries = values.entrySet();
            for (Map.Entry entry : entries) {
                boolean equals;
                String key = (String)entry.getKey();
                FieldValue value = (FieldValue)entry.getValue();
                String rowValue = row.get(key);
                if (rowValue != null && (equals = value.equalsString(rowValue))) continue;
                continue block0;
            }
            return row;
        }
        return null;
    }
}

