/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.OpType;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class MeasureUtil {
    private static final FieldValue ZERO = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, 0.0);
    private static final FieldValue ONE = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, 1.0);

    private MeasureUtil() {
    }

    public static boolean isSimilarity(Measure measure) {
        return measure instanceof SimpleMatching || measure instanceof Jaccard || measure instanceof Tanimoto || measure instanceof BinarySimilarity;
    }

    public static Double evaluateSimilarity(ComparisonMeasure comparisonMeasure, List<? extends ComparisonField> comparisonFields, BitSet flags, BitSet referenceFlags) {
        double denominator;
        double numerator;
        Measure measure = comparisonMeasure.getMeasure();
        double a11 = 0.0;
        double a10 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (int i = 0; i < comparisonFields.size(); ++i) {
            if (flags.get(i)) {
                if (referenceFlags.get(i)) {
                    a11 += 1.0;
                    continue;
                }
                a10 += 1.0;
                continue;
            }
            if (referenceFlags.get(i)) {
                a01 += 1.0;
                continue;
            }
            a00 += 1.0;
        }
        if (measure instanceof SimpleMatching) {
            numerator = a11 + a00;
            denominator = a11 + a10 + a01 + a00;
        } else if (measure instanceof Jaccard) {
            numerator = a11;
            denominator = a11 + a10 + a01;
        } else if (measure instanceof Tanimoto) {
            numerator = a11 + a00;
            denominator = a11 + 2.0 * (a10 + a01) + a00;
        } else if (measure instanceof BinarySimilarity) {
            BinarySimilarity binarySimilarity = (BinarySimilarity)measure;
            numerator = binarySimilarity.getC11Parameter() * a11 + binarySimilarity.getC10Parameter() * a10 + binarySimilarity.getC01Parameter() * a01 + binarySimilarity.getC00Parameter() * a00;
            denominator = binarySimilarity.getD11Parameter() * a11 + binarySimilarity.getD10Parameter() * a10 + binarySimilarity.getD01Parameter() * a01 + binarySimilarity.getD00Parameter() * a00;
        } else {
            throw new UnsupportedFeatureException(measure);
        }
        try {
            return numerator / denominator;
        }
        catch (ArithmeticException ae) {
            throw new InvalidResultException(null);
        }
    }

    public static BitSet toBitSet(List<FieldValue> values) {
        BitSet result = new BitSet(values.size());
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            if (ZERO.equalsValue(value)) {
                result.set(i, false);
                continue;
            }
            if (ONE.equalsValue(value)) {
                result.set(i, true);
                continue;
            }
            throw new EvaluationException();
        }
        return result;
    }

    public static boolean isDistance(Measure measure) {
        return measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof Chebychev || measure instanceof CityBlock || measure instanceof Minkowski;
    }

    public static Double evaluateDistance(ComparisonMeasure comparisonMeasure, List<? extends ComparisonField> comparisonFields, List<FieldValue> values, List<FieldValue> referenceValues, Double adjustment) {
        double innerPower;
        double outerPower;
        Measure measure = comparisonMeasure.getMeasure();
        if (measure instanceof Euclidean) {
            outerPower = 2.0;
            innerPower = 2.0;
        } else if (measure instanceof SquaredEuclidean) {
            innerPower = 2.0;
            outerPower = 1.0;
        } else if (measure instanceof Chebychev || measure instanceof CityBlock) {
            outerPower = 1.0;
            innerPower = 1.0;
        } else if (measure instanceof Minkowski) {
            Minkowski minkowski = (Minkowski)measure;
            double p = minkowski.getPParameter();
            if (p < 0.0) {
                throw new InvalidFeatureException(minkowski);
            }
            innerPower = outerPower = p;
        } else {
            throw new UnsupportedFeatureException(measure);
        }
        ArrayList<Double> distances = Lists.newArrayList();
        for (int i = 0; i < comparisonFields.size(); ++i) {
            ComparisonField comparisonField = comparisonFields.get(i);
            FieldValue value = values.get(i);
            if (value == null) continue;
            FieldValue referenceValue = referenceValues.get(i);
            Double distance = MeasureUtil.evaluateInnerFunction(comparisonMeasure, comparisonField, value, referenceValue, innerPower);
            distances.add(distance);
        }
        if (measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof CityBlock || measure instanceof Minkowski) {
            double sum = 0.0;
            for (Double distance : distances) {
                sum += distance.doubleValue();
            }
            return Math.pow(sum * adjustment, 1.0 / outerPower);
        }
        if (measure instanceof Chebychev) {
            Double max = (Double)Collections.max(distances);
            return max * adjustment;
        }
        throw new UnsupportedFeatureException(measure);
    }

    private static double evaluateInnerFunction(ComparisonMeasure comparisonMeasure, ComparisonField comparisonField, FieldValue value, FieldValue referenceValue, Double power) {
        double distance;
        CompareFunctionType compareFunction = comparisonField.getCompareFunction();
        if (compareFunction == null) {
            compareFunction = comparisonMeasure.getCompareFunction();
            switch (compareFunction) {
                case ABS_DIFF: 
                case DELTA: 
                case EQUAL: {
                    break;
                }
                case GAUSS_SIM: 
                case TABLE: {
                    throw new InvalidFeatureException(comparisonMeasure);
                }
                default: {
                    throw new UnsupportedFeatureException(comparisonMeasure, compareFunction);
                }
            }
        }
        switch (compareFunction) {
            case ABS_DIFF: {
                double z = MeasureUtil.difference(value, referenceValue);
                distance = Math.abs(z);
                break;
            }
            case GAUSS_SIM: {
                Double similarityScale = comparisonField.getSimilarityScale();
                if (similarityScale == null) {
                    throw new InvalidFeatureException(comparisonField);
                }
                double z = MeasureUtil.difference(value, referenceValue);
                double s = similarityScale;
                distance = Math.exp(-Math.log(2.0) * Math.pow(z, 2.0) / Math.pow(s, 2.0));
                break;
            }
            case DELTA: {
                boolean equals = MeasureUtil.equals(value, referenceValue);
                distance = equals ? 0.0 : 1.0;
                break;
            }
            case EQUAL: {
                boolean equals = MeasureUtil.equals(value, referenceValue);
                distance = equals ? 1.0 : 0.0;
                break;
            }
            case TABLE: {
                throw new UnsupportedFeatureException(comparisonField, compareFunction);
            }
            default: {
                throw new UnsupportedFeatureException(comparisonField, compareFunction);
            }
        }
        return comparisonField.getFieldWeight() * Math.pow(distance, power);
    }

    private static double difference(FieldValue x, FieldValue y) {
        return x.asNumber().doubleValue() - y.asNumber().doubleValue();
    }

    private static boolean equals(FieldValue x, FieldValue y) {
        return x.equalsValue(y);
    }

    public static Double calculateAdjustment(List<FieldValue> values, List<Double> adjustmentValues) {
        double sum = 0.0;
        double nonmissingSum = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            Double adjustmentValue = adjustmentValues.get(i);
            sum += adjustmentValue.doubleValue();
            nonmissingSum += value != null ? adjustmentValue : 0.0;
        }
        return sum / nonmissingSum;
    }

    public static Double calculateAdjustment(List<FieldValue> values) {
        double sum = 0.0;
        double nonmissingSum = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            sum += 1.0;
            nonmissingSum += value != null ? 1.0 : 0.0;
        }
        return sum / nonmissingSum;
    }
}

