/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeatureType;
import org.dmg.pmml.RuleFeatureType;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasClusterAffinity;
import org.jpmml.evaluator.HasClusterId;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.ResultFeature;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class OutputUtil {
    private OutputUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Map<FieldName, Object> evaluate(Map<FieldName, ?> predictions, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        Map<FieldName, FieldValue> frame = context.pushFrame(Collections.emptyMap());
        Output output = modelManager.getOrCreateOutput();
        List<OutputField> outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            void var9_9;
            FieldName targetField = outputField.getTargetField();
            if (targetField == null) {
                targetField = modelManager.getTargetField();
            }
            Object var9_10 = null;
            ResultFeatureType resultFeature = outputField.getFeature();
            if (resultFeature == null) {
                resultFeature = ResultFeatureType.PREDICTED_VALUE;
            }
            switch (resultFeature) {
                case PREDICTED_VALUE: 
                case PREDICTED_DISPLAY_VALUE: 
                case PROBABILITY: 
                case RESIDUAL: 
                case ENTITY_ID: 
                case CLUSTER_ID: 
                case AFFINITY: 
                case ENTITY_AFFINITY: 
                case CLUSTER_AFFINITY: 
                case REASON_CODE: 
                case RULE_VALUE: {
                    if (!predictions.containsKey(targetField)) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    Object obj = predictions.get(targetField);
                    break;
                }
            }
            block3 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    void var9_12;
                    Object object = OutputUtil.getPredictedValue(var9_12);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    void var9_12;
                    Target target = modelManager.getTarget(targetField);
                    Object object = OutputUtil.getPredictedDisplayValue(var9_12, target);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException(outputField);
                    }
                    FieldValue result = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    Object object = FieldValueUtil.getValue(result);
                    break;
                }
                case PROBABILITY: {
                    void var9_12;
                    Double d = OutputUtil.getProbability(var9_12, outputField);
                    break;
                }
                case RESIDUAL: {
                    void var9_12;
                    FieldValue expectedValue = context.getArgument(targetField);
                    if (expectedValue == null) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    DataField dataField = modelManager.getDataField(targetField);
                    OpType opType = dataField.getOptype();
                    switch (opType) {
                        case CONTINUOUS: {
                            Double d = OutputUtil.getContinuousResidual(var9_12, expectedValue);
                            break block3;
                        }
                        case CATEGORICAL: {
                            Double d = OutputUtil.getCategoricalResidual(var9_12, expectedValue);
                            break block3;
                        }
                    }
                    throw new UnsupportedFeatureException(outputField, opType);
                }
                case ENTITY_ID: {
                    void var9_12;
                    String string = OutputUtil.getEntityId(var9_12, outputField);
                    break;
                }
                case CLUSTER_ID: {
                    void var9_12;
                    String string = OutputUtil.getClusterId(var9_12);
                    break;
                }
                case AFFINITY: 
                case ENTITY_AFFINITY: {
                    void var9_12;
                    Double d = OutputUtil.getAffinity(var9_12, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: {
                    void var9_12;
                    Double d = OutputUtil.getClusterAffinity(var9_12);
                    break;
                }
                case REASON_CODE: {
                    void var9_12;
                    String string = OutputUtil.getReasonCode(var9_12, outputField);
                    break;
                }
                case RULE_VALUE: {
                    void var9_12;
                    Object object = OutputUtil.getRuleValue(var9_12, outputField);
                    break;
                }
                case WARNING: {
                    List<String> list = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException(outputField, resultFeature);
                }
            }
            frame.put(outputField.getName(), FieldValueUtil.create(outputField, var9_9));
        }
        context.popFrame();
        LinkedHashMap<FieldName, Object> result = Maps.newLinkedHashMap(predictions);
        Set<Map.Entry<FieldName, FieldValue>> entries = frame.entrySet();
        for (Map.Entry entry : entries) {
            result.put((FieldName)entry.getKey(), FieldValueUtil.getValue((FieldValue)entry.getValue()));
        }
        return result;
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, Target target) {
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = OutputUtil.asResultFeature(HasDisplayValue.class, object);
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null) {
            return targetValue.getDisplayValue();
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        HasProbability hasProbability = OutputUtil.asResultFeature(HasProbability.class, object);
        return hasProbability.getProbability(outputField.getValue());
    }

    private static Double getContinuousResidual(Object object, FieldValue expectedObject) {
        object = OutputUtil.getPredictedValue(object);
        Number value = (Number)object;
        Number expectedValue = (Number)FieldValueUtil.getValue(expectedObject);
        return expectedValue.doubleValue() - value.doubleValue();
    }

    public static Double getCategoricalResidual(Object object, FieldValue expectedObject) {
        String expectedValue;
        HasProbability hasProbability = OutputUtil.asResultFeature(HasProbability.class, object);
        String value = TypeUtil.format(object = OutputUtil.getPredictedValue(object));
        boolean equals = TypeUtil.equals(DataType.STRING, value, expectedValue = TypeUtil.format(FieldValueUtil.getValue(expectedObject)));
        return (equals ? 1.0 : 0.0) - hasProbability.getProbability(value);
    }

    private static String getEntityId(Object object, OutputField outputField) {
        HasEntityId hasEntityId = OutputUtil.asResultFeature(HasEntityId.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException(outputField);
        }
        if (rank > 1) {
            HasEntityIdRanking hasEntityIdRanking = OutputUtil.asResultFeature(HasEntityIdRanking.class, object);
            return OutputUtil.getElement(hasEntityIdRanking.getEntityIdRanking(), rank);
        }
        return hasEntityId.getEntityId();
    }

    private static String getClusterId(Object object) {
        HasClusterId hasClusterId = OutputUtil.asResultFeature(HasClusterId.class, object);
        return hasClusterId.getClusterId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        HasAffinity hasAffinity = OutputUtil.asResultFeature(HasAffinity.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException(outputField);
        }
        if (rank > 1) {
            HasAffinityRanking hasAffinityRanking = OutputUtil.asResultFeature(HasAffinityRanking.class, object);
            return OutputUtil.getElement(hasAffinityRanking.getAffinityRanking(), rank);
        }
        return hasAffinity.getAffinity(outputField.getValue());
    }

    public static Double getClusterAffinity(Object object) {
        HasClusterAffinity hasClusterAffinity = OutputUtil.asResultFeature(HasClusterAffinity.class, object);
        return hasClusterAffinity.getClusterAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        HasReasonCodeRanking hasReasonCodeRanking = OutputUtil.asResultFeature(HasReasonCodeRanking.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException(outputField);
        }
        return OutputUtil.getElement(hasReasonCodeRanking.getReasonCodeRanking(), rank);
    }

    public static Object getRuleValue(Object object, final OutputField outputField) {
        HasRuleValues hasRuleValues = OutputUtil.asResultFeature(HasRuleValues.class, object);
        List<AssociationRule> associationRules = hasRuleValues.getRuleValues(outputField.getAlgorithm());
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                int order;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        order = left.getConfidence().compareTo(right.getConfidence());
                        break;
                    }
                    case SUPPORT: {
                        order = left.getSupport().compareTo(right.getSupport());
                        break;
                    }
                    case LIFT: {
                        order = left.getLift().compareTo(right.getLift());
                        break;
                    }
                    case LEVERAGE: {
                        order = left.getLeverage().compareTo(right.getLeverage());
                        break;
                    }
                    case AFFINITY: {
                        order = left.getAffinity().compareTo(right.getAffinity());
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException(outputField, this.rankBasis);
                    }
                }
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedFeatureException(outputField, this.rankOrder);
            }
        };
        Collections.sort(associationRules, comparator);
        String isMultiValued = outputField.getIsMultiValued();
        if ("0".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank <= 0) {
                throw new InvalidFeatureException(outputField);
            }
            int index = rank - 1;
            if (index < associationRules.size()) {
                AssociationRule associationRule = associationRules.get(index);
                return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField);
            }
            return null;
        }
        if ("1".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank < 0) {
                throw new InvalidFeatureException(outputField);
            }
            int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
            associationRules = associationRules.subList(0, size);
            ArrayList<Object> result = Lists.newArrayList();
            for (AssociationRule associationRule : associationRules) {
                result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField));
            }
            return result;
        }
        throw new InvalidFeatureException(outputField);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField) {
        RuleFeatureType ruleFeature = outputField.getRuleFeature();
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on(',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                String id = associationRule.getId();
                if (id == null) {
                    BiMap<String, AssociationRule> associationRuleRegistry = hasRuleValues.getAssociationRuleRegistry();
                    id = (String)associationRuleRegistry.inverse().get(associationRule);
                }
                return id;
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedFeatureException(outputField, ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        ArrayList<String> result = Lists.newArrayList();
        BiMap<String, Item> itemRegistry = hasRuleValues.getItemRegistry();
        BiMap<String, Itemset> itemsetRegistry = hasRuleValues.getItemsetRegistry();
        Itemset itemset = (Itemset)itemsetRegistry.get(id);
        List<ItemRef> itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            Item item = (Item)itemRegistry.get(itemRef.getItemRef());
            result.add(item.getValue());
        }
        return result;
    }

    private static <E extends ResultFeature> E asResultFeature(Class<? extends E> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new TypeCheckException(clazz, object);
        }
        return (E)((ResultFeature)clazz.cast(object));
    }

    private static <E> E getElement(List<E> elements, int rank) {
        int index = rank - 1;
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }
}

