/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Targets;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.DefaultClassificationMap;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class TargetUtil {
    private TargetUtil() {
    }

    public static Map<FieldName, ? extends Number> evaluateRegression(Double value, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        FieldName targetField = modelManager.getTargetField();
        return TargetUtil.evaluateRegression(Collections.singletonMap(targetField, value), context);
    }

    public static Map<FieldName, ? extends Number> evaluateRegression(Map<FieldName, Double> predictions, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        Targets targets = modelManager.getOrCreateTargets();
        if (Iterables.isEmpty(targets)) {
            return predictions;
        }
        LinkedHashMap<FieldName, Number> result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, Double>> entries = predictions.entrySet();
        for (Map.Entry entry : entries) {
            FieldName key = (FieldName)entry.getKey();
            Number value = (Number)entry.getValue();
            Target target = modelManager.getTarget(key);
            if (target != null) {
                value = value != null ? (Number)TargetUtil.process(target, (Double)entry.getValue()) : (Number)TargetUtil.getDefaultValue(target);
            }
            result.put(key, value);
        }
        return result;
    }

    public static Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(ClassificationMap<?> value, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        FieldName targetField = modelManager.getTargetField();
        return TargetUtil.evaluateClassification(Collections.singletonMap(targetField, value), context);
    }

    public static Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(Map<FieldName, ? extends ClassificationMap<?>> predictions, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        Targets targets = modelManager.getOrCreateTargets();
        if (Iterables.isEmpty(targets)) {
            return predictions;
        }
        LinkedHashMap<FieldName, DefaultClassificationMap<String>> result = Maps.newLinkedHashMap();
        Set<Map.Entry<FieldName, ClassificationMap<?>>> entries = predictions.entrySet();
        for (Map.Entry entry : entries) {
            FieldName key = (FieldName)entry.getKey();
            DefaultClassificationMap<String> value = (DefaultClassificationMap<String>)entry.getValue();
            Target target = modelManager.getTarget(key);
            if (target != null && value == null) {
                value = TargetUtil.getPriorProbabilities(target);
            }
            result.put(key, value);
        }
        return result;
    }

    public static Number process(Target target, Double value) {
        Double max;
        double result = value;
        Double min = target.getMin();
        if (min != null) {
            result = Math.max(result, min);
        }
        if ((max = target.getMax()) != null) {
            result = Math.min(result, max);
        }
        result = result * target.getRescaleFactor() + target.getRescaleConstant();
        Target.CastInteger castInteger = target.getCastInteger();
        if (castInteger == null) {
            return result;
        }
        switch (castInteger) {
            case ROUND: {
                return (int)Math.round(result);
            }
            case CEILING: {
                return (int)Math.ceil(result);
            }
            case FLOOR: {
                return (int)Math.floor(result);
            }
        }
        throw new UnsupportedFeatureException(target, castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List<TargetValue> targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static Double getDefaultValue(Target target) {
        List<TargetValue> values = target.getTargetValues();
        if (values.size() != 1) {
            throw new InvalidFeatureException(target);
        }
        TargetValue value = values.get(0);
        if (value.getValue() != null || value.getPriorProbability() != null) {
            throw new InvalidFeatureException(value);
        }
        return value.getDefaultValue();
    }

    private static DefaultClassificationMap<String> getPriorProbabilities(Target target) {
        DefaultClassificationMap<String> result = new DefaultClassificationMap<String>();
        List<TargetValue> values = target.getTargetValues();
        for (TargetValue value : values) {
            if (value.getDefaultValue() != null) {
                throw new InvalidFeatureException(value);
            }
            result.put(value.getValue(), value.getPriorProbability());
        }
        return result;
    }
}

